<?php

namespace App\Http\Controllers;

use App\Worker;
use App\WorkReports;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Invoice;
use App\Setting;
use App\InvoicePayments;
use PDF;
use App\InvoiceHistorys;


class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $rol = "";
        $user = \App\User::find(Auth::id());
        
        if($user->hasRole('superAdmin')) $rol = "superAdmin";
        else if($user->hasRole('admin')) $rol = "admin";
        else $rol = "user";
        
        return view('app.index', ['user' => Auth::user(), "rol" => $rol]);
    }
    public function providers()
    {
        return view('provider.index',['user' => Auth::user()]);
    }
    public function workers()
    {
        return view('workers.index', ['user' => Auth::user()]);
    }
    public function products()
    {
        return view('products.index', ['user' => Auth::user()]);
    }
    public function services()
    {
        return view('services.index', ['user' => Auth::user()]);
    }
    public function estimates()
    {
        return view('estimates.index', ['user' => Auth::user()]);
    }
    public function invoices()
    {
        return view('invoices.index', ['user' => Auth::user()]);
    }
    public function expenses()
    {
        return view('expenses.index', ['user' => Auth::user()]);
    }
    public function provider_bills()
    {
        return view('bills.index', ['user' => Auth::user()]);
    }
    public function pdf($id)
    {
        $invoice = Invoice::with(["client","services", "products"])->where("id", $id)->firstOrFail();
        $total_paid = InvoicePayments::where("invoice_id", $id)->sum("paid");
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
    
    $pdf = PDF::loadView('pdf.index', [
            'invoice' => $invoice,
            'invoice_text' => Setting::where("var","invoice_text")->first(),
            'invoice_text1' => Setting::where("var","invoice_text1")->first(),
            'info' => $info,
            'total_paid' => $total_paid,
            'img'=> '',
        ]);
    
    $name = "";
    if($invoice->type == "invoice")
        $name = $invoice->client->name.'-invoice-'.$invoice->number."-".date("m/d/Y").".pdf";
    else $name = $invoice->client->name.'-estimate-'.$invoice->id."-".date("m/d/Y").".pdf";
    return $pdf->download($name);
    }
    public function generatePdf($id)
    {
        $invoice = Invoice::with(["client","services", "products"])->where("id", $id)->firstOrFail();
       // if(file_exists(public_path('pdf/').$invoice->pdf)) @unlink(public_path('pdf/').$invoice->pdf);
        $total_paid = InvoicePayments::where("invoice_id", $id)->sum("paid");
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
    
    $pdf = PDF::loadView('pdf.index', [
            'invoice' => $invoice,
            'invoice_text' => Setting::where("var","invoice_text")->first(),
            'invoice_text1' => Setting::where("var","invoice_text1")->first(),
            'info' => $info,
            'total_paid' => $total_paid,
            'img'=> '',
        ]);
    
    $name = "";
    if($invoice->type == "invoice")
        $name = str_slug($invoice->client->name).'-invoice-'.$invoice->number."-".date("m-d-Y-his").".pdf";
    else $name = str_slug($invoice->client->name).'-estimate-'.$invoice->id."-".date("m-d-Y-his").".pdf";
    $pdf->save("pdf/".$name);
    $invoice->pdf = $name;
    $invoice->save();
    InvoiceHistorys::create([
        'type'=> $invoice->type,
        'number'=> $invoice->number,
        'invoice_id'=> $invoice->id,
        'client_id' => $invoice->client->client_id,
        'pdf'=> $invoice->pdf,
        'signed'=> 'N'
    ]);   
    return $invoice;
    }
    public function generatePdfSign(Request $request)
    {
        $id = $request->get("id");
        $img = $request->get('img');
        $invoice = Invoice::with(["client","services", "products"])->where("id", $id)->firstOrFail();
        //if(file_exists(public_path('pdf/').$invoice->pdf_signed)) @unlink(public_path('pdf/').$invoice->pdf_signed);
        $total_paid = InvoicePayments::where("invoice_id", $id)->sum("paid");
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
    
    $pdf = PDF::loadView('pdf.index', [
            'invoice' => $invoice,
            'invoice_text' => Setting::where("var","invoice_text")->first(),
            'invoice_text1' => Setting::where("var","invoice_text1")->first(),
            'info' => $info,
            'total_paid' => $total_paid,
            'img'=> $img,
        ]);
    
    $name = "";
    if($invoice->type == "invoice")
        $name = str_slug($invoice->client->name).'-invoice-'.$invoice->number."-".date("m-d-Y-his")."-signed.pdf";
    else $name = str_slug($invoice->client->name).'-estimate-'.$invoice->id."-".date("m-d-Y-his")."-signed.pdf";
    $pdf->save("pdf/".$name);
    $invoice->pdf_signed = $name;
    $invoice->save();
    InvoiceHistorys::create([
        'type'=> $invoice->type,
        'number'=> $invoice->number,
        'invoice_id'=> $invoice->id,
        'client_id' => $invoice->client->client_id,
        'pdf'=> $invoice->pdf,
        'signed'=> 'Y'
    ]);   
    return $invoice;
    }
    public function pdft(Request $request)
    {
        $invoice = Invoice::with(["client","services", "products"])->where("id", $request->get("id"))->firstOrFail();
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
    
    $pdf = PDF::loadView('pdf.indext', [
            'invoice' => $invoice,
            'invoice_text' => Setting::where("var","invoice_text")->first(),
            'invoice_text1' => Setting::where("var","invoice_text1")->first(),
            'tnumber' => $request->get("tnumber"),
            'info' => $info,
            'img'=> '',
        ]);
    
    $name = "";
    if($invoice->type == "invoice")
        $name = $invoice->client->name.'-invoice-'.$invoice->number."-".date("m/d/Y").".pdf";
    else $name = $invoice->client->name.'-estimate-'.$invoice->id."-".date("m/d/Y").".pdf";
    return $pdf->download($name);
    }

    public function report($id)
    {
        $worker = Worker::findOrFail($id);
        $work_reports = WorkReports::where(["worker_id" => $id, "status" => "UnPaid"])->get();

        $pdf = PDF::loadView('reports.pdf', [
            'worker' => $worker,
            'work_reports' => $work_reports,
        ]);

        $name = $worker->name . '-' . date("m-d-Y").".pdf";

        return $pdf->download($name);
    }

    public function reportDate($id, $date)
    {
        $worker = Worker::findOrFail($id);
        $work_reports = WorkReports::where([
            "worker_id" => $id,
            "status" => "Paid",
            "date_paid" => $date
        ])->get();

        $pdf = PDF::loadView('reports.pdf', [
            'worker' => $worker,
            'work_reports' => $work_reports,
        ]);

        $name = $worker->name . '-' . date("m-d-Y").".pdf";

        return $pdf->download($name);
    }
    public function getPdfHistory(Request $request){
        $client_id= $request->get('id');
        $pdfh= InvoiceHistorys::where('client_id', $client_id)
            ->orderBy('created_at', 'DESC')
            ->get();
        return $pdfh;

    }
}
