<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Email;
use Illuminate\Support\Facades\DB;

class EmailsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //select(['id','invoice','to','name','images','created_at','updated_at'])
        $per_page = 25;
       //DB::enableQueryLog();
        if(!empty($request->get("per_page"))) $per_page =  $request->get("per_page");

        $data = Email::when($request->get("type"), function($query) use ($request){
            if ($request->get("type")=="Estimate"){
                return $query->whereNull("emails.invoice");
            }else{
                return $query->where("emails.invoice", "like","%".$request->get("type")."%");
            }
            
        })
        ->when($request->get("name"), function($query) use ($request){
           
                return $query->where("emails.name", "like","%".$request->get("name")."%");
         
        })
        ->when($request->get("email"), function($query) use ($request){
         
                return $query->where("emails.to", "like","%".$request->get("email")."%");
         
            
        })
        ->when($request->get("datefrom"), function($query) use ($request){
            $date = date('Y-m-d', strtotime($request->get("datefrom")));
            return $query->whereRaw("DATE_FORMAT(emails.created_at, '%Y-%m-%d') >='" . $date ."'");
        })
        ->when($request->get("dateto"), function($query) use ($request){
            $date = date('Y-m-d', strtotime($request->get("dateto")));
            return $query->whereRaw("DATE_FORMAT(emails.created_at, '%Y-%m-%d') <='" . $date ."'");
        })
                ->select(DB::raw('emails.id,emails.to,emails.pdf,emails.created_at,if(emails.invoice is null,"Estimate",emails.invoice) as invoice,emails.name, emails.images'))
                ->orderBy('id','DESC')
            ->paginate($per_page);
        /*$qq =  DB::getQueryLog();
        dd($qq);
        exit;*/
        return [
            'pagination' => [
                'total'         => $data->total(),
                'current_page'  => $data->currentPage(),
                'per_page'      => $data->perPage(),
                'last_page'     => $data->lastPage(),
                'from'          => $data->firstItem(),
                'to'            => $data->lastItem(),
            ],
            "emails" => $data
        ];
    }
    public function getTypes(Request $request){
        $data = Email::when($request->get("type"), function($query) use ($request){
            if ($request->get("type")=="Estimate"){
                return $query->whereNull("emails.invoice");
            }else{
                return $query->where("emails.invoice", "like","%".$request->get("type")."%");
            }
            
        })
        ->select(DB::raw('if(emails.invoice is null,"Estimate",emails.invoice) as invoice'))
        ->orderBy('invoice','DESC')
        ->distinct()->get();
     
        return $data;

    }
    public function getEmails(Request $request){
        $data = Email::when($request->get("email"), function($query) use ($request){
                return $query->where("emails.to", "like","%".$request->get("email")."%");
        })
        ->select(DB::raw('emails.to as email'))
        ->whereNotNull('emails.to')
        ->orderBy('emails.to','ASC')
        ->distinct()->get();
     
        return $data;

    }
    public function getNames(Request $request){
        $data = Email::when($request->get("name"), function($query) use ($request){
                return $query->where("emails.name", "like","%".$request->get("name")."%");
        })
        ->select(DB::raw('emails.name as name'))
        ->whereNotNull('emails.name')
        ->orderBy('emails.name','ASC')
        ->distinct()->get();
     
        return $data;

    }
    public function searchEmails(Request $request){
        $per_page = 25;
        if(!empty($request->get("per_page"))) $per_page =  $request->get("per_page");

        $data = Email::select(DB::raw('emails.id,emails.to,if(emails.invoice is null,"Estimate",emails.invoice) as invoice,emails.name'))
                ->orderBy('id','DESC')
            ->paginate($per_page);
        return [
            'pagination' => [
                'total'         => $data->total(),
                'current_page'  => $data->currentPage(),
                'per_page'      => $data->perPage(),
                'last_page'     => $data->lastPage(),
                'from'          => $data->firstItem(),
                'to'            => $data->lastItem(),
            ],
            "emails" => $data
        ];

    }
}
