<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Event;

class EventsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if(!empty($request->get("search"))) {
            $data = Event::where("name", "like", "%".$request->get("search")."%")
                    ->orWhere("phone_number", "like", "%".$request->get("search")."%")
                    ->orWhere("email", "like", "%".$request->get("search")."%")
                    ->orWhere("subject", "like", "%".$request->get("search")."%")
                    ->orWhere("comment", "like", "%".$request->get("search")."%")
                    ->orderBy('id','DESC')
                    ->paginate(25);
        }
        else {
            $data = Event::orderBy('id','DESC')->paginate(25);
        }
        return [
            'pagination' => [
                'total'         => $data->total(),
                'current_page'  => $data->currentPage(),
                'per_page'      => $data->perPage(),
                'last_page'     => $data->lastPage(),
                'from'          => $data->firstItem(),
                'to'            => $data->lastItem(),
            ],
            "events" => $data
        ];
    }
    public function getAll(){
        $data = Event::get();
        return $data;
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            "name" => 'required',
            "phone_number" => 'required',
            "email" => 'required',
            "date" => 'required',
            "subject" => 'required',
            "comment" => 'required',
        ]);
        Event::create($request->all());
        return;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function setDate(Request $request) {
        $event = Event::find($request->get("id"));
        $event->date = date("Y-m-d H:i", strtotime($request->get("date")));
        $event->save();
    }
    public function external(Request $request){
        $this->validate($request, [
            "name" => 'required',
            "phone_number" => 'required',
            "email" => 'required',
            "date" => 'required',
            "subject" => 'required',
            "comment" => 'required',
        ]);
        $event = new Event;
        $event->name = $_POST['name'];
        $event->phone_number = $_POST['phone_number'];
        $event->email = $_POST['email'];
        $event->date = $_POST['date'];
        $event->subject = $_POST['subject'];
        $event->comment = $_POST['comment'];
        $event->save();
        return;
    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            "name" => 'required',
            "phone_number" => 'required',
            "email" => 'required',
            "date" => 'required',
            "subject" => 'required',
            "comment" => 'required',
            "date" => 'required',
        ]);
        Event::find($id)->update($request->all());
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Event::findOrFail($id);
        $data->delete();
    }
}
