<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\ProviderBills;
use App\ProviderBillsLine;
use App\Product;
use Illuminate\Support\Facades\DB;

class ProviderBillsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if(!empty($request->get("search"))) {
            $data = ProviderBills::with(["provider","payment_methods", "provider_bills_lines"])
                    ->join('providers', 'provider_bills.provider_id', '=', 'providers.id')
                    ->join('payment_methods', 'provider_bills.payment_methods_id', '=', 'payment_methods.id')
                    ->where("provider_bills.invoice_number", "like", "%".$request->get("search")."%")
                    ->orWhere(DB::raw("DATE_FORMAT(provider_bills.date, '%d %M %Y')"), "like", "%".$request->get("search")."%")
                    ->orWhere("providers.name", "like", "%".$request->get("search")."%")
                    ->orWhere("payment_methods.name", "like", "%".$request->get("search")."%")
                    ->orWhere("provider_bills.total", "like", "%".$request->get("search")."%")
                    ->orWhere("provider_bills.status", "like", "%".$request->get("search")."%")
                    ->orderBy('provider_bills.id','DESC')
                    ->select("provider_bills.*")
                    ->paginate(25);
        }
        else {
            $data = ProviderBills::with(["provider","payment_methods", "provider_bills_lines"])->orderBy('id','DESC')->paginate(25);
        }
        return [
            'pagination' => [
                'total'         => $data->total(),
                'current_page'  => $data->currentPage(),
                'per_page'      => $data->perPage(),
                'last_page'     => $data->lastPage(),
                'from'          => $data->firstItem(),
                'to'            => $data->lastItem(),
            ],
            "bills" => $data
        ];
    }
    public function search(){
        $providerBills = ProviderBills::with("provider", "payment_methods")->get();
        return $providerBills;
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            "provider_id" => 'required',
            "invoice_number" => 'required|unique_with:provider_bills,provider_id',
            "date" => 'required',
            "payment_methods_id" => 'required',
            "sub_total" => 'required',
            "tax" => 'required',
            "total" => 'required',
            "status" => 'required',
            "status" => 'required',
        ]);
        $bill = ProviderBills::create($request->all()); 
        if($bill) {
            $provider_bills_lines = $request->get("provider_bills_lines");
            foreach ($provider_bills_lines as $item) {
                $line = new ProviderBillsLine;
                $line->qty = $item['qty'];
                $line->description = $item['description'];
                $line->price_u = $item['price_u'];
                $line->product_id = $item['product_id'];
                $line->amount = $item['amount'];
                $line->provider_bills_id = $bill->id;
                $line->save();
                
                $product = Product::find($line->product_id);
                if($product) {
                    $product->qty = $product->qty + $line->qty;
                    $product->save();
                }
            }
        }
        return;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        print_r($id);
        $this->validate($request, [
            "provider_id" => 'required',
            "invoice_number" => 'required',
            "date" => 'required',
            "payment_methods_id" => 'required',
            "sub_total" => 'required',
            "tax" => 'required',
            "total" => 'required'
        ]);
        if(ProviderBills::find($id)->update($request->all())){
            
            $temp = ProviderBillsLine::where("provider_bills_id",$id)->get();
            foreach ($temp as $item) {
                $product = Product::find($item->product_id);
                if($product) {
                    $product->qty = $product->qty - $item->qty;
                    if($product->qty < 0) $product->qty = 0;
                    $product->save();
                }
            }
            ProviderBillsLine::where("provider_bills_id",$id)->delete();
            $provider_bills_lines = $request->get("provider_bills_lines");
            
            foreach ($provider_bills_lines as $item) {
                $line = new ProviderBillsLine;
                $line->qty = $item['qty'];
                $line->description = $item['description'];
                $line->price_u = $item['price_u'];
                $line->amount = $item['amount'];
                $line->product_id = $item['product_id'];
                $line->provider_bills_id = $id;
                $line->save();
                
                $product = Product::find($line->product_id);
                if($product) {
                    $product->qty = $product->qty + $line->qty;
                    $product->save();
                }
            }
        }
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $temp = ProviderBillsLine::where("provider_bills_id",$id)->get();
        foreach ($temp as $item) {
            $product = Product::find($item->product_id);
            if($product) {
                $product->qty = $product->qty - $item->qty;
                $product->save();
            }
        }
        ProviderBillsLine::where("provider_bills_id",$id)->delete();
        $data = ProviderBills::findOrFail($id);
        $data->delete();
    }
    
    public function stadistics() {
        return [
            "stadistics" => [
                "bills_qty" => ProviderBills::count(),
                "general_balance" => ProviderBills::sum("total"),
                "total_paid" => ProviderBills::where("status", "Paid")->sum("total"),
            ],
        ];
    }
}
