<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\Setting;
use App\Provider;
use App\Service;
use App\ProviderBills;
use PDF;
class ReportsController extends Controller
{
    public function listOfServices(){
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
        return view('reports.list_of_services', [
                'products' => Service::all(),
                'pdf' => false,
                'info' => $info
            ]);
    }
    public function listOfServicesPDF(){
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
        $pdf = PDF::loadView('reports.list_of_services', [
                'products' => Service::all(),
                'pdf' => false,
                'info' => $info
            ]);

        $name = "list-of-services";
        return $pdf->download($name);
    }
    public function listOfProducts(){
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
        return view('reports.list_of_products', [
                'products' => Product::with("provider")->get(),
                'pdf' => false,
                'info' => $info
            ]);
    }
    public function listOfProductsPDF(){
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
        $pdf = PDF::loadView('reports.list_of_products', [
                    'products' => Product::with("provider")->get(),
                    'pdf' => true,
                    'info' => $info
                ]);

        $name = "list-of-products";
        return $pdf->download($name);
    }
    
    public function listOfProviders(){
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
        return view('reports.list_of_providers', [
                'providers' => Provider::all(),
                'pdf' => false,
                'info' => $info
            ]);
    }
    
    public function listOfProvidersPDF(){
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
        $pdf = PDF::loadView('reports.list_of_providers', [
                'providers' => Provider::all(),
                'pdf' => true,
                'info' => $info
            ]);

        $name = "list-of-providers";
        return $pdf->download($name);
    }
    
    public function listOfProvidersDebts(){
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
        $providers = Provider::all();
        $response= [];
        foreach ($providers as $provider) {
            $response [] = [
                "provider" => $provider,
                "cant_bills" => ProviderBills::where(["provider_id" => $provider->id])->count(),
                "cant_bills_unpaid" => ProviderBills::where(["provider_id" => $provider->id, "status" => "UnPaid"])->count(),
                "debts" => ProviderBills::where(["provider_id" => $provider->id, "status" => "UnPaid"])->sum("total"),
            ];
        }
        return view('reports.list_of_providers-debts', [
                'data' => $response,
                'pdf' => false,
                'info' => $info
            ]);
    }
    
    public function listOfProvidersDebtsPDF(){
        $info = [
            'company_name' => Setting::where("var","company_name")->first(),
            'company_adress' => Setting::where("var","company_adress")->first(),
            'company_city' => Setting::where("var","company_city")->first(),
            'company_state' => Setting::where("var","company_state")->first(),
            'company_zip' => Setting::where("var","company_zip")->first(),
            'company_person' => Setting::where("var","company_person")->first(),
            'company_email' => Setting::where("var","company_email")->first(),
            'company_phone' => Setting::where("var","company_phone")->first(),
        ];
        $providers = Provider::all();
        $response= [];
        foreach ($providers as $provider) {
            $response [] = [
                "provider" => $provider,
                "cant_bills" => ProviderBills::where(["provider_id" => $provider->id])->count(),
                "cant_bills_unpaid" => ProviderBills::where(["provider_id" => $provider->id, "status" => "UnPaid"])->count(),
                "debts" => ProviderBills::where(["provider_id" => $provider->id, "status" => "UnPaid"])->sum("total"),
            ];
        }
        $pdf = PDF::loadView('reports.list_of_providers-debts', [
                'data' => $response,
                'pdf' => true,
                'info' => $info
            ]);

        $name = "list-of-providers-debts";
        return $pdf->download($name);
    }
}
