<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('type');
            $table->integer('number')->unsigned()->nullable();
            $table->integer('related_invoice')->unsigned()->nullable();
            $table->double('deposit')->unsigned()->nullable();
            $table->double('subtotal')->unsigned()->default(0);
            $table->double('discount')->unsigned()->nullable();
            $table->double('tax')->unsigned()->nullable();
            $table->double('total')->unsigned()->default(0);
            $table->integer('h')->unsigned()->default(0);
            $table->string('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
