<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProviderBillsLinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('provider_bills_lines', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->integer('provider_bills_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->integer('qty');
            $table->text('description');
            $table->double('price_u');
            $table->double('amount');
            $table->timestamps();
            $table->foreign('provider_bills_id')->references('id')->on('provider_bills');
            $table->foreign('product_id')->references('id')->on('products');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('provider_bills_lines');
    }
}
