@extends('layouts.login')

@section('content')
<!-- BEGIN LOGIN -->

<div class="content">
	<!-- BEGIN LOGIN FORM -->
	<form class="login-form" action="{{ route('login') }}" method="post">
            {{ csrf_field() }}
		<h3 class="form-title">Login to your account</h3>
                @if ($errors->has('email'))
                    <div class="alert alert-danger">
                            <button class="close" data-close="alert"></button>
                            <span>
                            {{ $errors->first('email') }}</span>
                    </div>
                @endif
                @if ($errors->has('password'))
                    <div class="alert alert-danger">
                            <button class="close" data-close="alert"></button>
                            <span>
                            {{ $errors->first('password') }}</span>
                    </div>
                @endif
		<div class="form-group">
			<!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
			<label class="control-label visible-ie8 visible-ie9">E-Mail Address</label>
			<div class="input-icon">
				<i class="fa fa-user"></i>
				<input id="email" type="email" class="form-control" name="email" value="{{ old('email') }}" required autofocus>
			</div>
		</div>
		<div class="form-group">
			<label class="control-label visible-ie8 visible-ie9">Password</label>
			<div class="input-icon">
				<i class="fa fa-lock"></i>
				<input id="password" type="password" class="form-control" name="password" required>
			</div>
		</div>
		<div class="form-actions">
                        <label>
                            <input type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}> Remember Me
                        </label>
			<button type="submit" class="btn blue pull-right">
			Login <i class="m-icon-swapright m-icon-white"></i>
			</button>
		</div>
		<div class="forget-password">
			<h4>Forgot your password ?</h4>
			<p>
				 no worries, click <a href="{{ route('password.request') }}" id="forget-password">
				here </a>
				to reset your password.
			</p>
		</div>
	</form>
	<!-- END LOGIN FORM -->
</div>
<!-- END LOGIN -->
@endsection
