<div id="create" class="modal fade bs-modal-lg" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-large">
                <div class="modal-content">
                    <form method="POST">
                        <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                <h4 class="modal-title">@{{create == true? 'Create new Provider Bils' : 'Update Provider Bills'}}</h4>
                        </div>
                        <div class="modal-body">
                            <div class="tabbable">
                                <ul class="nav nav-tabs">
                                    <li class="active">
                                            <a href="#update_view" data-toggle="tab" aria-expanded="true">
                                            @{{create == true ? 'Create View' : 'Update View'}} </a>
                                    </li>
                                </ul>
                                <div class="tab-content no-space">
                                    <div class="tab-pane fade active in" id="update_view">
                                        <div class="panel panel-default">
                                            <div class="panel-body">
                                                <div class="alert alert-danger" v-if="errors != ''">
                                                    <span v-for="error in errors">@{{ error }}<br/></span>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <v-select :option="providers" @change="changeModel" d-name="provider" d-text="Select the Provider" :d-required="true"></v-select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <v-input d-name="invoice_number" d-label="Invoice Number" v-model="newBill.invoice_number" :d-required="true" d-placeholder="Enter invoice number" d-type="number"></v-input>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label>Date<span>*</span></label>
                                                            <div class="input-group input-medium date date-picker form-control-inline" data-date-format="yyyy-mm-dd" size="16" type="text" value="">
                                                                    <input type="text" class="form-control" readonly v-model="newBill.date" required="true" name="date">
                                                                    <span class="input-group-btn">
                                                                    <button class="btn default" type="button"><i class="fa fa-calendar"></i></button>
                                                                    </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="description">Description<span>*</span></label>
                                                            <textarea class="form-control" rows="2"  v-model="newBill.description" required="true" name="bills_description"></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <v-select :option="payment_methods" @change="changeModelPayment" d-name="payment_methods" d-text="Select the payment methods" :d-required="true"></v-select>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <v-input d-name="sub_total" d-label="Sub-Total" v-model="newBill.sub_total" :d-required="true" d-placeholder="Enter the sub-total" d-type="number"></v-input>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <v-input d-name="tax" v-model="newBill.tax" :d-required="true" d-placeholder="Enter the tax" d-type="number"></v-input>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <v-input d-name="total" v-model="total" :d-required="true" d-placeholder="Enter the total" d-type="number" :d-readonly="true"></v-input>
                                                    </div>
                                                </div>
                                                <h3 class="page-header">Items</h3>
                                                <div class="panel panel-default">
                                                    <div class="panel-body">
                                                        <div class="row">
                                                            <div class="col-md-4">
                                                                <v-input d-name="qty" v-model="newItem.qty" d-placeholder="Enter the qty" d-type="number"></v-input>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <v-input d-name="price_u" v-model="newItem.price_u" d-placeholder="Enter the price u" d-type="number"></v-input>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <v-input d-name="amount" v-model="amount" d-placeholder="Enter the amount" d-type="number" :d-readonly="true"></v-input>
                                                            </div>
                                                            <div class="col-md-10">
                                                                <div class="form-group">
                                                                    <label for="description">Description<span>*</span></label>
                                                                    <textarea class="form-control" rows="2"  v-model="newItem.description" name="description"></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <br/><br/>
                                                                <div class="btn-group form-md-line-input">
                                                                    <button id="additem" type="button" class="btn green" style="margin-top: 20px;" @click="addItem">Add New Item <i class="fa fa-plus"></i></button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <table_line_bills :loading="loading" :items="newBill.provider_bills_lines" @delete="deleteItem"></table_line_bills>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                        <button type="button" data-dismiss="modal" class="btn default">Close</button>
                                        <button type="button" class="btn default green" v-on:click="executeForm(newBill)">Save</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
        </div>
</div>
