<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<!--<![endif]-->
<!-- BEGIN HEAD -->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>
    
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <meta http-equiv="Content-type" content="text/html; charset=utf-8">
    <meta content="" name="description"/>
    <meta content="" name="author"/>
<!-- BEGIN GLOBAL MANDATORY STYLES -->

    <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css">
    <link href="{{ asset('theme/global/plugins/font-awesome/css/font-awesome.min.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/global/plugins/simple-line-icons/simple-line-icons.min.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/global/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/global/plugins/uniform/css/uniform.default.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/global/css/components.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/global/css/plugins.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/admin/layout2/css/layout.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/admin/layout2/css/themes/grey.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/admin/pages/css/invoice.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/global/plugins/bootstrap-toastr/toastr.min.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/global/plugins/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/global/plugins/bootstrap-datepicker/css/datepicker3.css') }}" rel="stylesheet">
    <link href="{{ asset('theme/admin/layout2/css/custom.css') }}" rel="stylesheet">

<!-- END THEME STYLES -->
<link rel="shortcut icon" href="favicon.ico"/>
</head>
<!-- END HEAD -->
<!-- BEGIN BODY -->
<body class="page-header-fixed page-container-bg-solid page-sidebar-closed-hide-logo page-header-fixed-mobile page-footer-fixed1">
<!-- BEGIN HEADER -->
<div class="page-header navbar navbar-fixed-top">
	<!-- BEGIN HEADER INNER -->
	<div class="page-header-inner">
		<!-- BEGIN LOGO -->
		<div class="page-logo">
			<a href="{{route('home')}}">
                            <p class="logo-default">V-ERP</p>
			</a>
			<div class="menu-toggler sidebar-toggler">
				<!-- DOC: Remove the above "hide" to enable the sidebar toggler button on header -->
			</div>
		</div>
		<!-- END LOGO -->
		<!-- BEGIN RESPONSIVE MENU TOGGLER -->
		<a href="javascript:;" class="menu-toggler responsive-toggler" data-toggle="collapse" data-target=".navbar-collapse">
		</a>
		<!-- END RESPONSIVE MENU TOGGLER -->
		<!-- BEGIN PAGE TOP -->
		<div class="page-top">
			<!-- BEGIN TOP NAVIGATION MENU -->
			<div class="top-menu">
				<ul class="nav navbar-nav pull-right">
					<li class="dropdown dropdown-user">
						<a href="javascript:;" class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true">
						<img alt="" class="img-circle" src="theme/admin/layout2/img/avatar3_small.jpg"/>
						<span class="username username-hide-on-mobile">
						{{$user['email']}} </span>
						<i class="fa fa-angle-down"></i>
						</a>
						<ul class="dropdown-menu dropdown-menu-default">
							<li>
								<a href="#">
								<i class="icon-user"></i> My Profile </a>
							</li>
							<li class="divider">
							</li>
							<li>
								<a href="{{ route('logout') }}"
                                            onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
								<i class="icon-key"></i> Log Out </a>
                                         <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                            {{ csrf_field() }}
                                        </form>
							</li>
						</ul>
					</li>
					<!-- END USER LOGIN DROPDOWN -->
				</ul>
			</div>
			<!-- END TOP NAVIGATION MENU -->
		</div>
		<!-- END PAGE TOP -->
	</div>
	<!-- END HEADER INNER -->
</div>
<!-- END HEADER -->
<div class="clearfix">
</div>
<!-- BEGIN CONTAINER -->
<div class="page-container">
	<!-- BEGIN SIDEBAR -->
	<div class="page-sidebar-wrapper">
		<div class="page-sidebar navbar-collapse collapse">
			<!-- BEGIN SIDEBAR MENU -->
			<ul class="page-sidebar-menu page-sidebar-menu-hover-submenu " data-keep-expanded="false" data-auto-scroll="true" data-slide-speed="200">
				<li class="start">
					<a href="{{ route('estimates') }}">
					<i class="icon-basket"></i>
					<span class="title">Estimated</span>
					</a>
				</li>
				<li>
					<a href="{{ route('invoices') }}">
					<i class="icon-basket"></i>
					<span class="title">Invoice</span>
					</a>
				</li>
				<li>
					<a href="{{ route('provider-bills') }}">
					<i class="icon-briefcase"></i>
					<span class="title">Provider bills</span>
					</a>
				</li>
				<li>
					<a href="{{ route('expenses') }}">
					<i class="fa fa-money"></i>
					<span class="title">Expenses</span>
					</a>
				</li>
				<li>
					<a href="{{ route('workers') }}">
					<i class="icon-wrench"></i>
					<span class="title">Workers</span>
					</a>
				</li>
				<li>
					<a href="{{ route('providers') }}">
					<i class="icon-briefcase"></i>
					<span class="title">Providers</span>
					</a>
				</li>
				<li>
					<a href="{{ route('services') }}">
					<i class="icon-wrench"></i>
					<span class="title">Services</span>
					</a>
				</li>
				<li>
					<a href="{{ route('products') }}">
					<i class="icon-wrench"></i>
					<span class="title">Products</span>
					</a>
				</li>
				<li>
					<a href="#">
					<i class="icon-list"></i>
					<span class="title">REPORTES</span>
					</a>
				</li>

			</ul>
			<!-- END SIDEBAR MENU -->
		</div>
	</div>
	<!-- END SIDEBAR -->
	<!-- BEGIN CONTENT -->
	<div class="page-content-wrapper">
		<div class="page-content">
			<div class="page-bar">
                            @yield('breadcrumb')
			</div>
			<!-- END PAGE HEADER-->
			<!-- BEGIN PAGE CONTENT-->
			<div class="row">
				<div class="col-md-12">
					 @yield('content')
				</div>
			</div>
			<!-- END PAGE CONTENT-->
		</div>
	</div>
	<!-- END CONTENT -->
	<!-- BEGIN QUICK SIDEBAR -->
	<!--Cooming Soon...-->
	<!-- END QUICK SIDEBAR -->
</div>
<!-- END CONTAINER -->
<!-- BEGIN FOOTER -->
<div class="page-footer">
	<div class="page-footer-inner">
		 <?php echo date('Y')?> &copy; Ctrlbook by Rich@r System Production.
	</div>
	<div class="scroll-to-top">
		<i class="icon-arrow-up"></i>
	</div>
</div>
<!-- END FOOTER -->
    <script src="{{ asset('theme/global/plugins/jquery.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/jquery-migrate.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/jquery-ui/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/bootstrap/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/jquery.blockui.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/jquery.cokie.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/uniform/jquery.uniform.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/bootstrap-toastr/toastr.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/bootbox/bootbox.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/bootstrap-select/bootstrap-select.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/jquery-inputmask/jquery.inputmask.bundle.min.js') }}"></script>
    <script src="{{ asset('theme/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js') }}"></script>
    <script src="{{ asset('theme/admin/layout2/scripts/demo.js') }}"></script>
    <script src="{{ asset('theme/global/scripts/metronic.js') }}"></script>
    <script src="{{ asset('theme/admin/layout2/scripts/layout.js') }}"></script>
    <script src="{{ asset('theme/admin/layout2/scripts/demo.js') }}"></script>

    @yield('scripts')
    <script>
        jQuery(document).ready(function() {    
            Metronic.init(); // init metronic core components
            Layout.init(); // init current layout
            verp.init(); // init demo features
         });
    </script>
<!-- END JAVASCRIPTS -->
</body>
<!-- END BODY -->
</html>