<div id="create" class="modal fade bs-modal-lg" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <form method="POST" v-on:submit.prevent="executeForm(newProduct)">
                        <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                <h4 class="modal-title">@{{create == true? 'Create new Product' : 'Update Product'}}</h4>
                        </div>
                        <div class="modal-body">
                            <div class="tabbable">
                                <ul class="nav nav-tabs">
                                    <li class="active">
                                            <a href="#update_view" data-toggle="tab" aria-expanded="true">
                                            @{{create == true ? 'Create View' : 'Update View'}} </a>
                                    </li>
                                </ul>
                                <div class="tab-content no-space">
                                    <div class="tab-pane fade active in" id="update_view">
                                        <div class="panel panel-default">
                                            <div class="panel-body">
                                                <div class="alert alert-danger" v-if="errors != ''">
                                                    <span v-for="error in errors">@{{ error }}<br/></span>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group form-md-line-input">
                                                            <input class="form-control" id="name" placeholder="Enter product's name" type="text" name="name" v-model="newProduct.name" required="true">
                                                            <label for="name">Name</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group form-md-line-input">
                                                            <input class="form-control" id="description" placeholder="Enter product's description" type="text" name="description" v-model="newProduct.description" required="true">
                                                            <label for="description">Description</label>
                                                        </div>
                                                    </div>
                                                        <div class="col-md-6">
                                                            <v-select v-model="newProduct.provider_id" :option="providers" @change="changeModel" d-name="Provider" d-text="Select the provider"></v-select>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group form-md-line-input">
                                                                <input class="form-control" id="qty" placeholder="Enter qty" type="text" name="price" v-model="newProduct.qty" required="true">
                                                                <label for="qty">Qty</label>
                                                            </div>
                                                        </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group form-md-line-input">
                                                            <input class="form-control" id="extent" placeholder="Enter extent" type="text" name="extent" v-model="newProduct.extent" required="true">
                                                            <label for="extent">Extent</label>
                                                        </div>
                                                    </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group form-md-line-input">
                                                                <input class="form-control" id="price" placeholder="Enter price" type="text" name="price" v-model="newProduct.price" required="true">
                                                                <label for="price">Price</label>
                                                            </div>
                                                        </div>

                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group form-md-line-input">
                                                            <div class="form-group form-md-radios">
                                                                <label>Advailable</label>
                                                                <div class="md-radio-inline">
                                                                    <div class="md-radio">
                                                                        <input type="radio" id="yes" name="advailable" class="md-radiobtn" value="1"  v-model="newProduct.advailable">
                                                                            <label for="yes">
                                                                            <span></span>
                                                                            <span class="check"></span>
                                                                            <span class="box"></span>
                                                                            Yes </label>
                                                                    </div>
                                                                    <div class="md-radio">
                                                                        <input type="radio" id="no" name="advailable" class="md-radiobtn" value="2" v-model="newProduct.advailable">
                                                                            <label for="no">
                                                                            <span></span>
                                                                            <span class="check"></span>
                                                                            <span class="box"></span>
                                                                            No </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                        <button type="button" data-dismiss="modal" class="btn default">Close</button>
                                        <button type="submit" class="btn default green">Save</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
        </div>
</div>
