@extends('layouts.theme')
@section('breadcrumb')
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/">Home</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>Workers</li>
    </ul>
@endsection
@section('content')
<div id="workers">
<div class="portlet light">
    <div class="portlet-title">
            <div class="caption">
                    <i class="icon-puzzle font-grey-gallery"></i>
                    <span class="caption-subject bold font-grey-gallery uppercase">
                    Workers </span>
                    <span class="caption-helper">List of Workers...</span>
            </div>
            <div class="tools">
                    <a href="" class="collapse" data-original-title="" title="">
                    </a>
                    <a href="#" class="reload_own" v-on:click.prevent="getWorkers()">
                    </a>
            </div>
    </div>
    <div class="portlet-body flip-scroll">
        <div class="row">
            <div class="col-md-12">
                <div class="table-toolbar">
                    <div class="btn-group">
                        <button id="sample_editable_1_new" class="btn green" v-on:click.prevent="showForm()">
                        Add New Worker <i class="fa fa-plus"></i>
                        </button>
                    </div>
                </div>
                <pagination :pagination="pagination" :offset="3" @change="changePage"></pagination>
                <table_workers :loading="loading" :workers="workers" @edit="editWorker" @delete="deleteWorker"></table_workers>
                <loading :loading="loading"></loading>
                <pagination :pagination="pagination" :offset="3" @change="changePage"></pagination>
            </div>
        </div>
    </div>
</div>	
@include('workers.create')
</div>
@endsection


@section('scripts')
<script src="{{ asset('js/workers.js') }}"></script>
@endsection