
<?php $__env->startSection('content'); ?>
    <div class="invoice" style="padding: 10px 20px; width: 100%;width: 100%;">
        <table class="invoice-logo" style="width: 100%; margin: 0;">
            <tr>
                <td style="width: 50%">
                    <div class="invoice-logo-space" style="margin: 0;">
                        <img src="<?php echo e(asset('theme/admin/pages/media/invoice/logo_factura.png')); ?>" width="200px"
                            class="img-responsive" alt="" style="margin: 0;">
                    </div>
                </td>
                <td style="width: 50%">
                    <p style="font-size: 14px">
                        <?php echo e(date('d M Y', strtotime($invoice->created_at))); ?> <span class="muted"><?php echo e($invoice->type); ?>

                            <?php echo e($invoice->type == 'invoice' ? '# ' . $invoice->number : ''); ?></span>
                    </p>
                </td>
            </tr>
        </table>
        <hr>
        <table style="width: 100%; margin: 0;">
            <tr>
                <td style="width: 50%">
                    <h4>Client:</h4>
                    <ul class="list-unstyled">
                        <li style="font-size: 12px"><?php echo e($invoice->client->name); ?></li>
                        <li style="font-size: 12px"><?php echo e($invoice->client->adress); ?></li>
                        <li style="font-size: 12px"><?php echo e($invoice->client->city); ?>, <?php echo e($invoice->client->state); ?>

                            <?php echo e($invoice->client->zip); ?></li>
                    </ul>
                </td>
                <td style="width: 50%">
                    <div class="well" style="margin: 0; padding: 20px 20px 0;">
                        <address style="font-size: 10px">
                            <strong style="font-size: 12px"><?php echo e($info['company_name']->value); ?></strong><br>
                            <?php echo e($info['company_adress']->value); ?>

                            <?php echo e($info['company_city']->value); ?>, <?php echo e($info['company_state']->value); ?>

                            <?php echo e($info['company_zip']->value); ?><br>
                            <span title="Phone">contact us:</span> <?php echo e($info['company_phone']->value); ?>

                        </address>
                        <address style="font-size: 10px">
                            <span title="Phone">Email:</span><a href="mailto:#">
                                <?php echo e($info['company_email']->value); ?></a><br />
                            <a href="www.designsrr.com">
                                <p>www.designsrr.com</p>
                            </a>
                        </address>
                    </div>
                </td>
            </tr>
        </table>
        <div class="row">
            <div class="col-xs-12">
                <table class="table table-bordered table-striped table-condensed"
                    style="font-size: 12px; margin: 30px 0 0 0">
                    <thead>
                        <tr>
                            <th style="font-size: 12px">Item</th>
                            <th class="hidden-480" style="font-size: 12px">Description</th>
                            <th class="hidden-480" style="font-size: 12px">Quantity</th>
                            <th class="hidden-480" style="font-size: 12px">Unit Cost</th>
                            <th style="font-size: 12px">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($invoice->services as $item) :?>
                        <tr>
                            <td style="font-size: 12px"><?php echo e($item->name); ?></td>
                            <td class="hidden-480" style="font-size: 12px"><?php echo $item->description; ?></td>
                            <td class="hidden-480" style="font-size: 12px"><?php echo e($item->qty); ?></td>
                            <td class="hidden-480" style="font-size: 12px">$<?php echo e(number_format($item->price, 2)); ?></td>
                            <td style="font-size: 12px">$<?php echo e(number_format($item->total, 2)); ?></td>
                        </tr>
                        <?php endforeach;?>
                        <?php foreach ($invoice->products as $item) :?>
                        <tr>
                            <td style="font-size: 12px"><?php echo e($item->name); ?></td>
                            <td class="hidden-480" style="font-size: 12px"><?php echo $item->description; ?></td>
                            <td class="hidden-480" style="font-size: 12px"><?php echo e($item->qty); ?></td>
                            <td class="hidden-480" style="font-size: 12px">$<?php echo e(number_format($item->price, 2)); ?></td>
                            <td style="font-size: 12px">$<?php echo e(number_format($item->total, 2)); ?></td>
                        </tr>
                        <?php endforeach;?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <table style="width: 100%; margin: 0;">
                    <tr>
                        <td style="width: 50%">
                        </td>
                        <td style="width: 50%" class="invoice-block">
                            <ul class="list-unstyled amounts" style="">
                                <li style="font-size: 10px"><strong style="font-size: 12px">Sub - Total amount:</strong>
                                    $<?php echo e(number_format($invoice->subtotal, 2)); ?></li>
                                <li style="font-size: 10px"><strong style="font-size: 12px">Discount
                                        (<?php echo e($invoice->discount); ?>%):</strong>
                                    $<?php echo e((string) $invoice->discount == '6.50' || (string) $invoice->discount == '6.5' ? number_format($invoice->subtotal - $invoice->subtotal / 1.07, 2) : number_format(($invoice->subtotal * $invoice->discount) / 100, 2)); ?>

                                </li>
                                <?php if($invoice->tax != 0):?>
                                <li style="font-size: 10px"><strong style="font-size: 12px">Tax:</strong>
                                    $<?php echo e(number_format($invoice->tax, 2)); ?></li>
                                <?php endif;?>
                                <li style="font-size: 10px"><strong style="font-size: 12px">Total:</strong>
                                    $<?php echo e(number_format($invoice->total, 2)); ?></li>
                                <br /><br />
                                <li style="font-size: 10px">
                                    <strong style="font-size: 12px">Total Paid:</strong>
                                    $<?php echo e(number_format($total_paid, 2)); ?>

                                </li>
                                <li style="font-size: 10px">
                                    <strong style="font-size: 12px">Balance:</strong>
                                    $<?php echo e(number_format($invoice->total - $total_paid, 2)); ?>

                                </li>
                            </ul>
                        </td>
                    </tr>
                </table>
                <table style="width: 100%; margin-top: 10px;">
                    <thead>
                        <tr>
                            <td style="width: 50%">&nbsp;</td>
                            <td style="width: 50%">&nbsp;</td>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td style="width: 50%; text-align: center;">
                                <p style="height: 72px; position: relative; width: 70%; margin: 0 auto;">
                                    <?php if($invoice->type == "invoice"):?>
                                    <img src="<?php echo e(asset('img/firma-pdf.jpg')); ?>" alt=""
                                        style="margin: 0 auto; display: inline-block; width: 127px; height: 72px;object-fit: cover;position: absolute; top: 0; left: 50%;transform: translate(-50%,0)">
                                    <?php endif;?>
                                </p>
                                <p style="width: 70%;margin: 0 auto;border-bottom: 1px solid #000000; text-align: center">
                                    &nbsp;</p>
                                <p style="width: 70%;margin: 5px auto 0; text-align: center">President</p>
                            </td>
                            <td style="width: 50%; text-align: center; height: 100px; position: relative;">

                                <p style="height: 72px; position: relative; width: 70%; margin: 0 auto;">
                                    <?php if(!empty($img)) :?>
                                    <img src="<?php echo e($img); ?>" alt=""
                                        style="margin: 0 auto; display: inline-block; width: 127px; height: 72px; object-fit: cover;position: absolute; top: 0; left: 50%;transform: translate(-50%,0)">
                                    <?php endif;?>
                                </p>

                                <p style="width: 70%;margin: 0 auto;border-bottom: 1px solid #000000; text-align: center">
                                    &nbsp;</p>
                                <p style="width: 70%;margin: 5px auto 0; text-align: center"><?php echo e($invoice->client->name); ?>

                                </p>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <div class="row" style="margin: 0;">
                    <div class="col-md-12">
                        <p style="font-size: 12px; text-align: justify; margin: 2.5px 0"><strong>Terms and
                                Conditions.</strong> <br /><?php echo e($invoice_text->value); ?></p>
                        <p style="font-size: 12px; text-align: justify; margin: 2.5px 0"><strong>Changes to
                                Orders.</strong> <br /><?php echo e($invoice_text1->value); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.pdf', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>