@extends('layouts.pdf')
@section('content')
<div class="invoice" style="padding: 10px 20px; width: 100%;">
    <table class="invoice-logo" style="width: 100%; margin: 0;">
        <tr>
            <td style="width: 50%">
                <div class="invoice-logo-space">
                    <img src="{{asset('theme/admin/pages/media/invoice/logo_factura.png')}}" class="img-responsive" alt="">
                </div>
            </td>
            <td style="width: 50%">
                <p>
                    {{date("d M Y",strtotime($invoice->created_at))}} <span class="muted">{{$invoice->type}} {{$invoice->type == "invoice" ? "# ".$tnumber : "" }}</span>
                </p>
            </td>
        </tr>
    </table>
        <hr>
                <table style="width: 100%; margin: 0;">
                <tr>
                    <td style="width: 50%">
                        <h4>Client:</h4>
                        <ul class="list-unstyled">
                                <li>{{$invoice->client->name}}</li>
                                <li>{{$invoice->client->adress}}</li>
                                <li>{{$invoice->client->city}}, {{$invoice->client->state}} {{$invoice->client->zip}}</li>
                        </ul>
                    </td>
                    <td style="width: 50%">
                        <div class="well">
                            <address>
                            <strong>{{$info['company_name']->value}}</strong><br>
                              {{$info['company_adress']->value}}
                              {{$info['company_city']->value}}, {{$info['company_state']->value}} {{$info['company_zip']->value}}<br>
                              <span title="Phone">contact us:</span> {{$info['company_phone']->value}} 
                              </address>
                              <address>
                              <span title="Phone">Email:</span><a href="mailto:#">
                                  {{$info['company_email']->value}}</a><br/>
                                  <a href="www.designsrr.com"><p>www.designsrr.com</p></a>
                            </address>
                        </div>
                    </td>
                </tr>
            </table>
        <div class="row">
            <div class="col-xs-12">
                <table class="table table-bordered table-striped table-condensed">
                    <thead>
                        <tr>
                            <th>Item</th>
                            <th class="hidden-480">Description</th>
                            <th class="hidden-480">Quantity</th>
                            <th class="hidden-480">Unit Cost</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($invoice->services as $item) :?>
                        <tr>
                            <td>{{$item->name}}</td>
                            <td class="hidden-480"><?php echo $item->description?></td>
                            <td class="hidden-480">{{$item->qty}}</td>
                            <td class="hidden-480">${{number_format($item->price,2)}}</td>
                            <td>${{number_format($item->total,2)}}</td>
                        </tr>
                        <?php endforeach;?>
                        <?php foreach ($invoice->products as $item) :?>
                        <tr>
                            <td>{{$item->name}}</td>
                            <td class="hidden-480"><?php echo $item->description?></td>
                            <td class="hidden-480">{{$item->qty}}</td>
                            <td class="hidden-480">${{number_format($item->price,2)}}</td>
                            <td>${{number_format($item->total,2)}}</td>
                        </tr>
                        <?php endforeach;?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <table style="width: 100%; margin: 0;">
                <tr>
                    <td style="width: 50%">
                    </td>
                    <td style="width: 50%" class="invoice-block">
                        <ul class="list-unstyled amounts">
                            <li><strong>Sub - Total amount:</strong> ${{number_format($invoice->subtotal,2)}}</li>
                            <li><strong>Discount ({{$invoice->discount}}%):</strong> ${{(string)$invoice->discount == "6.50" || (string)$invoice->discount == "6.5" ? number_format($invoice->subtotal - ($invoice->subtotal / 1.07),2) : number_format($invoice->subtotal * $invoice->discount / 100,2)}}</li>
                            <li><strong>Tax:</strong> ${{number_format($invoice->tax,2)}}</li>
                            <li><strong>Total:</strong> ${{number_format($invoice->total,2)}}</li>
                        </ul>
                    </td>
                </tr>
            </table>
            <table style="width: 100%; margin-top: 50px;">
                <thead>
                    <tr>
                        <td style="width: 70%">&nbsp;</td>
                        <td style="width: 30%">&nbsp;</td>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="width: 50%">&nbsp;</td>
                        <td style="width: 50%; text-align: center">
                            <p style="border-bottom: 1px solid #000000">&nbsp;</p>
                            <p>{{$invoice->client->name}}</p>
                        </td>
                    </tr>
                </tbody>
            </table>
                <div class="row" style="margin: 10px 0;">
                    <div class="col-md-12">
                        <p style="font-size: 7px; text-align: justify; margin: 5px 0"><strong>Terms and Conditions.</strong> <br/>{{$invoice_text->value}}</p>
                        <p style="font-size: 7px; text-align: justify; margin: 5px 0"><strong>Changes to Orders.</strong> <br/>{{$invoice_text1->value}}</p>
                    </div>
                </div>  
            </div>
        </div>
    </div>
@endsection