
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */
Vue.component('v-input', require('./components/vinput.vue'));
Vue.component('table_estimates', require('./components/table_estimates.vue'));
Vue.component('table_invoices', require('./components/table_invoices.vue'));
Vue.component('table_items', require('./components/table_items.vue'));
Vue.component('table_payment', require('./components/table_payment.vue'));
Vue.component('loading', require('./components/loading.vue'));
Vue.component('v-select', require('./components/vselect.vue'));
Vue.component('pagination', require('./components/pagination.vue'));

import moment from 'moment';

const app = new Vue({
    el: '#invoices',
    created: function(){
        this.init();
    },
    data: {
        showModal: true, 
        invoiceId: null,
        invoices: [],
        type: "invoice",
        services: [],
        products: [],
        invoiceDate: null,
        paymentMethods: [],
        pagination: {
            total: 0,
            current_page: 0,
            per_page: 0,
            last_page: 0,
            from: 0,
            to: 0,
        },
        companyInfo: [],
        client: [],
        itemsServices: [],
        itemsProducts: [],
        payments: [],
        paid: true,
        invoiceText: "",
        discount: 0,
        tax: 0,
        qty: 1,
        price: "",
        breakdown: 0,
        deposit: 0,
        invoiceNumber: "",
        productSelected: "",
        serviceSelected: "",
        paymentMethodsSelected: "",
        options: "",
        newService: [],
        errors: [],
        create: true,
        loading: true,
        states: [
            {id: "Florida", name: "Florida"},
        ],
        payment_metho: ["Cash","Check", "Debit", "Credit"]
    },
    computed: {
        getOptions: function(){
            return this.options;
        },
        getDescription: function(){
            var descrip = "";
            if(this.options == "services" && this.serviceSelected != "") {
                descrip = _.find(this.services,{ id: this.serviceSelected });
            }
            else if(this.productSelected != "") {
                descrip = _.find(this.products,{ id: this.productSelected });
            }
            if(descrip) return descrip.description;
            else return "";
        },
        getSubTotal: function(){
            var subTotal = 0;
            for(var i = 0; i < this.itemsServices.length; i ++) {
                subTotal = parseFloat(subTotal) + parseFloat(this.itemsServices[i].price);
            }
            for(var i = 0; i < this.itemsProducts.length; i ++) {
                subTotal = parseFloat(subTotal) + parseFloat(parseFloat(this.itemsProducts[i].price) * parseFloat(this.itemsProducts[i].qty));
            }
            return parseFloat(subTotal).toFixed(2);
        },
        getDiscount: function(){
            return parseFloat(parseFloat(this.getSubTotal) * parseFloat(this.discount) /100).toFixed(2);
        },
        getTax: function(){
            var subTotal = parseFloat(this.getSubTotal) - parseFloat(this.getDiscount);
            return parseFloat(parseFloat(subTotal) * parseFloat(this.tax) /100).toFixed(2);
        },
        getTotal: function(){
            return parseFloat(parseFloat(this.getSubTotal) - parseFloat(this.getDiscount) + parseFloat(this.getTax)).toFixed(2);
        },
        getTotalPaid: function(){
            var self = this;
            var ttotal = 0;
            $.each(self.payments, function(i){
                ttotal = parseFloat(ttotal) + parseFloat(self.payments[i].paid);
            });
            return parseFloat(ttotal).toFixed(2);
        },
        date: function(){
            if(this.invoiceDate)
                return moment(this.invoiceDate).format('DD MMMM YYYY');
            return moment().format('DD MMMM YYYY');
        }
    },
    methods: {
        init:function(){
            this.client = {
                name: "",
                adress: "",
                city: "",
                state: "",
                zip: "",
                email: "",
                cell_phome: "",
                home_phome: "",
                work_phome: "",
            };
            this.itemsServices = [];
            this.itemsProducts = [];
            this.payments = [];
            this.deposit = 0;
            this.errors = [];
            this.invoiceNumber = "";
            this.invoiceDate = null;
            
            this.getInvoices();
            this.getPaymentMethods();
            this.getServices();
            this.getProducts();
            this.options = "services";
            this.getDiscountValue();
            this.getTaxValue();
            this.getInvoiceText();
            this.getCompanyInfoValue();
            //this.getInvoiceNumber();
            
            this.refresh(".state");
            this.refresh(".pmethods");
            /*this.refresh(".Services");
            this.refresh(".Products");*/
        },
        initUpdate: function(invoice){
            this.showModal = false;
            this.deposit = invoice.deposit;
            this.type = invoice.type;
            this.invoiceDate = invoice.created_at;
            this.invoiceNumber = invoice.number;
            var url = "api/invoices/get-client/" + invoice.id
            axios.get(url).then(response => {
                this.client = response.data;
                this.refresh(".state", this.client.state);
            });
            
            var url = "api/invoices/get-services/" + invoice.id
            axios.get(url).then(response => {
                this.itemsServices = response.data;
            });
            
            var url = "api/invoices/get-products/" + invoice.id
            axios.get(url).then(response => {
                this.itemsProducts = response.data;
            });
            
            var url = "api/invoices/get-payments/" + invoice.id
            axios.get(url).then(response => {
                this.payments = response.data;
            });
        },
        getInvoices: function(page){
            var url = "api/invoices?page="+page;
            this.loading = true;
            axios.get(url).then(response => {
                this.invoices = response.data.invoices.data;
                this.pagination = response.data.pagination;
                this.loading = false;
            });
        },
        createInvoice: function(){
           var url = 'api/invoices';
           this.errors = [];
            axios.post(url,{
                type: this.type,
                number: this.invoiceNumber,
                deposit: this.deposit,
                subtotal: this.getSubTotal,
                discount: this.getDiscount,
                tax: this.getTax,
                total: this.getTotal,
                client: this.client,
                services: this.itemsServices,
                products: this.itemsProducts,
                payments: this.payments
            }).then(response => {
                jQuery('#create').modal('hide');
                toastr.success("The Invoice was successfully added");
                this.getInvoices();
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        updateInvoice: function(invoice){
           var url = 'api/invoices/' + this.invoiceId;
           this.errors = [];
            axios.put(url,{
                type: this.type,
                number: this.invoiceNumber,
                deposit: this.deposit,
                subtotal: this.getSubTotal,
                discount: this.getDiscount,
                tax: this.getTax,
                total: this.getTotal,
                client: this.client,
                services: this.itemsServices,
                products: this.itemsProducts,
                payments: this.payments
            }).then(response => {
                this.create = true;
                jQuery('#create').modal('hide');
                toastr.success("The Invoice was successfully update");
                this.getInvoices();
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        deleteInvoice: function(data){
            var invoice = data.item;
            var url = "api/invoices/" + invoice.id
            bootbox.confirm("Are you sure do you want delete the invoice?", function(result) {
                if(result == true) {
                    axios.delete(url).then(response => {
                        toastr.success("The provider was successfully removed");
                        app.getInvoices();
                    });
                }
            }); 
        },
        editInvoice: function(data){
            var invoice = data.item;
            this.invoiceId = invoice.id;
            this.initUpdate(invoice);
            jQuery('#create').modal('show');
            this.create = false;
        },
        getServices: function(){
            var url = "api/services/getall";
            axios.get(url).then(response => {
                this.services = response.data;
                this.refresh(".Services");
            });
        },
        getPaymentMethods: function(){
            var url = "api/payment-methods";
            axios.get(url).then(response => {
                this.paymentMethods = response.data;
                this.refresh(".pmethods");
            });
        },
        getProducts: function(){
            var url = "api/products/getall";
            axios.get(url).then(response => {
                this.products = response.data;
                this.refresh(".Products");
            });
        },
        getDiscountValue: function(){
            var url = "api/settings/get-discount";
            axios.get(url).then(response => {
                this.discount = response.data.value;
            });
        },
        getTaxValue: function(){
            var url = "api/settings/get-tax";
            axios.get(url).then(response => {
                this.tax = response.data.value;
            });
        },
        getInvoiceText: function(){
            var url = "api/settings/get-invoice-text";
            axios.get(url).then(response => {
                this.invoiceText = response.data.value;
            });
        },
        getInvoiceNumber: function(){
            var url = "api/settings/get-invoice-number";
            axios.get(url).then(response => {
                this.invoiceNumber = response.data.value;
            });
        },
        getCompanyInfoValue: function(){
            var url = "api/settings/get-company-info";
            axios.get(url).then(response => {
                var companyInfo = response.data;
                this.companyInfo.name = companyInfo['company_name'].value;
                this.companyInfo.adress = companyInfo['company_adress'].value;
                this.companyInfo.city = companyInfo['company_city'].value;
                this.companyInfo.state = companyInfo['company_state'].value;
                this.companyInfo.zip = companyInfo['company_zip'].value;
                this.companyInfo.phone = companyInfo['company_phone'].value;
                this.companyInfo.person = companyInfo['company_person'].value;
                this.companyInfo.email = companyInfo['company_email'].value;
                
            });
        },
        refresh: function(parent = "", value = ""){
            if(jQuery(parent+' .bs-select').length) {
                jQuery(parent+' .bs-select').each(function(){
                    jQuery(this).val(value);  
                    jQuery(this).selectpicker("refresh");
                });
            }
        },
        changeDeposit: function(){
            var total = parseFloat(this.getTotal - this.getTotalPaid).toFixed(2);
            if(parseFloat(this.deposit) > parseFloat(total)) {
                this.deposit = total;
                toastr.error("The deposit can not be greater than the total to pay");
            }
        },
        changePay: function(){
            var apaid = parseFloat(parseFloat(this.getTotal) - parseFloat(this.deposit) - parseFloat(this.getTotalPaid)).toFixed(2);
            if(parseFloat(this.breakdown) > parseFloat(apaid)) {
                this.breakdown =  parseFloat(apaid).toFixed(2);
                toastr.error("The deposit can not be greater than the total payable of the invoice minus the deposit paid");
            }
        },
        deleteItem: function(data){
                    var type = data.type;
                    var item = data.item;
                    var self = this;
                    bootbox.confirm("Are you sure do you want delete the item selected?", function(result) {
                        if(result == true) {
                            if(type == "services"){
                                $.each(self.itemsServices, function(i){
                                    if(self.itemsServices[i].id == item.id) {
                                        self.itemsServices.splice(i,1);
                                        return false;
                                    }
                                });
                            }
                            else if(type == "products") {
                                $.each(self.itemsProducts, function(i){
                                    if(self.itemsProducts[i].id == item.id) {
                                        self.itemsProducts.splice(i,1);
                                        return false;
                                    }
                                });
                            }
                            toastr.success("The item was successfully removed");
                        }
                    }); 
                },
        deletePayment: function(data){
            var item = data.item;
            var self = this;
            bootbox.confirm("Are you sure do you want delete the item selected?", function(result) {
                if(result == true) {
                    $.each(self.payments, function(i){
                        if(self.payments[i].id == item.id) {
                            self.payments.splice(i,1);
                            return false;
                        }
                    });
                    toastr.success("The item was successfully removed");
                }
            }); 
        },
        showForm: function(){
            this.newService = [];
            this.create = true;
            this.errors = [];
            this.init();
            jQuery('#create').modal('show');
        },
        addBreakdown: function(){
            if(this.paymentMethodsSelected == "") {
                toastr.error("Please select one payment method");
                jQuery('[name="pmethods"]').parent().addClass("has-error");
                jQuery('[name="breakdown"]').focus();
                return;
            }
            if(this.breakdown <= 0) {
                toastr.error("The amount must be greater than 0");
                jQuery('[name="breakdown"]').parent().addClass("has-error");
                jQuery('[name="breakdown"]').focus();
                return;
            }
            if(!this.idPaymentValid(this.breakdown)) {
                toastr.error("The amount + the total paid exceeds the total to be paid specified in the invoice");
                return false;
            } 
            var elem = _.find(this.paymentMethods,{id:this.paymentMethodsSelected});
            var item = {
                id: elem.name + "-" + (this.payments.length + 1) + "-" + this.breakdown,
                payment_methods: elem.name,
                paid: this.breakdown,
            };
            this.payments.push(item);
            this.paymentMethodsSelected = "";
            this.breakdown = 0;
             this.refresh(".pmethods");
        },
        idPaymentValid: function(paid){
            var self = this;
            var ttotal = 0;
            $.each(self.payments, function(i){
                ttotal = parseFloat(ttotal) + parseFloat(self.payments[i].paid);
            });
            var a = parseFloat(ttotal) + parseFloat(paid);
            var b = parseFloat(self.getTotal) - parseFloat(this.deposit);
            if(parseFloat(a.toFixed(2)) <= parseFloat(b.toFixed(2))) return true;
            else return false;
        },
        addItem: function(){
            if(this.options == "services") {
                if(this.serviceSelected == "") {
                    toastr.error("Please select one services");
                    jQuery('[name="Services"]').parent().addClass("has-error");
                    jQuery('[name="Services"]').focus();
                    return false;
                }
                if(this.price == "" || this.price == 0) {
                    toastr.error("The price must be grea tha 0");
                    jQuery('[name="price"]').parent().addClass("has-error");
                    jQuery('[name="price"]').focus();
                    return false;
                }
                var service = _.find(this.services,{ id: this.serviceSelected });
                var service_find = _.find(this.itemsServices,{ service_id: this.serviceSelected });
                if(!service_find) {
                    var item = {
                        service_id: service.id,
                        name: service.name,
                        description: service.description,
                        qty: "",
                        price: this.price,
                        total: this.price,
                    };
                    this.itemsServices.push(item);
                }
                else {
                    toastr.error("The service do you want add was add");
                }
            }
            else {
                if(this.productSelected != "") {
                    var product = _.find(this.products,{ id: this.productSelected });
                    var product_find = _.find(this.itemsProducts,{ product_id: this.productSelected });
                    if(!product_find) {
                        var item = {
                            product_id: product.id,
                            name: product.name,
                            description: product.description,
                            qty: this.qty,
                            price: product.price,
                            total: parseFloat(product.price) * parseFloat(this.qty),
                        };
                        this.itemsProducts.push(item);
                    }
                    else {
                        toastr.error("The product do you want add was add");
                        jQuery('[name="Services"]').parent().addClass("has-error");
                    }
                }
                else {
                    toastr.error("Please select one product");
                    jQuery('[name="Products"]').parent().addClass("has-error");
                }
            }
            this.serviceSelected = [];
            this.productSelected = [];
            this.qty = 1;
            this.price = "";
            this.refresh(".Services ");
            this.refresh(".Products ");
        },
        changePage: function(data){
            var page = data.page;
            this.pagination.current_page = page;
            this.getServices(page);
        },
        changeModel: function(data){
            this.client.state = data.value;
        },
        changeModelProduct: function(data){
            this.productSelected = parseInt(data.value);
        },
        changePaymentMethods: function(data){
            this.paymentMethodsSelected = parseInt(data.value);
        },
        changeModelService: function(data){
            this.serviceSelected = parseInt(data.value);
        },
        step1Error: function(){
            var self = this;
            if(!self.client.name) {
                toastr.error("Please enter the client name");
                jQuery('[name="name"]').parent().addClass("has-error");
                jQuery('[name="name"]').focus();
                return true;
            }
            if(!self.client.adress) {
                toastr.error("Please enter the client adress");
                jQuery('[name="adress"]').parent().addClass("has-error");
                jQuery('[name="adress"]').focus();
                return true;
            }
            if(!self.client.city) {
                toastr.error("Please enter the client city");
                jQuery('[name="city"]').parent().addClass("has-error");
                jQuery('[name="city"]').focus();
                return true;
            }
            if(!self.client.state) {
                toastr.error("Please enter the client state");
                jQuery('[name="state"]').parent().addClass("has-error");
                jQuery('[name="state"]').focus();
                return true;
            }
            self.refresh(".Services ");
            self.refresh(".Products ");
            return false;
        },
        step2Error: function(){
            var self = this;
            if(self.itemsServices.length == 0 && self.itemsProducts.length == 0){
                toastr.error("Por favor debe seleccionar al menos un servicio o un productos a si invoice");
                return true;
            }
            return false;
        }
    },
    mounted: function(){
       
        var form = jQuery('#submit_form');
        var error = jQuery('.alert-danger', form);
        var success = jQuery('.alert-success', form);

        var handleTitle = function(tab, navigation, index) {
            var total = navigation.find('li').length;
            var current = index + 1;
            // set wizard title
            jQuery('.step-title', $('#form_wizard_1')).text('Step ' + (index + 1) + ' of ' + total);
            // set done steps
            jQuery('li', $('#form_wizard_1')).removeClass("done");
            var li_list = navigation.find('li');
            for (var i = 0; i < index; i++) {
                jQuery(li_list[i]).addClass("done");
            }

            if (current == 1) {
                jQuery('#form_wizard_1').find('.button-previous').hide();
            } else {
                jQuery('#form_wizard_1').find('.button-previous').show();
            }

            if (current >= total) {
                jQuery('#form_wizard_1').find('.button-next').hide();
                jQuery('#form_wizard_1').find('.button-submit').show();
                //displayConfirm();
            } else {
                jQuery('#form_wizard_1').find('.button-next').show();
                jQuery('#form_wizard_1').find('.button-submit').hide();
            }
            Metronic.scrollTo(jQuery('.page-title'));
        }
        var self = this;
        jQuery('#form_wizard_1').bootstrapWizard({
            'nextSelector': '.button-next',
            'previousSelector': '.button-previous',
            onTabClick: function (tab, navigation, index, clickedIndex) {
                
                success.hide();
                error.hide();
                switch (clickedIndex) {
                    case 1:
                        if(self.step1Error()) return false;
                        break;
                    case 2:
                        if(self.step2Error()) return false;
                        break;
                        
                    default:
                        
                        break;
                }
                
                handleTitle(tab, navigation, clickedIndex);
                
            },
            onNext: function (tab, navigation, index) {
                success.hide();
                error.hide();
                switch (index) {
                    case 1:
                        self.refresh(".Services");
                        self.refresh(".Products");
                        if(self.step1Error()) return false;
                        break;
                    case 2:
                        self.refresh(".pmethods");
                        if(self.step2Error()) return false;
                        break;
                    case 3:
                        
                        break;
                    default:
                        
                        break;
                }
                handleTitle(tab, navigation, index);
            },
            onPrevious: function (tab, navigation, index) {
                success.hide();
                error.hide();

                handleTitle(tab, navigation, index);
            },
            onTabShow: function (tab, navigation, index) {
                var total = navigation.find('li').length;
                var current = index + 1;
                var $percent = (current / total) * 100;
                jQuery('#form_wizard_1').find('.progress-bar').css({
                    width: $percent + '%'
                });
            }
        });

        jQuery('#form_wizard_1').find('.button-previous').hide();
        jQuery('#form_wizard_1 .button-submit').click(function () {
        }).hide();
        
        jQuery("input").keyup(function(){
            if(jQuery(this).parent().hasClass("has-error")) jQuery(this).parent().removeClass("has-error");
        });
        jQuery("select").change(function(){
            if(jQuery(this).parent().hasClass("has-error")) jQuery(this).parent().removeClass("has-error");
        });
    },
});
