
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */

Vue.component('v-input', require('./components/vinput.vue'));
Vue.component('table_products', require('./components/table_products.vue'));
Vue.component('loading', require('./components/loading.vue'));
Vue.component('v-select', require('./components/vselect.vue'));
Vue.component('pagination', require('./components/pagination.vue'));

const app = new Vue({
    el: '#products',
    created: function(){
        this.getProducts();
        this.getProviders();
    },
    data: {
        products: [],
        providers: [],
        pagination: {
            'total': 0,
            'current_page': 0,
            'per_page': 0,
            'last_page': 0,
            'from': 0,
            'to': 0,
        },
        newProduct: [],
        errors: [],
        create: true,
        loading: true,
    },
    methods: {
        getProducts: function(page){
            var url = "api/products?page="+page;
            this.loading = true;
            axios.get(url).then(response => {
                this.products = response.data.products.data;
                this.pagination = response.data.pagination;
                this.loading = false;
            });
        },
        getProviders: function(){
            var url = "api/provider/getall";
            axios.get(url).then(response => {
                this.providers = response.data;
                this.refresh();
            });
        },
        deleteProduct: function(data){
            var product = data.product;
            var url = "api/products/" + product.id
            bootbox.confirm("Are you sure do you want delete the product?", function(result) {
                if(result == true) {
                    axios.delete(url).then(response => {
                        app.getProducts();
                        toastr.success("The product was successfully removed");
                    });
                }
            }); 
        },
        changeModel: function(data){
            this.newProduct.provider_id = data.value;
        },
        refresh: function(value = null){
            if(jQuery('.bs-select').length) {
                if(value) jQuery('.bs-select').val(value);  
                jQuery('.bs-select').selectpicker("refresh");
            }
        },
        showForm: function(){
            this.newProduct = [];
            this.create = true;
            this.errors = [];
            jQuery('#create').modal('show');
            this.refresh();
        },
        executeForm: function(product){
            if(this.create == true) this.createProduct();
            else this.updateProduct(product);
                
        },
        createProduct: function(){
           var url = 'api/products';
           this.errors = [];
            axios.post(url,{
                name: this.newProduct.name,
                description: this.newProduct.description,
                extent: this.newProduct.extent,
                price: this.newProduct.price,
                provider_id: this.newProduct.provider_id,
                advailable: this.newProduct.advailable,
                qty: this.newProduct.qty,
            }).then(response => {
                this.getProducts();
                this.newProduct = [];
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The product was successfully added");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        editProduct: function(data){
            var product = data.product;
            this.newProduct = {
                name: product.name,
                description: product.description,
                extent: product.extent,
                price: product.price,
                provider_id: product.provider_id,
                advailable: product.advailable,
                qty: product.qty,
                id: product.id
            };
            this.create = false;
            this.errors = [];
            jQuery('#create').modal('show');
            this.refresh(product.provider_id);
        },
        updateProduct: function(product){
            var url = "api/products/" + product.id;
            axios.put(url,{
                name: this.newProduct.name,
                description: this.newProduct.description,
                extent: this.newProduct.extent,
                price: this.newProduct.price,
                provider_id: this.newProduct.provider_id,
                advailable: this.newProduct.advailable,
                qty: this.newProduct.qty,
            }).then(response => {
                this.getProducts(this.pagination.current_page);
                this.newProduct = [];
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The product was successfully updated");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        changePage: function(data){
            var page = data.page;
            this.pagination.current_page = page;
            this.getProducts(page);
        },
    },
});
