require('./bootstrap');

window.Vue = require('vue');

Vue.component('v-input', require('./components/vinput.vue'));
Vue.component('table_provider_bills', require('./components/table_provider_bills.vue'));
Vue.component('table_line_bills', require('./components/table_line_bills.vue'));
Vue.component('loading', require('./components/loading.vue'));
Vue.component('v-select', require('./components/vselect.vue'));
Vue.component('pagination', require('./components/pagination.vue'));

const app = new Vue({
    el: '#provider-bills',
    created: function(){
        this.getBills();
        this.getProviders();
        this.getPaymentMethods();
    },
    data: {
        bills: [],
        providers: [],
        payment_methods: [],
        types: [
            {id: 'Fixed Costs', name: 'Fixed Costs'},
            {id: 'Variable expends', name: 'Variable expends'},
        ],
        pagination: {
            'total': 0,
            'current_page': 0,
            'per_page': 0,
            'last_page': 0,
            'from': 0,
            'to': 0,
        },
        newBill: {
            provider_bills_lines: []
        },
        newItem: {},
        errors: [],
        create: true,
        loading: true,
    },
    computed: {
        total: function(){
            return parseFloat(parseFloat(this.newBill.sub_total) + parseFloat(this.newBill.tax)).toFixed(2);
        },
        amount: function(){
            return parseFloat(parseFloat(this.newItem.qty) + parseFloat(this.newItem.price_u)).toFixed(2);
        }
    },
    methods: {
        getBills: function(page){
            var url = "api/provider-bills?page="+page;
            this.loading = true;
            axios.get(url).then(response => {
                this.bills = response.data.bills.data;
                this.pagination = response.data.pagination;
                this.loading = false;
            });
        },
        getProviders: function(){
            var url = "api/provider/getall";
            axios.get(url).then(response => {
                this.providers = response.data;
            });
        },
        getPaymentMethods: function(){
            var url = "api/payment-methods";
            axios.get(url).then(response => {
                this.payment_methods = response.data;
            });
        },
        deleteBill: function(data){
            var item = data.item;
            var url = "api/provider-bills/" + item.id
            bootbox.confirm("Are you sure do you want delete the bills?", function(result) {
                if(result == true) {
                    axios.delete(url).then(response => {
                        app.getBills();
                        toastr.success("The bills was successfully removed");
                    });
                }
            }); 
        },
        showForm: function(){
            this.newBill = {
                provider_bills_lines: []
            };
            this.create = true;
            this.errors = [];
            this.refresh('.provider');
            this.refresh('.payment_methods');
            jQuery('#create').modal('show');
        },
        executeForm: function(bill){
            if(!this.validate()) return;
            if(this.create == true) this.createBill();
            else this.updateBill(bill);     
        },
        createBill: function(){
           var url = 'api/provider-bills';
           this.errors = [];
            axios.post(url,{
                provider_id: this.newBill.provider_id,
                invoice_number: this.newBill.invoice_number,
                date: this.newBill.date,
                description: this.newBill.description,
                payment_methods_id: this.newBill.payment_methods_id,
                sub_total: this.newBill.sub_total,
                tax: this.newBill.tax,
                total: this.total,
                provider_bills_lines: this.newBill.provider_bills_lines,
            }).then(response => {
                this.getBills();
                this.newBill = {
                    provider_bills_lines: []
                };
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The provider bills was successfully added");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        editBill: function(data){
            var bill = data.item;
            this.newBill = {
                provider_id: bill.provider_id,
                invoice_number: bill.invoice_number,
                date: bill.date,
                description: bill.description,
                payment_methods_id: bill.payment_methods_id,
                sub_total: bill.sub_total,
                tax: bill.tax,
                total: bill.total,
                provider_bills_lines: bill.provider_bills_lines,
                id: bill.id
            };
            this.create = false;
            this.errors = [];
            this.refresh('.provider', this.newBill.provider_id);
            this.refresh('.payment_methods',this.newBill.payment_methods_id);
            jQuery('#create').modal('show');
        },
        updateBill: function(expense){
            var url = "api/provider-bills/" + expense.id;
            axios.put(url,{
                provider_id: this.newBill.provider_id,
                invoice_number: this.newBill.invoice_number,
                date: this.newBill.date,
                description: this.newBill.description,
                payment_methods_id: this.newBill.payment_methods_id,
                sub_total: this.newBill.sub_total,
                tax: this.newBill.tax,
                total: this.total,
                provider_bills_lines: this.newBill.provider_bills_lines,
            }).then(response => {
                this.getBills(this.pagination.current_page);
                this.newBill = {
                    provider_bills_lines: []
                };
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The provider bills was successfully updated");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        addItem: function(){
            if(!this.valida()) return;
            this.newItem.id = this.newItem.qty + this.newItem.description + this.newItem.price_u;
            this.newItem.amount = this.amount;
            this.newBill.provider_bills_lines.push(this.newItem);
            this.newItem = {};
        },
        deleteItem: function(data){
            var item = data.item;
            var self = this;
            bootbox.confirm("Are you sure do you want delete the item selected?", function(result) {
                if(result == true) {
                    $.each(self.newBill.provider_bills_lines, function(i){
                        if(self.newBill.provider_bills_lines[i].id == item.id) {
                            self.newBill.provider_bills_lines.splice(i,1);
                            return false;
                        }
                    });
                    toastr.success("The item was successfully removed");
                }
            }); 
        },
        changePage: function(data){
            var page = data.page;
            this.pagination.current_page = page;
            this.getServices(page);
        },
        refresh: function(parent = "", value = ""){
            if(jQuery(parent+' .bs-select').length) {
                jQuery(parent+' .bs-select').each(function(){
                    jQuery(this).val(value);  
                    jQuery(this).selectpicker("refresh");
                });
            }
        },
        changeModel: function(data){
            this.newBill.provider_id = data.value;
        },
        changeModelPayment: function(data){
            this.newBill.payment_methods_id = data.value;
        },
        validate: function(){
            if(!this.newBill.provider_id) {
                toastr.error("Please enter the provider");
                jQuery('[name="provider"]').parent().addClass("has-error");
                jQuery('[name="provider"]').focus();
                return false;
            }
            if(!this.newBill.invoice_number) {
                toastr.error("Please enter the bills number");
                jQuery('[name="invoice_number"]').parent().addClass("has-error");
                jQuery('[name="invoice_number"]').focus();
                return false;
            }
            if(!this.newBill.date) {
                toastr.error("Please enter the bills date");
                jQuery('[name="date"]').parent().addClass("has-error");
                jQuery('[name="date"]').focus();
                return false;
            }
            if(!this.newBill.description) {
                toastr.error("Please enter the bills description");
                jQuery('[name="bills_description"]').parent().addClass("has-error");
                jQuery('[name="bills_description"]').focus();
                return false;
            }
            if(!this.newBill.payment_methods_id) {
                toastr.error("Please enter the bills description");
                jQuery('[name="payment_methods"]').parent().addClass("has-error");
                jQuery('[name="payment_methods"]').focus();
                return false;
            }
            if(!this.newBill.sub_total) {
                toastr.error("Please enter the bills sub-total");
                jQuery('[name="sub_total"]').parent().addClass("has-error");
                jQuery('[name="sub_total"]').focus();
                return false;
            }
            if(!this.newBill.tax) {
                toastr.error("Please enter the bills tax");
                jQuery('[name="tax"]').parent().addClass("has-error");
                jQuery('[name="tax"]').focus();
                return false;
            }
            return true;
        },
        valida: function(){
            if(!this.newItem.qty) {
                toastr.error("Please enter the item qty");
                jQuery('[name="qty"]').parent().addClass("has-error");
                jQuery('[name="qty"]').focus();
                return false;
            }
            if(!this.newItem.price_u) {
                toastr.error("Please enter the item price u");
                jQuery('[name="price_u"]').parent().addClass("has-error");
                jQuery('[name="price_u"]').focus();
                return false;
            }
            if(!this.newItem.description) {
                toastr.error("Please enter the item description");
                jQuery('[name="description"]').parent().addClass("has-error");
                jQuery('[name="description"]').focus();
                return false;
            }
            return true;
        }
    },
    mounted: function() {
        jQuery('.date-picker').datepicker({
            orientation: "center",
            autoclose: true
        }).on('changeDate', function(e){
            app.newBill.date = jQuery('.date-picker input').val();
        });
        jQuery("input, textarea").keyup(function(){
            if(jQuery(this).parent().hasClass("has-error")) jQuery(this).parent().removeClass("has-error");
        });
        jQuery("select, input, textarea").change(function(){
            if(jQuery(this).parent().hasClass("has-error")) jQuery(this).parent().removeClass("has-error");
        });
    }
});
