
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */
Vue.component('v-input', require('./components/vinput.vue'));
Vue.component('table_services', require('./components/table_services.vue'));
Vue.component('loading', require('./components/loading.vue'));
Vue.component('v-select', require('./components/vselect.vue'));
Vue.component('pagination', require('./components/pagination.vue'));

const app = new Vue({
    el: '#services',
    created: function(){
        this.getServices();
    },
    data: {
        services: [],
        pagination: {
            'total': 0,
            'current_page': 0,
            'per_page': 0,
            'last_page': 0,
            'from': 0,
            'to': 0,
        },
        newService: [],
        errors: [],
        create: true,
        loading: true,
    },
    methods: {
        getServices: function(page){
            var url = "api/services?page="+page;
            this.loading = true;
            axios.get(url).then(response => {
                this.services = response.data.services.data;
                this.pagination = response.data.pagination;
                this.loading = false;
            });
        },
        deleteService: function(data){
            var service = data.service;
            var url = "api/services/" + service.id
            bootbox.confirm("Are you sure do you want delete the service?", function(result) {
                if(result == true) {
                    axios.delete(url).then(response => {
                        app.getServices();
                        toastr.success("The service was successfully removed");
                    });
                }
            }); 
        },
        showForm: function(){
            this.newService = [];
            this.create = true;
            this.errors = [];
            jQuery('#create').modal('show');
        },
        executeForm: function(service){
            if(this.create == true) this.createService();
            else this.updateService(service);
                
        },
        createService: function(){
           var url = 'api/services';
           this.errors = [];
            axios.post(url,{
                name: this.newService.name,
                description: this.newService.description,
                //price: this.newService.price,
                available: this.newService.available,
            }).then(response => {
                this.getServices();
                this.newService = [];
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The service was successfully added");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        editService: function(data){
            var service = data.service;
            this.newService = {
                name: service.name,
                description: service.description,
                //price: service.price,
                available: service.available,
                id: service.id
            };
            this.create = false;
            this.errors = [];
            jQuery('#create').modal('show');
        },
        updateService: function(service){
            var url = "api/services/" + service.id;
            axios.put(url,{
                name: this.newService.name,
                description: this.newService.description,
                //price: this.newService.price,
                available: this.newService.available,
            }).then(response => {
                this.getServices(this.pagination.current_page);
                this.newService = [];
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The service was successfully updated");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        changePage: function(data){
            var page = data.page;
            this.pagination.current_page = page;
            this.getServices(page);
        },
    },
});
