
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */
Vue.component('v-input', require('./components/vinput.vue'));
Vue.component('table_workers', require('./components/table_workers.vue'));
Vue.component('loading', require('./components/loading.vue'));
Vue.component('pagination', require('./components/pagination.vue'));

const app = new Vue({
    el: '#workers',
    created: function(){
        this.getWorkers();
    },
    data: {
        workers: [],
        pagination: {
            'total': 0,
            'current_page': 0,
            'per_page': 0,
            'last_page': 0,
            'from': 0,
            'to': 0,
        },
        newWorker: [],
        errors: [],
        create: true,
        loading: true,
    },
    methods: {
        getWorkers: function(page){
            var url = "api/workers?page="+page;
            this.loading = true;
            axios.get(url).then(response => {
                this.workers = response.data.workers.data;
                this.pagination = response.data.pagination;
                this.loading = false;
            });
        },
        deleteWorker: function(data){
            var worker = data.worker;
            var url = "api/workers/" + worker.id
            bootbox.confirm("Are you sure do you want delete the worker?", function(result) {
                if(result == true) {
                    axios.delete(url).then(response => {
                        app.getWorkers();
                        toastr.success("The worker was successfully removed");
                    });
                }
            }); 
        },
        showForm: function(){
            this.newWorker = [];
            this.create = true;
            this.errors = [];
            jQuery('#create').modal('show');
        },
        executeForm: function(worker){
            if(this.create == true) this.createWorker();
            else this.updateWorker(worker);
                
        },
        createWorker: function(){
           var url = 'api/workers';
           this.errors = [];
            axios.post(url,{
                name: this.newWorker.name,
                email: this.newWorker.email,
                phone_number: this.newWorker.phone_number,
                adress: this.newWorker.adress,
                ocupation: this.newWorker.ocupation,
                payment_type_id: this.newWorker.payment_type_id,
                salary: this.newWorker.salary,
            }).then(response => {
                this.getWorkers();
                this.newWorker = [];
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The worker was successfully added");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        editWorker: function(data){
            var worker = data.worker;
            this.newWorker = {
                name: worker.name,
                adress: worker.adress,
                email: worker.email,
                phone_number: worker.phone_number,
                ocupation: worker.ocupation,
                payment_type_id: worker.payment_type_id,
                salary: worker.salary,
                id: worker.id
            };
            this.create = false;
            this.errors = [];
            jQuery('#create').modal('show');
        },
        updateWorker: function(worker){
            var url = "api/workers/" + worker.id;
            axios.put(url,{
                name: this.newWorker.name,
                adress: this.newWorker.adress,
                payment_type_id: this.newWorker.payment_type_id,
                salary: this.newWorker.salary,
                email: this.newWorker.email,
                phone_number: this.newWorker.phone_number,
            }).then(response => {
                this.getWorkers(this.pagination.current_page);
                this.newWorker = [];
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The worker was successfully updated");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        changePage: function(data){
            var page = data.page;
            this.pagination.current_page = page;
            this.getWorkers(page);
        },
    }
});
