<?php $__env->startSection('content'); ?>
<div class="invoice" style="padding: 20px; width: 100%;">
    <table class="invoice-logo" style="width: 100%">
        <tr>
            <td style="width: 50%">
                <div class="invoice-logo-space">
                    <img src="theme/admin/pages/media/invoice/logo_factura.jpg" class="img-responsive" alt="">
                </div>
            </td>
            <td style="width: 50%">
                <p>
                    <?php echo e(date("d M Y",strtotime($invoice->created_at))); ?> <span class="muted"><?php echo e($invoice->type); ?> <?php echo e($invoice->type == "invoice" ? "# ".$invoice->number : ""); ?></span>
                </p>
            </td>
        </tr>
    </table>
        <hr>
        <div class="row">
            <div class="col-xs-4">
                <h3>Client:</h3>
                <ul class="list-unstyled">
                        <li><?php echo e($invoice->client->name); ?></li>
                        <li><?php echo e($invoice->client->adress); ?></li>
                        <li><?php echo e($invoice->client->city); ?>, <?php echo e($invoice->client->state); ?> <?php echo e($invoice->client->zip); ?></li>
                </ul>
            </div>
            <div class="col-xs-8">
                <h3>About:</h3>
                <p><?php echo e($invoice_text->value); ?></p>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <table class="table table-bordered table-striped table-condensed">
                    <thead>
                        <tr>
                            <th>Item</th>
                            <th class="hidden-480">Description</th>
                            <th class="hidden-480">Quantity</th>
                            <th class="hidden-480">Unit Cost</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($invoice->services as $item) :?>
                        <tr>
                            <td><?php echo e($item->name); ?></td>
                            <td class="hidden-480"><?php echo e($item->description); ?></td>
                            <td class="hidden-480">--</td>
                            <td class="hidden-480">$<?php echo e(number_format($item->price,2)); ?></td>
                            <td>$<?php echo e(number_format($item->total,2)); ?></td>
                        </tr>
                        <?php endforeach;?>
                        <?php foreach ($invoice->products as $item) :?>
                        <tr>
                            <td><?php echo e($item->name); ?></td>
                            <td class="hidden-480"><?php echo e($item->description); ?></td>
                            <td class="hidden-480"><?php echo e($item->qty); ?></td>
                            <td class="hidden-480">$<?php echo e(number_format($item->price,2)); ?></td>
                            <td>$<?php echo e(number_format($item->total,2)); ?></td>
                        </tr>
                        <?php endforeach;?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <table style="width: 100%">
                <tr>
                    <td style="width: 50%">
                        <div class="well">
                            <address>
                            <strong><?php echo e($info['company_name']->value); ?></strong><br>
                              <?php echo e($info['company_adress']->value); ?>

                              <?php echo e($info['company_city']->value); ?>, <?php echo e($info['company_state']->value); ?> <?php echo e($info['company_zip']->value); ?><br>
                              <abbr title="Phone">contact us:</abbr> <?php echo e($info['company_phone']->value); ?> 
                              </address>
                              <address>
                              <abbr title="Phone">Email:</abbr><a href="mailto:#">
                              <?php echo e($info['company_email']->value); ?></a>
                            </address>
                        </div>
                    </td>
                    <td style="width: 50%" class="invoice-block">
                        <ul class="list-unstyled amounts">
                            <li><strong>Sub - Total amount:</strong> $<?php echo e(number_format($invoice->subtotal,2)); ?></li>
                            <li><strong>Discount:</strong> $<?php echo e(number_format($invoice->discount,2)); ?></li>
                            <li><strong>Tax:</strong> $<?php echo e(number_format($invoice->tax,2)); ?></li>
                            <li><strong>Grand Total:</strong> $<?php echo e(number_format($invoice->total,2)); ?></li>
                        </ul>
                    </td>
                </tr>
            </table>
            <table style="width: 100%; margin-top: 100px;">
                <thead>
                    <tr>
                        <td style="width: 70%">&nbsp;</td>
                        <td style="width: 30%">&nbsp;</td>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="width: 50%">&nbsp;</td>
                        <td style="width: 50%; text-align: center">
                            <p style="border-bottom: 1px solid #000000">&nbsp;</p>
                            <p><?php echo e($invoice->client->name); ?></p>
                        </td>
                    </tr>
                </tbody>
            </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.pdf', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>