<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    protected $fillable = ['type', "number", "deposit", 'subtotal', 'discount', 'tax', 'total', 'h', 'status', 'related_invoice', 'del'];
    
    public function payments()
    {
        return $this->hasMany(InvoicePayments::class);
    }
    public function products()
    {
        return $this->hasMany(InvoiceProducts::class);
    }
    public function services()
    {
        return $this->hasMany(InvoiceServices::class);
    }
    public function client()
    {
        return $this->hasOne(Client::class);
    }
}

