<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Worker;

class WorkersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Worker::with(["work_reports" => function ($query) {
            $query->where('status', 'Paid')->orderBy('date_paid','DESC')->orderBy('date','DESC');
        }])->orderBy('id','DESC')->paginate(25);
        return [
            'pagination' => [
                'total'         => $data->total(),
                'current_page'  => $data->currentPage(),
                'per_page'      => $data->perPage(),
                'last_page'     => $data->lastPage(),
                'from'          => $data->firstItem(),
                'to'            => $data->lastItem(),
            ],
            "workers" => $data
        ];
    }
    public function getAll(){
        $workers = Worker::get();
        return $workers;
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            "name" => 'required',
            "adress" => 'required',
            "payment_type_id" => 'required|integer',
            "salary" => 'required|numeric',
            "email" => 'email|unique:workers',
            //"phone_number" => 'required',
        ]);
        Worker::create($request->all());
        return;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if($request->get('email') != "") {
            $this->validate($request, [
                "name" => 'required',
                "adress" => 'required',
                "payment_type_id" => 'required|integer',
                "salary" => 'required|numeric',
                "email" => 'email|unique:workers,email,'.$id,
                //"phone_number" => 'required',
            ]);
        }
        else {
            $this->validate($request, [
                "name" => 'required',
                "adress" => 'required',
                "payment_type_id" => 'required|integer',
                "salary" => 'required|numeric',
                //"email" => 'email|unique:workers,email,'.$id,
                //"phone_number" => 'required',
            ]);
        }
        Worker::find($id)->update($request->all());
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Worker::findOrFail($id);
        $data->delete();
    }
}
