﻿// (c) ammap.com | SVG (in JSON format) map of Canada
// areas: {id:"CA-AB"},{id:"CA-BC"},{id:"CA-MB"},{id:"CA-NB"},{id:"CA-NL"},{id:"CA-NS"},{id:"CA-NT"},{id:"CA-NU"},{id:"CA-ON"},{id:"CA-PE"},{id:"CA-QC"},{id:"CA-SK"},{id:"CA-YT"}
AmCharts.maps.canadaLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"-141.007366",
				"topLatitude":"83.116658",
				"rightLongitude":"-52.646682",
				"bottomLatitude":"41.730628"
			}
		},
		"g":{
			"path":[
				{
					"id":"CA-AB",
					"title":"Alberta",
					"d":"M277.92,1131.52L241.5,1131.52L241.5,1131.52L241.55,1130.91L240.36,1129.13L238.88,1128.55L236.99,1126.04L236.88,1123.98L235.48,1123.38L236.3,1121.4L235.92,1118.58L236.22,1117.39L234.99,1112.65L233.16,1110.04L232.28,1109.48L231.25,1109.92L230.36,1108.78L229.99,1107.45L227.41,1105.66L227.83,1104.9L227.55,1104.14L225.98,1102.61L224.15,1101.76L223.76,1100.33L221.89,1099.01L221.35,1097.21L219.05,1094.3L218.09,1092.28L217.33,1092.31L216.69,1093.37L215.95,1093.39L214.83,1090.9L212.97,1088.56L212.3,1086.97L209.9,1087.18L208.44,1086.22L207.8,1085.28L208.61,1083.65L206.18,1082.15L205.66,1083.22L204.22,1083.61L204.19,1082.19L203.06,1080.12L203.24,1078.87L201.93,1076.36L200.55,1075.9L200.12,1074.17L199.33,1073.58L199,1072.27L197.3,1071.04L197.04,1072.48L194.9,1071.43L193.65,1069.29L191.14,1069.02L189.89,1067.21L189.23,1066.85L189.01,1065.39L190.58,1065.35L190.65,1065.07L189.96,1064.08L189.13,1063.72L188.26,1061.89L188.27,960.68L188.27,960.68L277.92,960.68L277.92,960.68z"
				},
				{
					"id":"CA-BC",
					"title":"British Columbia",
					
"d":"M154.04,960.68h34.24l0,0l-0.01,101.21l0.87,1.83l0.83,0.37l0.69,0.98l-0.07,0.28l-1.57,0.04l0.22,1.46l0.67,0.37l1.25,1.81l2.51,0.27l1.24,2.14l2.14,1.04l0.26,-1.44l1.69,1.23l0.33,1.31l0.79,0.59l0.43,1.73l1.38,0.46l1.32,2.51l-0.18,1.26l1.12,2.07l0.04,1.42l1.44,-0.39l0.52,-1.07l2.42,1.51l-0.81,1.62l0.64,0.94l1.46,0.96l2.4,-0.21l0.68,1.58l1.86,2.34l1.11,2.49l0.74,-0.02l0.64,-1.06l0.75,-0.03l0.96,2.02l2.31,2.92l0.53,1.79l1.87,1.33l0.4,1.43l1.83,0.84l1.57,1.54l0.28,0.75l-0.41,0.76l2.58,1.79l0.37,1.33l0.89,1.14l1.03,-0.44l0.88,0.56l1.83,2.61l1.23,4.74l-0.3,1.19l0.38,2.83l-0.82,1.98l1.4,0.6l0.11,2.06l1.89,2.51l1.48,0.58l1.19,1.78l-0.05,0.61l0,0h-78.23l-1.21,-1.11l-0.7,0.19l-0.42,0.92h-0.33l-0.28,-0.86l0.34,-1.01l-0.92,0.01l-0.43,-1.79l2.53,-0.45l0.61,-1.45l-1.22,1.05l-2.34,-0.3l0.8,-4.63l-1.23,1.42l-0.1,1.63l-0.91,0.11l-0.84,0.74l-3.24,-1.34l-1.23,-1.49l-0.23,-0.81l0.55,-1.03l0.63,0.26l0.95,1.81l0.7,-0.1l1.4,-1.21l-1.62,0.31l-1,-1.08l-0.27,-3.39l1.07,-1.49l-0.37,-0.78l-1.08,-0.55l0.72,1.56l-0.82,1.1l-0.25,1.63l-1.4,1.15l-1.25,0.29l-1.81,-0.5l-2.68,-2.94l-1.35,-3.88l-0.47,-0.81l-0.52,-0.11l-0.12,-0.77l1.74,-3.08l0.02,-3.32l-0.66,0.88l-0.08,2.05l-1.04,2.14l-1.35,0.53l-2.39,-0.29l-0.45,-0.52l-0.12,-1.62l-0.63,2.29l-0.78,0.3l-0.67,-0.61l-1.73,0.29l-4.35,-0.88l0.3,-0.81l4.65,-1.09l-0.75,-0.38l-3.49,0.63l-1.29,-0.18l-0.03,-0.64l1.28,-1.6l-1.32,-0.41l0.33,-1.34l-0.29,-1.37l-1.03,2.01l-3.82,0.67l-2.68,-1.11l-3.15,-2.92l-0.06,-1.68l0.73,-2.27l2.56,-3.09l5.87,-0.88l-5.8,-0.06l-0.93,0.41l-1.81,2.88l-0.62,-0.17l-1.22,-2.63l-0.11,-2.13l1.22,-2.5l-1.18,0.04l0.14,-1.4l0.43,-1.52l3.2,-2.41l1.75,-0.57l0.6,1.17l1.5,0.35l2.64,3.35l-1.62,-2.4l-0.38,-1.21l-1.69,-0.91l-0.6,-1.27l0.06,-1.18l1.72,-1.77l0.39,-0.93l-0.51,-1.79l-0.04,1.81l-0.48,0.99l-4.06,4.31l-1.74,0.6l-1.08,0.99l-2.4,6.72l-0.82,-3.04l-1.47,-2.34l2.87,-2.33l-0.13,-1.98l1,-1.35l-0.88,0.21l-2.09,2.47l1.25,-6.52l0.71,-1.55l-2.79,1.26l-0.78,-0.75l-0.65,-3.92l-1.14,-1.54l-1.94,-1.26l-1.9,-0.59l-0.81,-2.5l0.51,-1.62l0.83,-0.77l0.77,-0.35l0.73,0.16l-0.46,2.19l3.26,2.08l0.57,0.16l1.08,-0.74l2.02,0.63l1.84,2.14l-0.2,-0.83l-2.31,-2.3l-2.73,0.1l-1.47,-1.17l-0.79,-2.9l0.44,-0.96l1.64,-0.73l-1.06,-0.92l-0.48,0l-1.66,1.35l-0.62,-0.18l-2.23,3.02l-0.45,3.36l-1.83,1.07l-0.91,1.42l-2.31,-2.42l-0.81,-2.08l-1.46,-0.37l-1.69,-1.18l-0.65,-1.05l0.92,-2.17l1.32,-1.64l0.38,-2.4l2.26,-0.49l1.48,-0.99l-2.44,0.06l-1.67,0.69l-1.85,-1.36l-0.95,-1.25l-0.3,-1.06l0.72,-3.61l1.18,-1.16l2.95,-6.76l2.95,-4.68l-1.26,0.38l-0.84,-1.91l-0.38,3.79l-1.89,4.1l-0.39,-0.79l0.86,-2.45l0.1,-1.49l-0.97,-4.31l0.71,-5.07l-0.75,-2.54l-1.05,0.42l-1.78,-0.64l-0.57,-1.74l-1.54,-0.53l-0.83,-1.24l-3.06,-1.03l-4.41,-3.14l-2.23,0.14l-0.08,-1.54l-0.47,-0.93l0.18,-0.83l-2.13,-1.04l0.65,-2.78l-2.75,-0.87l0.95,-1.96l-10.67,-19.1l0.19,-1.26l-3.76,-5.05l-4.27,-3.34l-1.29,-3.25l-3.24,-2.88l-1.27,-0.67l-1.14,-2.69l0.18,-2.42l-3.81,-3.8l-4.11,2.32l-3.47,1.02l0.67,1.27l-0.28,0.93l-0.63,0.43l-1.06,-0.05l0,3.15l-1,2.23l-2.1,0.04l-4.16,2.82l-1.44,1.48l-0.74,-0.21l0.33,-1.32l-0.98,-4.1l-9.31,-9.73l-0.66,-2.19l-3.15,-1.79l0,0L154.04,960.68zM96.71,1043.71l0.38,-1.74l1.21,-2.52l-0.99,-5.63l0.31,-1.99l0.78,-1.73l-0.87,3.14l0.94,6.41L96.71,1043.71zM93.47,1047.7l3.24,-3.99l0.09,1.23l-1.3,2.06l-1.67,1.02L93.47,1047.7zM90.32,1052.19l-0.24,-0.97l0.42,-1.39l1.33,0.28l-0.05,0.57L90.32,1052.19zM74.82,1057.57l0.82,0.9l2.34,-0.46l1.23,2.19l-0.08,1.65l-3.49,2.4l0.27,0.54l3.12,-0.5l0.65,-2.65l-0.18,-2.65l1.74,-0.12l2.45,-1.52l-0.31,2.36l-1.67,4.13l-0.61,6.1l-0.48,0.65l-3.01,1.13l-1.55,-0.07l-2.04,-1.74l0.49,-0.86l2.4,0.46l-2.2,-1.83l-1.57,-0.74l-2.1,-4.97l-0.17,-2.56l0.44,-2.34L74.82,1057.57zM96.51,1060.15l-1.33,1.74l-0.77,-0.27l-1.07,-1.19l-0.47,0.29l-0.02,1.16l-0.53,-0.72l0.5,-1.5l1.78,-1.49l1.18,0.64L96.51,1060.15zM99.99,1072.05l-0.77,-0.13l-1.95,-2.53l-1.38,-0.92l-1.9,-2.06l0.59,-1.31l4.55,2.93l1.7,2.87L99.99,1072.05zM106.09,1072.8l-0.98,0.1l-0.42,-0.46l0.77,-2.81l0.55,1.06L106.09,1072.8zM111.61,1075.45l0.38,6.22l-1.52,3.36l-0.47,-0.98l-0.32,-3.55l0.18,-2.43l-0.76,1.25l-0.62,0.07l-1.1,-1.21l-1.37,-3.1l1.28,-4.69l1.57,0.77l2.02,1.73L111.61,1075.45zM82.91,1071.64l0.91,1.38l0.16,2.69l-1.44,0.55l-0.76,-0.44l-0.83,0.52l2.19,1.83l2.44,0.81l-1.21,1.82l1.44,2.29l1.53,0.09l-0.54,1.65l1.59,0.17l0.24,1.05l-0.94,0.96l-1.8,-1.23l-1.26,-2.37l-5.41,-5.64l-0.83,-2.23l1.01,-0.35l0.01,-0.62l-2.91,-1.08l-0.7,-0.98l3.52,-0.34l2.34,-1.06L82.91,1071.64zM104.78,1074.67l-0.86,-0.47l-0.81,-1.57l-0.01,-0.89l0.45,0.2L104.78,1074.67zM108.16,1081.79l-0.29,0.67l-1.63,-2.07l-0.89,-1.72l0.04,-1.32l2.26,2.21l0.48,0.9L108.16,1081.79zM113.25,1083.39l-0.69,0.2l0.29,-1.25l-0.24,-3.29l0.67,-1.26l1.05,-0.04L113.25,1083.39zM89.4,1089.8l-0.66,-0.76l0.05,-1.99l0.78,0.81L89.4,1089.8zM117.23,1096.84l-1.08,0l-0.93,-2.2l1.05,-1.18l1.03,1.77L117.23,1096.84zM123.75,1108.7l4.45,1.76l9.73,2.2l1.19,0.58l2.23,4.25l2.68,3.89l0.27,0.64l-0.23,0.58l0.9,1.56l1.68,1.4l5.8,2.81l1.58,1.92l2.9,6.81l0.48,-1.47l0.48,0.27l0.95,2.9l-0.24,0.59l-1.21,-0.22l-1.14,1.41l-3.08,-0.86l-6.92,-2.84l-3.87,-2.21l-0.13,-0.83l2.56,-2.8l0.33,-2.52l-1.03,2.71l-3.9,0.22l-1.14,0.88l-3.04,-2.15l1.65,-1.28l-0.75,-0.19l-0.96,-1.05l-1.04,0.39l-0.29,-0.55l0.43,-1.56l-0.76,0.46l-0.71,-0.73l-1.29,-0.29l-0.55,0.83l-1.26,-0.95l-0.67,0.75l-0.4,-2.01l0.2,-0.65l3.66,-1.13l-1.91,0.16l-1.03,-0.82l-0.56,0.01l-1.42,-2.17l-1.97,-0.94l-0.66,0.85l-1.23,0.04l-0.73,-0.96l0.15,-1.72l-0.63,-0.9l-0.36,0.94l-0.53,0.26l-1.06,-1.55l-1.86,0l-0.86,0.59l-0.84,-0.09l0.22,-2.31l-1.11,-0.74l0.51,-1.39l2.37,-0.48l1.39,1.04l-0.38,-1.86l0.57,-0.65l-2.56,-0.34l0.18,1.01l-1.2,0.52l-1.74,0.01l-1.87,-1.56l-0.74,-1.23l0.03,-0.67l0.94,-1.19l2.9,-0.46l1.84,0.56L123.75,1108.7zM141.8,1116.31l-0.1,0.74l-1.46,-3.73l0.51,-1.44l0.94,0.34l1.09,2.37L141.8,1116.31zM143.65,1117.25l-0.21,0.12l-0.22,-1.58l0.31,-1.16l0.75,1.86L143.65,1117.25zM128.74,1123.12l-0.92,-0.11l-1.75,-1.45l0.37,-0.89l-0.26,-0.76l0.89,-0.48l0.79,0.4l0.79,1.36L128.74,1123.12zM151.04,1124.15l0.12,0.29l-1.99,-1.07l-2.58,-2.35l0.24,-0.23l1.81,0.66L151.04,1124.15zM133.66,1126.59l0.25,1.24l-1.48,-0.44l0.19,-1.15L133.66,1126.59zM158.04,1132.98l-1.51,-0.81l-1.33,-2.03L158.04,1132.98zM157.48,1134.76l-0.38,0.35l-0.36,-0.29l-0.58,-2.38l1.03,0.79l-0.18,0.29l0.72,1.22L157.48,1134.76z"
				},
				{
					"id":"CA-MB",
					"title":"Manitoba",
					"d":"M466.63,1014.55L444.85,1039.15L424.75,1063.34L411.01,1077.19L410.99,1126.37L410.99,1126.37L410.93,1131.54L355.31,1131.52L355.31,1131.52L349.63,1031.23L349.62,960.68L349.62,960.68L414.43,960.67L414.43,960.67L414.28,973.66L413.55,976.8L412.77,977.13L414.39,977.97L415.31,980.58L416.16,980.61L417.59,982.74L418.78,983.24L418.37,990.41L418.91,989.04L419.48,984.79L420.25,982.89L420.85,982.48L423.32,982.27L425.96,982.75L427.82,982.55L428.71,983.08L429.42,987.13L435.4,1006.83L434.99,1008.73L433.77,1011.47L432.13,1013.39L435.19,1011.51L436.56,1011.36L436.09,1012.59L439.12,1011.06L447.25,1008.13L449.16,1007.88L451.9,1008.41L459.08,1012.42z"
				},
				{
					"id":"CA-NB",
					"title":"New Brunswick",
					
"d":"M690.01,1170.96l-0.18,0.45l-0.97,0.17l-1.39,1.66l0,0l-1.5,0.38l-1.35,-1.8l0.35,1.71l-1.66,2.24l-1.07,0.16l-5.8,3.68l-3.04,1.45l-0.64,0.01l-1.38,-1.2l0.75,-1.28l-1.4,1.05l0.68,0.99l-0.33,0.37l-2.65,1.67l-0.64,-0.6l-3.24,0.96l-0.41,-0.99l-0.52,-0.15l-0.96,0.17l-1.48,-0.72l-0.59,0.6l-1.41,-1.55l0.4,-1.3l-0.59,-1.22l0.62,-0.72l-0.07,-0.93l-1.46,-0.23l-1.85,-1.37l0.32,-2.56l-0.36,-15.01l-3.84,-3.46l-1.1,0.02l-0.17,0.37l-4.05,1.49l-1.56,-0.44l-0.45,-0.77l0,0l3.81,-1.66l1.78,-1.42l0.45,-0.8l0.01,-4.53h2.37v-0.92h4.49l0.3,0.79l1.92,1.13l0.52,-0.43l2.24,-0.42l0.95,0.25l0.24,-0.85l1.98,-0.79l0,0l0.65,0.15l1.82,-0.75l0.62,0.08l1.34,0.96l3.23,1.04l0.84,0.68l0.8,2.18l0.53,0.35l1.11,-0.23l2.29,-1.65l2.03,-0.47l-0.4,0.72l1.55,-0.06l1.53,0.96l-1.33,2.06l-0.54,2.66l-3.65,3.52l1.14,0.68l1.34,-0.51l1.89,0.37l-0.67,2.26l0.8,2.47l0.81,0.36l0.7,4.1l0.82,0.58l0.14,0.92l2.96,0.26l3.04,0.96l0.37,0.5l-2.01,1.1L690.01,1170.96zM686.02,1145.47l-1.03,0.69l0.82,-1.42L686.02,1145.47zM685.73,1146.43l-0.23,0.97l-0.78,0.82l-0.57,-0.02l0.19,-1.46L685.73,1146.43zM665.52,1187.89l-1.21,0.66l0.85,-2.22l0.51,0.18L665.52,1187.89z"
				},
				{
					"id":"CA-NL",
					"title":"Newfoundland and Labrador",
					
"d":"M752.14,1097.28l-0.01,-8.05l-59.67,-0.14l-0.26,-0.58l1.09,-0.14l-0.91,-3.46l-1.52,-1.22l-0.14,-0.7l-0.99,-0.42l0.02,-0.4l1.44,-1.53l4.38,-1.47l-1.26,-1.26l-0.04,-2.82l-1.05,-2.03l-0.46,-0.13l-1.64,0.48l-0.61,2.7l-1.49,0.6l-0.35,0.58l-0.04,3.85l0.72,2.58l-0.25,2.8l-1.26,1.51l-0.57,3.5l0.4,1.63l-1.94,1.73l-0.82,0.12l-0.94,-2.09l0.68,-1.16l-2.74,-3.33l-1.84,-1.45l-2.82,-0.7l-1.23,1.89l-1.72,-0.45l-0.42,0.75l-0.5,-0.03l-1.37,-0.8l-0.55,-1.46l-1.64,-1.33l-0.59,2.13l-0.56,-0.42l-0.49,-1.62l0.61,-1.81l-0.29,-3.57l1.13,-3.49l-1.15,-1.69l-0.36,-0.12l-0.48,0.89l-0.84,0.4l-0.66,3.03l-1.13,0.6l-1.22,-0.17l-1.05,-0.84l0.13,-2.44l0.75,-2.27l0.23,-4.21l-1.18,-0.93l-0.8,-1.89l-2.77,-1.06l0.02,-2.77l-2.6,-4.01l2.24,-2.68l-0.88,-3.31l0.07,-1.56l0.58,-0.31l2.25,0.83l0.44,-1.03l0.77,-0.48l0.03,-0.56l-2.41,-5.13l0.07,-1.37l0.95,0.13l1.21,1.97l2.69,2.43l1.28,0.51l0.66,-0.78l-0.87,-5.15l0.2,-1.32l-0.65,-1.27l0.21,-0.54l5.53,5.64l2.45,0.94l0.78,1.59l1.08,0.93l4.97,0.4l7,-0.11l3.86,1.43l1.89,0.29l2,-5.38l-0.67,-1.94l0.15,-0.85l3.79,-3.13l-0.38,-2.74l-1.35,-0.45l-0.99,-0.85l-2.56,-4.21l0.02,-1l1.25,-1.1l-0.18,-0.53l-3.82,-1.15l0.11,-0.76l0.83,-1.09l-1.99,-1.4l-0.13,-1.54l1.62,-0.72l0.26,-0.59l-1.7,-3.77l1.9,-2.97l0.24,-2.19l1.06,-3.37l-0.38,-1.51l0.52,-1.28l-0.15,-2.61l1.29,-1.94l0.12,-0.9l-1.02,0.46l-0.7,-0.17l-1.5,-1.61l-0.75,0.28l-1.62,-3.91l-1.44,-1.38l-0.07,-0.77l2.66,-3.65l2.24,-1.72l-0.31,-1.64l-1.61,0.01l-0.08,-1.49l0.99,-0.73l4.16,-1.19l-0.85,-1.32l-1.21,-0.55l-4.17,1.61l-0.92,-1.68l-4.97,-1.44l0.14,-1.23l0.56,-0.5l3.38,0.87l0.62,-0.37l-1.38,-1.67l-0.37,-1.91l0.15,-3.03l1.12,-1.35l-0.06,-0.7l-0.53,-0.23l-2.42,1.09l-0.93,-1.3l0.24,-4.88l1.16,-1.89l-1.55,-1.15l-0.48,-0.89l2.13,-1.34l0.25,-0.56l-1.5,-0.99l-0.51,-0.99l2.08,-1l0,0l1.59,1.41l0.15,1.02l-0.97,1.38l-2.16,1.48l0.32,0.26l1.55,-0.82l2.47,-0.37l0.9,1.63l0.13,2.26l-0.52,1.87l1.53,-1.45l1.14,3.15l1.6,2.34l-1.98,1.82l0.23,0.51l1.48,0.54l0.04,1.26l1.24,-1.13l0.88,0.15l1.12,2.42l-0.82,1.38l-1.25,0.63l-2.92,0.44l0.27,0.46l1.32,0.01l3.54,-0.92l1.35,0.2l0.23,0.19l-0.78,0.53l0.84,1.71l-0.59,1.05l0.87,0.17l1.21,-0.35l1.58,3.55l-2.05,2.18l-2.58,1.6l-1.32,2.09l0.57,-0.01l2.36,-2.33l0.58,0.11l0.12,0.85l3.54,-1.39l1.16,-0.07l0.13,0.38l-0.72,2.64l-1.23,2.02l-2.25,1.24l-1.78,1.9l0.37,0.21l3.61,-2.15l2.97,-0.42l1.62,3.08l1.69,0.14l1.42,0.88l0.53,0.85l-0.86,1.54l0.57,1.69l-0.33,0.95l-3.32,2.13l-1.41,-0.08l0.89,0.68l2.76,-0.08l1.5,0.53l0.64,0.84l-1.14,2.03l1.05,0.83l2.08,0.24l2.64,2.84l-0.51,2.58l0.17,2.81l-1.43,0.43l-4.76,-0.72l-2.72,-1.11l-0.14,-0.34l0.77,-0.74l-1.81,0.51l0.91,1.17l2.5,1.03l1.12,1.24l1.23,0.11l1.05,0.95l-1.45,0.33l-0.99,0.83l0.62,0.49l3.82,0.54l0.8,0.48l-2.53,1.16l-0.05,0.93l1.38,0.37l1.74,-0.13l0.57,2.71l-1.32,0.4l-0.01,0.43l2.35,0.64l0.88,1.42l0.84,0.06l1.47,-1.52l0.79,0.26l0.06,0.87l1.29,1.15l0.27,1.4l0.77,-1.24l1.21,0.33l-0.6,2.15l1.94,2.67l-1.51,1.81l-0.8,2.61l-1.5,2.19l3.63,-2.76l2.53,-0.36l1.54,-0.79l0.57,0.64l0.06,1.14l0.75,0.36l0.79,-0.38l0.72,0.34l-2.72,3.64l-0.86,2l3.67,-3.76l1.51,-2.26l1.55,0.26l0.8,0.53l1.95,4.85l3.42,1l1.57,-0.6l0.25,-0.83l2.09,-0.15l0.3,1.59l0.92,0.84l1.79,1.06l1.29,0.16l0.7,0.76l-1.42,2.32l-1.22,0.83l-4.05,0.55l-0.61,0.98l-1.93,0.89l-1.78,2.73l-2.57,0.25l-1.06,1.06l-4.1,1.96l-2.93,0l-2.09,1.53l-0.79,2.07l-2.25,-0.86l0.23,0.69l2.41,1.81l-1.7,1.43l-0.14,0.47l0.49,0.25l-0.85,0.82l0.15,0.34l1.62,-0.6l2.86,-2.97l1.86,-0.49l2.68,-1.61l3.61,-3.5l2.4,-1.56l2.92,-1.13l3.5,-0.6l-1.16,-0.54l-2.26,0.19l-0.35,-0.88l1.47,-0.86l6.96,1l1.95,3.63l0.57,2.01l-0.98,1.16l-2.51,1.57l1.24,0.77l0.49,1.38l2.87,-3.06l1.54,-1.01l3.37,-0.39l1,2.12l2.19,0.56l2.25,3.66l0.55,1.97l-0.85,3.15l0.56,1.81l-0.38,2.11l0.63,1.37l-4.39,1.02l-0.29,0.43l2.44,0.1l2.74,0.92l0.36,0.68l-0.64,0.94l-2.1,-0.44l2.88,2.24l-0.04,1.51l-5.26,4.95l-6.22,4.89L752.14,1097.28zM710.51,1002.93l0.75,0.49l0.2,1.81l-1.42,-0.11l-1.62,-1.21l-0.32,-0.88l1.46,-0.51L710.51,1002.93zM717.23,1027.69l0.11,0.39l-1.87,-0.52l0.3,-1.13l0.63,-0.36l1.08,0.67L717.23,1027.69zM767.73,1090.84l-0.52,-0.15l0.18,-0.56l1.13,-0.82l-0.17,0.95L767.73,1090.84zM766.85,1095.94l-1.12,2.12l-4.01,0.86l-0.12,0.95l0.4,0.89l1.42,-0.08l0.41,0.55l-0.04,1.89l-0.64,1.79l-2.11,2.1l-0.8,2.46l-2.32,2.88l-0.27,1.53l-2.23,3.67l-0.2,1.73l-0.85,1.63l0.35,0.76l-0.12,1.34l4,-4.43l1.16,-2.18l0.61,-0.35l0.51,0.73l-0.35,1.71l2.1,-1.08l1.45,0.8l2.35,-0.32l-0.72,1.26l-4.09,2.6l-0.9,1.18l1.45,-0.81l0.97,0.11l-0.2,1.24l-1.75,1.77l2.44,-0.87l1.23,1.11l2.71,-0.76l0.29,1.61l0.57,-0.55l-0.03,-1.39l0.48,0.08l0.26,1.37l-1.28,3.29l-0.1,1.21l0.9,-0.57l0.07,-1.08l0.61,-0.61l1.34,-0.83l0.09,0.62l0.3,-0.11l4.31,-3.56l0.3,-0.03l0.19,2.75l0.83,-1.18l3.57,-0.37l3.03,1.65l0.45,0.79l-0.03,1.68l-1.66,1.44l-1.3,1.99l-2.31,1.38l2.77,-0.32l-1.01,1.42l2.4,0.36l-0.07,0.33l-0.79,1.75l-2.87,1.79l2.83,-0.75l0.54,-0.63l0.85,-0.21l0.83,0.4l1.26,-1.08l1.71,-0.21l1.46,-1.1l0.27,0.33l-0.09,1.61l-0.88,1.54l-1.78,0.62l-0.64,0.83l-1.83,1.16l0.44,0.45l-0.08,1.15l-2.69,0.91l2.07,0.07l-0.51,1.25l-1.51,1.79l0.88,1.82l0.83,0.02l0.61,-0.19l0.9,-1.08l1.98,-3.38l3.24,-2l0.49,0.46l-2.58,5.05l-0.14,2.95l0.42,0.75l1.59,-1.29l1.46,-2.88l0.64,0.32l0.52,2.6l-0.27,1.63l-2.05,4.25l0.27,1.21l-0.71,2.51l-1.37,2.13l-0.89,-0.06l-0.98,-0.75l-1.91,1.12l-0.48,-0.08l-0.07,-6.63l-3.7,4.01l-0.83,0.19l-0.64,-0.73l0.73,-2.7l2.18,-4.66l-1.25,-4.19l-1.82,-1.38l-2.66,6.05l-0.67,0.38l0.79,-2.27l-1.59,1.84l-1.84,0.31l-2.1,2.78l-0.44,1.68l-1.58,1.84l-1.93,-0.11l-2.31,0.61l-1.45,-0.79l0.27,-1.17l0.72,-0.72l3.11,-1.17l2.7,-3.8l2.88,-1.61l0.76,-1.24l-1.45,0.58l-1.15,-0.49l-2.62,-0.05l-0.61,2.12l-1.27,0.48l-2.56,-0.86l-2.38,0.36l2.33,-1.19l0.08,-3.01l-1.45,0.74l-0.91,-0.34l-1.27,1.74l-4.58,1.24l-6.27,-0.88l-1.67,0.08l-2.38,-0.66l-3.65,-0.03l-0.03,-0.72l-2.48,1.39l-4.52,0.74l-1.28,-0.84l-0.55,-1.36l-0.37,-2.02l0.81,-1.42l2.79,-2.19l3.19,-3.38l2.46,-1.49l-3.52,-0.25l-3.98,0.25l-0.01,-0.5l2.92,-2.54l-0.58,1.3l0.56,0.61l1.14,0.1l2,-5.5l0.81,-1.11l1.95,0.31l1.22,1.01l0.53,-0.01l-0.97,-1.22l1.07,-2.08l-1.89,-0.4l-0.2,-1.75l0.95,-1.55l0.82,-0.59l1.43,0.95l0.58,-0.22l-0.95,-1.52l-0.26,-1.39l4.42,-11.22l0.92,-1.4l1.35,-0.14l-1.06,-1.18l2.19,-2.24l0.43,-1.17l-0.27,-1.01l1.89,-1.63l1.28,-2.96l5.89,-3.38l1.11,0.06l0.33,0.8l1.57,0.53l0.28,-0.57l-0.37,-0.7l0.31,-0.28l1.3,-0.25l0.61,0.49L766.85,1095.94zM766.16,1107.58l-0.84,-0.01l0.22,-0.85l1.21,-0.22L766.16,1107.58zM779.09,1121.21l1.01,1.14l-2.74,0.92l0.08,-1.6l0.7,0.32l0.55,-0.87L779.09,1121.21zM774.96,1123.36l-2.08,1.28l-0.69,-1.1l0.45,-0.32l0.72,0.51l1.56,-0.96L774.96,1123.36zM777.89,1152.34l-0.89,0.44l1,-2.34l0.78,-0.82L777.89,1152.34z"
				},
				{
					"id":"CA-NS",
					"title":"Nova Scotia",
					
"d":"M716.24,1171.84l2.15,-0.5l-0.03,0.45l-1.52,0.85l0.59,0.57l-1.08,1.15l0.3,0.58l1.15,-0.57l1.73,-0.05l2.49,-2.79l-2.19,0.46l-0.25,-0.3l1.43,-1.35l-0.11,-0.71l0.72,-1.12l1.86,-1.39l0.64,1.5l1.2,-0.13l2.04,0.6l0.15,0.6l-0.76,1.2l0.95,0.7l-0.13,0.3l-1.56,0.79l-3.32,2.89l-2.57,0.82l-1.78,-0.25l-3.69,0.47l-1.49,-1.82l-0.41,-2.89l0.13,-1.52l0.64,-1.43l1.51,-1.71l3.32,-6.42l2.68,-2.64l1.46,-0.06l-0.15,1.05l0.83,2.43l-1.34,4.21l-0.11,1.85l-0.74,1.27L716.24,1171.84zM687.46,1173.24l1.39,-1.66l0.97,-0.17l0.18,-0.45l0,0l2.94,1.99l1.74,-0.21l1.94,1.57l3.42,-0.31l1.88,0.46l-0.44,1.18l1.47,-0.16l0.92,0.5l4.73,-3.15l0.7,1.97l0.9,0.75l1.07,0.17l1.48,-0.57l1.27,1.45l0.61,1.69l-1.6,0.95l3.18,0.23l0.67,0.72l-0.62,0.74l-0.58,-0.29l-1.06,0.26l-11.03,4.95l-4.64,1.62l-1.11,0.04l-1.35,0.86l-1.35,0.03l-1.32,-0.54l0.53,1.75l-0.58,0.8l-1.89,-0.38l-1.61,-1.68l-0.91,1.97l-0.59,-1.24l-1.07,0.46l-0.47,1.32l0.56,1.38l-0.53,0.53l-0.39,-0.14l-0.81,1.48l-0.98,0.54l-2.54,3.41l-2.01,1.74l-1.33,0.01l-0.85,0.72l-0.13,1.46l-0.75,-0.15l-0.48,0.53l-0.74,-0.43l-0.87,0.24l-0.68,-0.33l-1.33,-2.9l-0.82,-0.24l-0.53,0.9l-0.79,-0.89l-0.6,-4.1l0.84,-2.79l2.08,-2.52l-0.66,-0.08l-1.83,1.75l1.12,-1.58l0.94,-0.67l2.7,-0.82l1.02,-1.01l-2.03,0.8l0.64,-0.79l6.76,-4.55l4.07,-1.71l0.38,-0.63l-0.37,-0.4l1.05,0.36l-0.21,2.17l1.07,0.3l0.89,1.15l-0.42,-1.57l0.8,-0.89l3.09,-1.19l2.58,-0.13l0.83,-0.55l-2.21,-0.37l-2.62,0.2l-1.62,-0.42l-2.23,0.27l-2.36,-0.26l-1.31,1.09l-1.49,-0.64l0.77,-1.28l2.4,-1.91L687.46,1173.24zM717.52,1177.66l-0.37,0.11l-0.71,-0.97l1.52,-0.12L717.52,1177.66zM669.9,1192.76l-0.45,0.44l1.02,-1.68L669.9,1192.76zM728.05,1197.15l-2.24,0.41l-0.71,-0.58l2.25,0.08l1.25,-0.69L728.05,1197.15z"
				},
				{
					"id":"CA-NT",
					"title":"Northwest Territories",
					
"d":"M277.88,449.94l0.01,16.42l0,0l-3.72,1.18l-3.02,-0.7l-3.71,-3.35l-0.54,0.44l-1.85,3.94l-0.74,0.56l-2.17,-0.36l-3.33,-3.68l-3.82,1.09l-3.96,2.15l-1.55,0.4l-1.08,-2.24l1.28,-3.29l2.64,-2.61l5.75,-3.64l4.53,-1.22l1.69,-1.29l1.07,-1.85l2.95,-2.94l1.74,-1.22l2.33,-1.05l1.88,0.05L277.88,449.94zM277.89,476.53v6.93l0,0l-6.7,3.06l-1.03,0.98l0.48,1.31l0.83,0.92l3.83,-0.21l0.92,0.4l0.64,2.59l0.01,3.81l-0.73,4.17l-4.34,3.25l-1.89,0.82l-1.49,-0.3l-1.49,0.19l-6.51,3.46l-2.01,0.02l-1.76,-0.83l-2.43,-3.27l-2.53,-1.29l-2.14,-2.29l-0.4,-2.08l0.79,-2.19l-1.46,-7.6l0.13,-2l0.74,-2.23l3.43,-1.25l4.48,-2.8l9.84,-3.52l2.99,0.33l1.31,-0.69l2.41,-0.29L277.89,476.53zM243.56,490.88l-2.45,1.43l-1.63,-0.03l-2.88,-2.02l-3.34,-6.22l-0.44,-2.23l1.25,-0.4l2.54,-2.74l2.48,-1.61l0.45,3.17l0.89,0.26l0.84,0.87l1.7,2.68l1.16,0.51l1.35,3.03l-0.01,0.8L243.56,490.88zM228.15,507.16l0.68,1.59l-0.28,1.31l-1.05,1.07l-5.29,3.55l-1.04,1.66l0.39,1.42l3.84,5.29l0.42,1.2l-0.92,1.22l-1.76,-0.39l-1.28,0.67l0.17,1.07l1.95,3.53l0.63,2.86l-2.46,3.89l-2.22,1.31l-4.77,1.75l-0.41,6.06l-0.98,2.85l-1.73,0.96l-1.3,0l-3.13,-2.73l-1.36,-2.32l-0.24,-1.55l0.49,-4.9l1.66,-8.18l-0.34,-0.78l-0.56,-0.04l-2.89,1.75l-0.88,0.93l-0.97,2.9l-0.53,4.45l-0.95,0.85l-1.42,-0.02l-0.54,0.48l-0.07,1.89l1.4,1.77l0,3.15l-1.51,2.18l-1.64,4.97l-0.78,0.78l-0.78,-0.09L195,554.3l-2.46,-6.82l-0.51,0.52l-0.61,1.77l0.08,4.63l-0.9,1.46l0.13,0.66l1.57,1.78l0.21,2.03l-0.1,0.56l-0.63,-0.09l-1.14,2.55l-1.6,2.08l-2.22,0.25l-2.23,0.96l-1.38,-6.73l-0.66,-0.95l-1.21,-4.94l-0.69,-0.61l-0.46,0.72l-1.07,5.34l-1.74,1.36l-1.92,0.1l-2.39,-1.45l-1.92,-0.54l-1.34,0.62l-3.08,2.74l-1.19,-0.25l-0.96,-2.15l-0.05,-0.81l0.89,-1.84l-0.56,-1.53l0.14,-1.52l-0.82,-0.01l-1.96,1.04l1.15,-3.49l2.28,-4.74l1.38,-1.83l6.74,-1.53l0.47,-0.46l4.12,-7.99l5.53,-5.17l1.56,-4.39l0.99,-1.06l3.31,-5.68l4.55,-6.72l2.1,-2.62l2.42,-1.13l7.3,-1.99l5.26,2.61l1.25,0.16l1.17,-1.94l0.79,0.51l1.95,0.37l1.25,-1.65l-0.56,-0.75l-2.36,-1.38l-0.09,-1.37l1.83,-2.64l2.9,-0.78l1.33,0.2l1.38,1.11l1.8,2.29L228.15,507.16zM246,531.96l-1.36,1.28l-9.31,-1.89l-0.75,-1.4l1.69,-2.21l2.04,-0.96l4.74,-0.77l1.65,0.87l1.71,1.89l0.26,1.64L246,531.96zM277.9,577.04l0,24.13l0,0l-3.44,1.27l-1.4,1.15l-1.85,3.15l-1.72,1.66l-7.06,4.61l-7.09,2.85l-4.46,0.5l-4.46,-0.94l-2.89,-1.97l-3.87,-3.88l-0.97,-2.25l0.58,-1.5l1.62,-1.74l2.42,-1.58l4.83,-2.15l4.38,-3.46l1.55,-0.65l4.21,-0.53l2.13,0.33l2.55,-0.66l3.7,-3.77l1.61,-2.36l0.41,-1.11l-0.54,-1.04l-0.79,-0.15l-3.94,3.25l-1.43,0.06l-3.88,1.16l-0.37,-0.03l-2,-2.32l-1.07,-0.41l-0.95,0.86l-1.36,2.33l-0.86,0.45l-6.82,1.36l-0.74,-0.53l-0.45,-0.99l-0.37,-3.45l0.29,-1.7l0.85,-2.2l2.61,-3.35l-1.09,0.14l-2.6,1.3l-1.24,-2.09l-1.36,6.89l-1.04,-0.37l-1.29,-1.1l-0.48,-0.15l-0.28,0.35l1.4,3.66l0.01,1.06l-0.86,1.85l-5.09,3.88l-0.97,-1.15l-1.36,-3.2l-1.2,-0.47l-1.11,1.19l-0.64,2.47l-1.07,1.43l-3.71,-2.54l-2.99,-4.54l-3.27,0.71l-1.47,-0.16l-4.46,-1.67l-0.88,-2.39l0.78,-3.01l1.12,-2.3l1.17,-1.36l0.93,-0.48l2.36,-0.27l6.08,-0.09l1.22,-0.36l6.65,-4.49l1.73,-2.19l0.18,-0.99l-8.18,3.58l-3.51,0.77l-5.37,-0.58l-1.01,-0.56l-0.23,-1l1.71,-3.66l1.53,-0.94l3.7,-1.34l4.94,-1.19l3.24,-0.03l2.72,-0.94l1.63,-1.08l-12.07,0.56l-2.84,-1.78l-0.09,-1.04l1.03,-2.19l-0.54,-2.11l0.17,-0.82l1.23,-1.77l2.19,-1.92l1.35,-0.27l2.61,0.66l7.43,0.68l1.44,-0.24l-2.21,-1.46l-6.92,-1.55l-0.31,-1.63l0.47,-2.61l1.78,-2.77l5.22,-2.3l2.08,-0.32l2.08,0.15l2.11,1.03l0.94,0.89l0.7,2.12l0.51,3.61l1.22,2.7l0.89,0.84l5.85,-1.92l1.73,0.49l2.52,1.62l3.26,4.85l4.2,4.91l-0.02,1.05l-1.61,1.63l-0.3,0.7l0.22,0.48l4.55,0.44l2.45,7.62l1.01,1.52l0.99,0.78l1.46,0.06l1.47,-0.45L277.9,577.04zM277.9,551.11l-2.19,-2.35l-0.6,-2.39l0.4,-1.81l2.39,-2.4l0,0L277.9,551.11zM203.26,575.58l-2.56,2.31l-1.82,-0.24l-2.42,-1.7l-1.97,-0.58l-0.69,-0.56l-0.1,-0.59l1.5,-2.94l5.39,-7.59l4.39,-3.26l3.44,-4.39l1.06,-0.1l1.09,0.58l0.12,0.83l-1.14,4.13l-5.38,12.95L203.26,575.58zM178.63,569.59l-0.7,0.17l-0.78,-0.41l0.18,-0.93l1.75,-2.56l-0.14,-2.04l0.44,-0.9l0.71,-0.37l0.32,1.14l-0.38,3.38L178.63,569.59zM190.64,625.91l2.38,-2.91l2.38,0.11l0.5,0.99l0.28,4.98l3.35,-5.78l1.79,-1.73l3.09,-0.73l2.1,0.02l4.04,1.13l2.83,1.99l2.23,2.29l8.9,11.44l2.9,2.63l1.11,1.49l0.92,2.44l-0.04,2.43l-1.01,1.51l-4.19,2.93l-4.4,2.18l-5.23,4.52l-3.58,2.14l-4.65,4.15l-8.77,6.6l-1.52,2.26l-2.48,7.4l-0.94,1.7l-2.28,1.73l-2.89,0.43l-0.81,0.48l-0.13,2.51l-1.54,6.92l-0.69,7.36l-1.58,3.54l-2.79,1.68l-4.86,1.61l-1.34,-1.65l-1.14,0.08l-3.65,5.01l-3.52,2.01l-2.6,2.66l-2.29,0.1l-1.03,-0.82l-1.64,-2.65l-2.59,-7.69l-2.92,-5.23l-6.74,-4.51l-4.81,-3.98l-4.22,0.35l-0.7,-0.52l0.7,-2.19l0.05,-2.43l1.6,-1.33l-0.45,-0.8l0.06,-1.31l1.03,-1.56l1.16,-3.43l3.55,-4.89l-0.39,-1.7l0.54,-6l0.35,-0.6l3.12,-1.91l0.16,-0.56l-0.21,-1.87l-1.33,-0.53l-0.72,-1.11l0.12,-2.06l1.88,-3.64l1.52,-5.48l2.78,-3.42l0.75,-3.71l2.09,-3.96l-0.68,-1.91l-1.93,-0.94l-0.93,-1.46l-3.44,-11.3l-1.2,-2.61l0.12,-0.7l11.01,-2.93l7.58,-0.94l7.85,-2.57l2.19,-0.15l1.69,0.51l6.82,5.92l5.48,3.29l3.42,0.69l-1.37,2.6L190.64,625.91zM277.9,661.69l0.02,84.3h-22.41l0,2.34l-1.35,2.01l-2.02,0.03l-0.06,-4.38l-37.42,-0.02l-0.18,2.96l3.42,5.02l0.39,1.18l-1.84,0l0,0l-2.22,-4l-0.82,-6.52l0.54,-1.21l5.21,-1.97l9.19,-2.17l8.4,-1.47l3.81,0.13l2.25,0.69l6.33,0.47l5.14,1.02l3.33,-0.78l0.68,-0.56l3.64,0.07l1.35,-0.95l-0.84,-1.15l-3.48,-2.53l-9.25,-4.56l-5.48,-2.01l-1.87,-0.15l-3.27,0.57l-4.57,1.46l-10.31,0.95l-3.02,-1.01l-5.96,0.54l-5.33,-0.7l-6.07,-7.03l-1.01,-2.18l0.96,-1.84l4.08,-3.42l4.48,-1.49l8,-3.51l4.75,-1.23l-1.38,-1.16l0.01,-0.88l0.57,-0.42l2.21,-0.45l2.35,0.54l1.17,-0.19l0.34,-0.6l-0.31,-0.48l-2.23,-1l-10.7,2.89l-4.99,0.27l-3.46,1.23l-1.9,-0.04l-2.26,-1.23l-0.34,-0.88l0.7,-1.65l2.42,-0.99l1.22,-2.8l-5.64,0.55l-1.9,-0.26l-2.56,-1.08l-1.07,-2.21l0.39,-6.37l3.18,-5.3l1.98,-1.11l1.39,-1.68l-0.29,-1.42l-2.11,-3.45l0.96,-3.16l7.38,-8.95l2.65,-2.53l2.55,-1.37l3.57,-2.93l9.15,-4.9l8.19,-4.96l3.01,1.31l0.86,1.03l0.71,2.09l0.68,4.94l-0.02,3.46l-0.5,2.96l-3.7,8.09l0.57,0.38l1.04,-0.31l3.45,-1.82l2.38,-0.64l0.63,0.78l0.4,-0.16l0.7,-1.27l0.08,-3.86l1.78,-3.89l0.76,-0.95l1.21,-0.44l2.87,0.28l6.32,2.99l5.31,3.71l1.66,1.58l0.17,1.36l-0.94,2.89l-2.29,4.07l-2.55,2.35l1.2,0.62l0.78,1.04l3.26,-4.58l0.42,-0.12l0.1,0.3l-0.13,2.53l0.75,0.21l0.4,-0.26l1.62,-1.97l1.59,-3.03l2.41,-1.97l0.66,-1.01l2.1,-0.84l0.07,-2.94l-3.2,-3.11l-1.22,-2.53l0.26,-1.95L277.9,661.69zM182.16,757.25l0.04,38.73l36.64,29.12l36.64,27.67l16.44,0.11l10.34,12.68l2.7,1.89l2.17,0.71l62.52,11.46l-0.02,81.06l0,0h-71.7l0,0h-89.65l0,0h-34.24l0,0l-0.54,-0.69l-1.18,-0.11l0.12,-1.44l-1.68,-3.5l-0.37,-2.39l-0.21,-0.38l-1.38,-0.38l-1.76,-3.06l-0.11,-0.71l0.95,-1.6l-0.7,-3.02l-2.01,-0.15l-0.66,1.85l-2.43,0.29l-1.53,0.95l-3.45,-0.88l-1.72,-0.92l-0.93,1.5l-1.42,-1.05l-0.55,0.18l-0.11,0.86l-0.56,0.45l-2,-0.29l-1.3,0.7l-1.74,-0.13l-0.76,-5.21l-0.99,0.02l-0.34,-0.36l0.59,-1.04l0.05,-2.05l-0.46,-2.48l-0.84,-1.78l-1.19,-0.89l-2.77,-0.39l-1.78,-1.61l-1.67,-1.74l-0.48,-1.93l-1.43,-0.98l-1.74,-3.21l-1.44,-1.59l-1.06,0.09l-1.21,0.93l-0.84,-1.06l-2.05,-0.12l-1.06,-0.52l0.2,-1.29l-0.54,-1.43l0.48,-1.52l-0.51,-1.01l0.96,-1.26l-2.7,-2.1l-0.31,-1.46l-0.85,-0.76l-0.88,-2.34l0.04,-1.94l0.92,-2.53l-1.93,-0.65l-0.7,-1.9l-2.04,-1.77l0.29,-0.84l1.76,-1.74l0.54,-1.6l-0.38,-1.39l-0.79,-1.22l-0.78,-0.4l-0.43,-1.2l-1.19,0.34l-0.53,-0.51l0.39,-0.68l1.24,-0.72l0.03,-0.41l-1.48,-0.59l-4.26,-3.47l-1.54,-2.71l0.15,-1.38l-1.73,-4.3l-2.26,-1.19l-2.04,1.62l-1.89,-0.16l0.61,-3.03l-1.47,-0.9l-1.91,-2.61l-1.92,-1.27l-2.4,-0.66l-0.12,-0.67l0.86,-1.22l0.07,-1.56l1.29,-2.11l-1.47,-0.79l-0.22,-1.62l-0.35,-0.31l-1.15,0.37l-0.58,-0.77l0.1,-0.46l1.48,-1.18l0.5,-1.3l1.76,-2.21l1.35,-3.33l-0.9,-2.57l-2.33,-3.08l0.14,-0.64l1.78,-1.52l-0.02,-0.52l-0.25,-0.32l-1.01,0.1l-1.17,-0.89l-1.86,2.23l-0.73,0.32l-0.59,-0.44l0.46,-1.49l-0.19,-0.59l-2.61,0.5l-1.64,1.1l-1.88,-0.41l-0.5,-2.67l0.97,-1.79l-0.13,-2.41l-1.86,-0.43l-0.09,-0.47l0.54,-2.55l0.77,-0.29l0.17,-2.53l-1.15,-1.92l-0.38,-1.87l0.1,-1.94l-2.13,-2.86l-0.22,-1.38l-18.95,-0.25l-0.48,-1.68l0.05,-2.14l1.01,-2.85l-0.65,-2.76l0.07,-2.14l-0.57,-2.02l-1.5,-1.54l-0.4,-1.91l0.02,-27.85l0,0l2.88,0.32l2.29,1.23l4.52,3.37l0.93,0.3l0.25,-0.25l-1.82,-3.65l-1.82,-1.25l-2.3,-0.86l-0.27,-1.64l3,-0.39l0.13,-0.47l-1.5,-0.56l-1.5,-1.56l1.96,-5.04l0.69,0.51l1.03,-1.17l1.85,0.74l0.34,-0.41l0.23,-2.58l0.8,-1.09l2.58,-0.46l3.22,0.46l0.33,-0.25l-0.35,-2.42l0.39,-2.41l0.38,-0.42l1.5,0.33l1.48,2.85l1.59,0.76l0.18,0.53l-2.64,6.48l4.31,-2.93l4.76,-1.67l1.21,-1.9l1.01,-3.11l0.67,-0.54l2.81,0.19l1.1,-0.4L76.41,754l-0.8,-0.14l0.72,-1.03l1.39,-0.36l0.91,1.13l0.62,0.08l2.06,-1.25l4.42,-4.27L86.8,748l0.92,0.61l0.71,-0.16l1.88,-3.79l2.34,-1.98l1.5,-0.43l2.9,1.51l2.06,-0.13l1.93,-2.67l0.49,-0.02l1.23,2.32l0,0.82l-0.99,2l-7.27,5.67l-3.35,3.32l-9.91,3l-1.71,3.38l-1.81,2.4l-1.35,0.88l-1.84,0.34l-1.17,1.37l-5.39,9.04l0.63,1.84l1.36,0.74l0.53,-0.17l-1.63,-1.81l0.14,-0.69l5.36,0.81l1.55,-1.51l-0.09,-0.36l-1.45,-0.15l-0.31,-0.66l-0.28,-2.24l0.46,-1.68l1.56,-1.54l1.68,-0.66l3.93,-3.12l1.19,-2.05l-0.3,-0.77l0.28,-0.77l2.02,-0.75l1.97,0.66l0.36,0.52l-0.19,1.37l1.46,-2.39l0.88,0.11l0.45,0.56l0.24,1.68l0.14,3.9l0.86,-2.81l3.22,-6.37l1.46,-2.22l2.12,-1.66l4.89,-2.76l4.15,-1.44l1.88,-2.2l-0.36,2.38l-1.79,1.1l-0.18,0.84l0.5,2.15l0.42,0.41l1.8,-1.29l4.18,-5.44l0.97,-3.88l1.64,-1.4l2.97,-1.6l0.73,-1.02l-2.6,-0.86l-0.62,-0.95l0.49,-0.92l-1.62,-1.48l0.38,-2.82l1.22,-1.35l2.14,1.53l4.72,5.9l2.68,6.19l1.51,5.45l1.31,3.19l4.92,6.76l3.01,2.22l1.82,0.72l1.24,0.06l1.93,-2l0.04,-1.32l-1.7,-3.75l0.1,-0.94l1.13,-1.81l0.16,-2.5l1.09,0.29l2.79,-4.49l-1.99,-0.96l2.2,-1.41l0.35,-0.97l1.36,-0.9l0.99,1.07l-0.25,5.03l0.58,3.93l0.52,0.85l2.01,1.15l-0.12,0.95l-3.07,5.84l0.5,1.17l0.79,0.37l2.03,0.15l0.56,-0.35l4.67,-0.42l1.5,-2.74l1.33,-1.15l1.23,-6.21l1.08,-0.94l1.54,0.27l6.41,-0.2l4.83,1.05l5.1,2.98L182.16,757.25z"
				},
				{
					"id":"CA-NU",
					"title":"Nunavut",
					
"d":"M641.08,201.13l7.31,1.33l2.37,-0.48l2.71,3.24l1.63,0.38l2.69,-0.61l1.96,0.77l7.3,0.72l1.52,1.25l-0.02,1.51l-1.57,3.25l-2.12,3.11l-13.64,10.02l-1,1.65l2.66,0.52l3.92,-0.45l3.04,-1.1l3.58,-3.38l1.18,-0.19l2.28,-1.65l4.41,-4.64l3.52,-2.53l1.59,1.11l1.34,1.76l0.91,0.2l1.67,-6.43l1.16,-0.97l0.71,0.11l1.15,1.77l2.45,7.04l0.63,0.05l2.68,-3.25l1.35,-0.42l3.07,1.18l1.28,1.43l0.23,1.52l-1.52,4.13l0.45,1.34l1.86,2.85l2.69,6.15l-0.02,2.24l-1.47,4.53l0.04,1.14l6.92,-4.75l6.97,2.13l1.97,1.45l0.76,1.74l1.66,6.83l-0.59,4.1l-3.06,6.33L708.5,264l-1.87,4.34l-2.87,2.37L693.94,281l-4.8,3.27l-2.76,3.2l-1.24,0.55l-5.85,-0.61l-1.55,1.75l-0.86,2.93l-1.84,1.39l-2.72,0.99l-5.57,0.8l-2.58,8.01l-15.91,11.48l-0.29,1.9l1.6,0.78l2.02,-0.78l23.15,-13.93l4.44,-0.93l4.12,1.02l-0.47,3.28l-5.84,9.18l-7.43,8.14l-3.71,6.09l-9.39,10.34l-7.67,10.1l-2.95,5.06l-3.95,8.91l-1.35,2.13l-1.64,0.88l-1.93,-0.37l-1.74,-1.28l-5.1,-7.68l4.48,14.09l-0.47,2.34l-7.49,2.45l-3.31,2.16l-1.71,0.52l-1.21,-0.39l-1.18,0.22l-1.15,0.83l-0.06,0.92l1.02,1.01l2.98,0.79l6.63,-2.67l1.06,0.19l1.7,1.3l0.08,1.18l-1.78,3.77l-5.36,4.47l0.7,0.25l1.54,1.57l-0.03,1.41l-2.49,4.36l-5.17,3.05l-2.25,0.71l-1.98,-0.38l-9.07,-6.69l-3.2,-0.97l-3.04,-1.71l-2.24,0.29l-2.38,1.98l1.07,0.99l4.39,1.89l3.67,0.37l1.52,0.73l2.18,5.64l0.25,2.36l-0.83,3.71l-0.61,0.87l-0.94,0.43l-3.58,-0.31l-1.34,0.53l-1.55,1.27l-1.95,0.55l-3.51,-0.25l-4.14,1.84l-2.19,0.34l-2.42,-0.83l-2.63,-2.06l-2.77,-1.04l-4.69,-0.88l0.39,1.18l1.65,0.5l3.36,3.16l1.61,4.25l1.51,0.71l3.09,3.46l2.23,0.54l2.33,1.17l3.28,-1.51l2.21,0.28l-0.46,8.41l-0.97,0.81h-5.31l-2.52,-1.21l-1.11,-1.25l-2.45,-1.42l-2.2,0.83l-2,-0.18l-1.35,0.84l-2.15,-0.03l-5.62,1.41l-2.97,0.02l-2.19,-0.91l-2.55,-0.28l-2.9,0.34l0.2,0.97l1.23,0.29l1.79,1.57l1.66,2.4l1.38,1.01l3.34,-1.69l6.15,-1.85l2.7,-0.3l2.4,0.82l2.72,2.24l1.41,3.23l3.54,0.39l2.7,1.07l4.3,4.64l1.18,0.35l0.48,1.19l-0.91,2.96l-0.1,1.77l-2.98,3.42l-4.64,0.99l-5.1,-0.32l-3.65,0.39l-0.38,0.43l2.51,0.89l5.81,3.95l2.25,2.13l0.39,1.24l-3.2,4.7l-2.83,9.2l-0.93,0.72l-3.46,0.09l-3.16,2.28l-2.38,0.46l-4.32,-0.86l-4.99,0.05l-0.64,4.27l0.33,9.73l-0.26,4.01l-1.86,4.38l-1.88,1.79l-3.37,1.51l-2.4,0.06l-6.89,1.28l-3.37,-0.08l-2.61,-0.54l-2.7,-1.79l-4.5,-5.08l-2.53,-1.79l0.05,1.1l1.35,2.85l2.02,2.65l-0.21,0.87l-1.99,1.36l-2.19,0.61l-2.59,-0.02l-0.08,0.52l2.02,2.82l0.75,0.41l1.99,-0.42l2.3,-1.73l1.44,-0.51l2.86,0.41l1.13,0.62l4.07,3.95l2.64,-1.9l3.82,-0.1l1.4,1.52l0.6,5.32l-0.4,1.81l0.88,1.76l2.17,1.71l1.68,0.37l3.01,-3.31l0.77,-0.56l0.73,0.13l2.6,4.99l0.14,3.81l-1.21,4.32l-1.48,2.82l-5.83,4.61l-3.15,3.67l-2.02,1.68l-3.97,2.24l-2.09,0.42l-4.51,2.4l-0.98,0.11l-1.46,-0.39l-0.3,-1.17l1.45,-5.83l0.02,-1.5l-1.27,-2.35l-1.76,-1.64l-1.74,0.32l-0.98,0.65l-1.05,0.12l-1.12,-0.4l-0.95,-0.99l-1.89,-4.19l-0.71,-0.54l-0.93,0.13l-0.83,-0.6l-1.96,-2.64l2.4,5.77l0.48,2.35l-0.22,1.84l-10.36,1.02l-4.45,-0.53l-0.9,-1.61l-2.13,-6.96l-0.46,12.25l-7.76,1.97l-1.81,-0.33l-3.02,-1.35l-3.9,-3.27l-1.62,-2.18l-1.41,-3.58l-0.97,2.63l-1.06,5.35l-6.04,-2.72l-1.22,-5.29l-0.07,7.65l-5.44,-1.01l-2.61,0.29l-0.77,-6.71l-0.13,-7.5l-1.06,4.75l0.61,8.85l-2.31,-1.37l-5.07,-0.67l-1.8,-0.67l0.63,-13.01l6.53,-6.59l1.92,-3.15l1.42,-1.27l2.24,-0.81l2.86,-0.5l1.95,0.39l2.23,-0.38l2.67,-1.2l1.9,-0.34l0.36,-0.42l-3.32,-5.98l-2.22,-0.64l-1.43,-1.93l-3.13,-8.49l-1.41,-5.01l0.7,-2.77l2.33,-2.19l2.33,-1.52l2.34,-0.85l1.96,-0.02l5.67,3.56l1.9,2.64l3.96,9.93l1.28,1.96l5.72,3.55l1.9,0.57l6.86,-1.21l2.26,-0.97l1.01,-1.16l1.17,-2.95l2.04,-2.96l3.12,-6.2l1.72,-4.95l1.03,-6.11l-0.97,1.28l-6.5,14.46l-3.15,3.69l-1.33,0.59l-2.15,-0.18l-2.85,-1.63l-3.36,2.59l-2.04,-0.66l-1.81,-1.81l-0.02,-8.59l-2.29,-6.97l2.53,-3.56l2.1,-2.22l3.73,-5.82l0.82,-0.06l2.7,0.92l-2.93,-3.31l-3.23,0.51l1.14,-12.81l-2.16,9.61l-3.54,7.47l-1.5,1.43l-5.66,1.23l1.39,-4.61l1.28,-6.87l-1.35,2.58l-3.19,3.85l-2.39,2.01l-1.97,1.06l-3.82,-0.25l-1.9,-1.92l0.54,-4.74l0,-5.89l4.83,-11.13l1.3,-5.06l5.07,-2.27l4.94,-0.93l4.14,-2.71l2.03,-0.48l1.94,1.29l7.88,2.11l5.71,3.18l2.52,-3.41l4.91,0.17l2.61,-1.1l3.32,-4.02l0.28,-1.19l-1.25,0.04l-1.25,0.61l-1.87,1.77l-1.81,0.95l-1.84,-0.18l-3.71,-1.49l-6.46,-0.27l-3.29,-0.68l-1.53,-0.72l-0.86,-1l-1.4,-3.52l0.34,-1.42l1.31,-0.82l1.14,-0.17l3.87,3l2.23,0.24l-0.77,-1.72l-4.8,-6.43l-8,-18.89l-1.6,-2.59l-1.69,-1.29l-5.15,-1.61l-1.03,-1.05l-2.46,-5.18l-0.66,-8.87l-1.08,-5.48l1.04,-7.09l1.71,-3.25l10.29,2.53l4.34,-0.38l5.55,0.9l2.98,1.75l3.41,4.31l3.04,4.82l2.93,3.2l2.69,4.34l2.94,6.38l3.23,4.88l2.02,1.58l3.81,1.99l3.32,0.65l1.72,-0.26l1.84,-1.44l1.31,-1.71l-1.46,-0.47l-3.82,0.2l-2.66,-0.91l-3.12,-4.76l-4.5,-8.63l-4.23,-5.64l-3.13,-5.67l-2.51,-5.44l-0.23,-2.38l1.81,-1.66l2.23,-1.17l13.95,-3.75l8.32,-4.52l3.38,-5.29l0.4,-1.24l11.14,-7.59l7.88,-2.83l3.03,-0.46l2.75,-1.23l0.11,-0.76l-2.4,-1.04l-2.43,-0.51l-5.51,0.03l-4.9,-0.94l-1.48,-1.72l0.78,-5.26l1.48,-4.1l1.59,-3.1l6.73,-9.04l4.53,-3.85l1.31,-2.68l-9.75,5.95l-3.4,4.26l-3.42,6.33l-1.77,1.85l-1.26,-0.49l-1.13,0.59l-0.99,1.65l-0.83,3.01l-1.28,7.29l-1.94,3.81l-3.34,4.37l-7.83,6.06l-2.63,1.53l-2.26,0.24l-7.31,3.37l-2.2,0.13l-2.43,-1.02l1.04,-2.92l3.87,-5.42l1.03,-2.43l-2.47,0.53l-2.52,1.49l-5.57,1.23l-2.2,2.21l-2.14,3.99l-1.71,2.49l-1.29,1.01l-1.78,0.6l-6.53,0.31l-1.45,-0.26l-3.75,-3.01l-3.33,1.04l-1.37,-0.2l-2.52,-2.14l-0.75,-1.39l0.11,-1.87l1.46,-3.55l1.69,-3.43l5.49,-7.62l3.52,-3.61l5.08,-3.13l11.93,-3.52l0.54,-2.59l-12.07,2.9l-10.27,3.64l-1.67,1.33l-2.39,3.53l-9.83,15.73l-3.42,0.75l-2.62,-1.06l-9.49,-8.6l-1.81,-4.79l0.86,-1.54l6.76,-3.34l9.18,0.65l4.12,-0.69l4.05,-2.03l5.98,-5.08l6.51,-7.21l1.27,-2.32l-2.38,-0.51l-1.76,0.57l-4.24,2.6l-6.7,6.93l-5.85,2.43l-14.45,1.29l-4.59,1.91l-2.01,-0.41l-1.52,-1.86l-1.69,-3.47l0.3,-2.79l3.44,-3.15l2.7,-0.74l0.48,-0.65l-3.83,-3.07l-0.34,-1.58l2.21,-3.51l4.79,-5.21l2.42,-1.65l4.44,-1.06l4.57,0.57l0.18,-1l-4.52,-2l-3.38,-0.37l-4.48,1.41l-11.88,8.48l-1.01,-0.25l-1.73,-1.45l0.5,-2.09l6.35,-8.98l0.21,-1.43l-4.56,0.2l-1.34,-0.43l-1.31,-1.08l-1.86,0.96l-2.41,2.98l-1.7,1.27l-0.99,-0.43l-2.52,-3.53l0.33,-2.98l3.84,-6.48l2.49,-2.5l4.05,-3.15l2.93,-1.07l4.75,-0.03l2.26,-1.41l4.53,-6.5l2.76,-2.79l4.51,-2.3l3.8,0.74l2.1,2l1.67,3.5l1.79,2.66l0.17,-2.15l1.48,-2.66l1.86,-1.14l2.24,0.38l1.96,1.27l2.54,3.21l2.05,1.43l0.97,-0.09l1.21,-1.77l3.21,-0.04l-1.12,-2.61l-1.27,-1.33l-11.38,-9.36l-0.31,-2.07l3.84,-1.95l2.4,-2.34l1.13,-0.57l4.65,-7.65l3.4,-3.01l1.36,0.82l1.72,2.65l1.66,1.65l4.88,1.57l2.09,1.63l5.2,12.26l2.12,3.06l1.26,1.15l2.49,0.73l0.26,-1.72l-2.96,-4.31l-0.81,-2.51l0.35,-2.14l0.63,-1.13l0.91,-0.1l2.33,1.91l6.2,6.44l9.27,7.53l3.55,1.74l6.17,8.06l0.37,-0.21l-1.83,-4.95l-4.49,-6.17l-12,-10.71l-4.75,-5.7l-2.3,-3.89l-1.74,-3.96l-0.03,-2.18l1.63,-2.56l2.2,-2.04l2.74,-0.81l0.33,-0.85l-2.49,-3.08l-1.47,-2.68l0.05,-1.87l2.97,-1.44l1.84,0.43l3.5,3.39l2.92,1.59l0.47,-1.03l-3.02,-9.05l-0.28,-2.06l0.45,-1.21l1.06,-1.23l3.17,0.71l5.21,4.46l9.33,2.22l2.57,-0.33l-0.39,-1.02l-3.72,-2.75l-3.9,-3.71l-1.72,-2.25l-2.76,-5.6l-0.12,-1.23l2.41,-1.99l6.33,0.39l5.88,3.06l4.99,-1.11l3.14,0.76l1.24,0.92l2.27,3.31l7.21,11.82l2.46,8.44l1.23,1.02l2.38,-2.58l1.6,-2.51l-0.69,-2.44l-3.98,-5.64l-2.89,-6.57l-4.47,-7.48l-1.94,-6.52l12.37,-2.85l11.93,2.52l1.94,1.78l4.43,9.97l3.86,5.75l5.5,3.55l-1.05,-2.41l-4.11,-6.33l-1.86,-4.38l0.34,-5.27l0.65,-1.59l4.66,-6.1l6.66,-1.85l0.77,0.34l5.18,9.36l2.46,3.78l1.72,1.51l0.07,-0.66l-2.38,-4.25l-1.83,-2.33l-0.19,-1.46l3.04,-4.56l1.92,-1.15l8.07,-1.34l0.92,0.49l0.77,1.27l1.91,5.02L641.08,201.13zM440.31,324.19l1.17,4.84l4.33,11.35l1.96,4.06l3.33,5.01l0.41,1.79l-0.06,3.39l0.95,0.97l2.87,1.51l3.19,2.71l0.57,-0.15l1.11,-1.6l1.34,-0.44l1.75,0.39l0.84,1.15l0.91,3.81l-0.63,1.8l0.51,2.5l-0.63,3.79l0.17,1.38l1.61,3.42l1.45,1.7l2.87,1.84l1.87,-0.13l1.16,1.16l-0.5,-2.88l-1.12,-3.09l-2.08,-1.6l-0.46,-4.94l0.18,-2.07l1.06,-1.68l0.9,-0.54l2.68,-0.08l1.48,0.75l2.55,2.34l0.44,9.82l-2.18,2.8l-0.48,1.89l5.32,2.66l1.13,0.17l2.02,7.67l-1.5,11.7l-1.35,4.1l0.47,0.45l2.85,-0.98l2.48,-2.75l2.8,0.56l0.94,0.63l0.46,0.85l1.55,6.22l0.52,-0.32l1.3,-4.29l1.12,-2.1l5.51,14.08l0.19,2.11l-2.22,3.66l-7.19,5.16l-3.22,2.9l-2.42,2.97l-1.73,-0.34l-0.39,0.37l-1.1,5.07l-4.81,8.73l-2.19,-1.4l-0.55,-2.04l-0.34,-6.55l1.18,-7.13l-1.89,2.35l-1.11,2.9l-0.02,8.7l-0.21,2.25l-0.58,1.11l0.23,0.86l2.02,1.71l0.18,3.55l-0.51,1.92l-0.96,0.78l-1.23,-0.87l-2.65,-4.76l-1.15,0.26l-0.29,0.55l1.06,5.49l0.15,3.13l-1.13,6.65l-0.8,2.45l-1.32,0.06l-1.13,-1.09l-8.44,-17.73l-0.35,2.61l4.17,12.06l0.94,3.32l0.15,1.37l-0.32,0.54l-3.11,-3.42l-1.37,-2.36l-0.99,-0.96l-1.44,-0.66l-1.45,-0.13l-1.46,0.41l-0.28,0.62l2.21,2.69l0.71,2.72l-0.54,0.94l-2.04,0.59l-2.72,-0.37l-4.41,-1.29l-4.39,-2.14l-4.05,-3.35l-2.93,-3.38l-1.16,-1.81l-0.36,-1.36l1.1,-1.19l3.84,-1.53l3.85,-0.99l-0.61,-0.86l-7,-1.96l-2.3,-0.36l-1.23,0.52l-1.41,-0.3l-1.1,-1.56l-2.2,-4.95l0.1,-0.77l0.55,-0.44l3.17,0.38l0.44,-0.3l-1.58,-1.49l-5.07,-2.97l-1.9,-2.64l-0.35,-1.03l-0.08,-2.02l1.91,-2.03l5.88,-4.83l2.02,-0.76l2.03,-0.05l1.42,-1.4l1.22,-4.64l6.09,-1.68l4.7,-2.11l0.39,-0.57l-3.52,0.39l-4.98,-0.42l-2.12,-3.21l-1.44,-0.55l-1.59,0.03l-1.85,1.01l-3.16,2.98l-1.52,0.69l-3.43,3.06l-0.96,-0.22l-0.62,-0.96l0.62,-2.03l0.9,-1.39l-0.18,-0.48l-1.35,-0.29l-1.56,0.06l-1.08,0.48l-3.95,2.69l-2.31,2.18l-1.91,-3.14l-3.05,-1.73l-0.68,-1.36l0.63,-5.35l0.89,-1.11l2.34,-0.91l7.02,-4.93l1.06,-3.47l-1.6,0.54l-3.52,2.43l-2.9,1.21l-2.29,-0.01l-1.68,-0.35l-1.06,-0.68l-1.27,-1.55l-4.15,-7.21l-1.13,-3.53l-0.45,-5.53l-1.2,-5.81l8.89,3.62l3.48,0.68l6.71,0.24l0.31,-0.35l0.25,-4.48l2.87,-2.81l-2.94,-0.35l-5.4,3.52l-1.91,-0.03l-2.16,-5.04l-2.31,0.89l-1.09,-0.4l-2.53,-2.39l-0.77,-2.55l0.54,-2.01l1.99,-1.48l0.9,-0.14l2.37,0.95l1.78,-0.07l-5.4,-10.11l0.17,-7.59l1.85,-1.62l1.91,-0.27l1.87,1.94l2.51,0.27l1.79,2.17l1.19,4.15l1.42,-0.08l2.23,0.78l5,-0.06l-0.9,-1.48l-1.55,-1.29l-3.53,-1.7l-1.72,-6.13l-3.65,-3.19l-2.86,-1.68l0.05,-1.42l2.15,-7.82l2.59,-2.81l4.13,1.06l2.72,-1.5l3.5,-2.81l3.43,1.3l0.88,-0.12l0.52,-0.86l0.46,-3.19l-1.53,-3.15l-4.37,-0.24l-1.94,-0.69l-0.75,-0.94l-0.35,-4.39l0.48,-1.43l1.07,-0.6l4.08,-0.08l2.44,-0.82l2.67,1.08l5.58,4.04l1.8,2.05l1.92,3.41L440.31,324.19zM378.4,387.18l0.02,9.99l-0.46,2.44l-0.94,0.65l-2.45,-1.9l-0.75,-1.12l-0.28,-2.81l-1.64,-2.42l-3.06,0.39l-1.28,-0.23l-0.51,-0.72l-0.62,-5.29l0.65,-4.78l2.25,-2.44l0.64,-0.21l2.75,0.92l2.44,0.12l1.22,0.68l1.09,1.53L378.4,387.18zM336.85,420.39l2.1,0.98l2.49,3.09l2.35,6.49l0.04,3.2l-0.74,2.72l1.21,1.23l0.17,2.96l1.36,-2.51l0.28,-3.61l3.76,-3.25l0.91,-0.44l1.51,0.45l3.63,4.56l1.38,0.43l0.96,1.58l-0.99,5.35l0.17,1.03l1.89,0.86l4.32,-1.73l3.77,4.22l2.09,4.97l1.55,1.66l0.24,0.89l-0.88,3.14l-1.5,2.48l0.66,2.02l0.2,3.99l1.69,1.04l3.86,7.09l0.7,1.96l0.48,3.26l-1.49,6l-4.42,1.4l-2.66,1.28l-2.86,-1.65l-2.79,-2.52l-0.84,-1.66l-0.88,-2.81l-0.43,-3.97l-1.18,-1.85l-1.04,-2.78l-2.01,-0.24l-4.76,-2.84l-2.04,-0.68l-2.04,0.2l-2.89,1.15l-1.04,-1.16l-0.44,-1.4l0.37,-2.84l-8.48,2.28l-2.41,2.63l-3.39,-0.42l-1.69,-1.11l-2.25,-2.52l-1.99,-5.19l-0.09,-2.27l0.77,-1.54l0.8,-0.92l0.83,-0.29l4.6,1.79l4.03,0.91l1.74,-0.91l0.79,-2.45l-0.94,-1.32l-3.88,-0.54l0.83,-1.3l3.28,-1.34l1.71,-2l-1.32,-1.51l-4.4,0.24l-1.58,-0.79l0.27,-1.51l2.5,-4.12l-0.1,-0.75l-2.37,-3.33l-2.18,1.58l-3.06,6.06l-0.73,0.87l-0.7,-0.05l-0.67,-0.97l0.01,-1.27l2.1,-6.28l-0.1,-1.69l-1.39,-1.13l-3.65,0.85l-2.03,0.03l-0.31,-1.34l0,-4.9l1.21,-6.62l0.43,-1.03l4.84,0.61l7.91,-1.8l2.31,-0.19L336.85,420.39zM401.59,456.99l2.12,1.18l3.65,-0.52l4.75,3.87l1.04,1.77l0.25,2.01l-3.41,3.65l-0.55,1.65l2.03,2.06l1.03,1.83l0.48,2.64l-1.37,3.59l-1,1.05l-1.54,-0.11l-0.73,0.32l-1.96,1.67l-3.05,1.58l-4.17,0.65l-3.2,2.56l-1.4,0.25l-0.67,-2.26l0.4,-2.09l-0.67,-1.09l-2.99,-2.1l-1.74,-2.93l-0.33,-1.75l3.87,-0.55l1.66,-0.6l0.86,-1.52l-3.39,-2.25l-4.45,-1.2l-0.21,-1.4l-1.85,-2.81l-0.18,-2.68l-1.66,-1.92l-0.56,-2.13l0.02,-1.83l2.29,-1.84l-2.06,-6.09l-0.38,-3.72l1.08,-1.43l5.52,0.4l1.91,0.6l4,2.88l3.13,1.52l1,1l1.88,3.17l0.08,2L401.59,456.99zM277.89,466.35l-0.01,-16.42l0,0l1.69,1.66l1.57,2.65l1.23,0.44l0.33,0.69l0.94,3.35l0.24,3.78l-0.49,3.19l-0.84,0.9l-2.01,0.56L277.89,466.35zM340.64,474.06l-1.03,0.88l-1.2,-0.51l-0.07,-1.98l1.34,-2.74l1.96,-1.12l0.93,2.33L340.64,474.06zM277.89,483.46v-6.93l0,0l3.11,0.45l0.34,0.97l-1.37,4.29L277.89,483.46zM352.38,493.33l-1.23,0.39l-2.23,-0.2l-2.67,-1.51l-0.72,-1.78l0.09,-4.69l4.75,-0.81l2.5,0.32l4,2.66l1.32,2.2l0.4,1.8l-3.55,0.25l-1.68,0.45L352.38,493.33zM408.04,489.3l2.25,1.62l2.45,-0.86l2.63,-0.09l5.85,0.69l3.87,-0.46l2.53,1.31l1.54,3.35l-1.89,1.28l-1.83,6.78l-1.76,0.09l-0.86,0.51l-5.13,-0.91l-14.15,-0.41l-2.48,-4.59l-0.11,-1.5l0.74,-2.94l4.58,-3.45L408.04,489.3zM326.7,516.16l-1.37,0.71l-4.52,-2.34l-3.06,-6.94l-1.71,-7.12l-0.9,-1.58l-0.31,-2.63l-1.64,-4.15l0.27,-0.61l1.55,-0.61l2.47,0.78l2.67,3.95l2.53,5.64l0.46,3.63l1.66,0.23l2.04,3.09l0.79,3.61l-0.35,3.51L326.7,516.16zM458.7,511.06l-2.34,2.32l-1.2,-0.08l-6.86,-4.76l-1.38,-2.37l-0.34,-3.88l0.32,-5.26l1.17,-1.5l1.58,-0.47l3.76,1.11l2.25,1.41l2.99,4.29l1.07,2.03l0.23,2.63l-0.16,2.77L458.7,511.06zM418.71,525.31l1.68,0.34l1.43,-0.53l1.23,0.12l1.82,1.59l1.68,2.43l1.71,1.65l0.26,3.95l-2.99,8.54l4.83,-6.65l2.5,0.67l3.76,-0.5l4.55,-2.32l2.16,-0.36l2.18,0.17l1.62,0.73l3.46,3.12l1.2,1.48l0.56,1.81l-0.71,1.19l-6.96,-1.73l-0.41,0.43l0.25,1.64l0.73,0.36l4.29,0.35l14.08,5.16l0.59,1.64l-0.16,0.72l-1.52,1.87l-8.12,1.17l-4.62,-1.03l-3.88,-1.67l-1.32,0.37l1.15,2.26l2.33,0.69l1.95,1.33l0.81,1.11l4.13,0.85l1.96,3.06l1.08,0.17l1.07,1.53l0.88,2.62l0.41,0.35l1.24,-0.47l2.09,2.26l0.65,1.21l-0.46,2.31l-0.94,1.91l-2.37,2.24l-0.18,0.67l2.77,-0.26l0.51,0.3l3.26,3.95l0.43,0.07l0.27,-0.41l0.31,-1.39l-0.43,-4.4l0.61,-0.82l1.25,-0.4l0.68,0.48l3.3,4.79l4.23,-2.28l1.71,3.26l1.56,-3.82l0.97,-0.95l3.97,4.54l2.42,1l2.76,2.03l2.55,0.4l0.42,-1.67l-1.47,-2.15l0.86,-0.95l3.51,-1.83l1.87,0.26l3.46,-2.61l3.42,-0.31l5.29,-4.59l0.74,-1.43l1.68,0.22l4.55,2.26l1.29,-0.21l6.63,-2.81l1.79,0.08l7.93,2.74l1.06,0.74l-0.2,2.41l1.55,0.94l4.24,0.04l1.84,0.47l1.82,2.41l-0.06,0.71l-1.44,1.85l0.23,0.39l4.69,0.64l0.69,0.43l1.37,5.47l-0.01,1.25l-1.12,2.13l-3.07,2.82l-3.41,2.33l-0.22,0.6l1.09,1.11l1.12,0.49l4.22,-1.13l1.25,1.08l1.11,2.49l-0.96,1.29l-3.91,1.6l-2.31,-2.1l-0.78,-0.46l-0.52,0.18l1.78,3.68l-0.57,1.58l-0.07,3.14l-0.51,2.55l-8.5,0.5l-3.42,2.16l-1.81,0.86l-1.18,0.13l-4.25,-2.09l-2.88,0.17l-1.75,-1.19l-1.13,-2.17l-0.53,-2.15l0.13,-4.21l-1.05,-0.4l-1.67,-1.94l-1.03,-0.57l0.11,1.83l1.3,1.58l0.21,1.27l-0.47,3.21l-1.24,2.86l-0.81,0.67l-2.21,0.05l-3.38,1.65l-1.62,0.24l-2.17,-0.39l-1.36,-0.75l-1.73,-2.09l-0.45,-0.09l-0.23,2.67l-0.42,0.35l-0.73,-0.04l-1.12,-0.83l-0.92,-1.93l-0.29,0.01l-0.62,2.21l-2.37,1.2l-1.32,0.01l-1.38,-1.38l-2.07,0.88l-3.5,-1.46l0.58,2.28l-0.93,0.35l-5.32,-0.79l-2.05,1.07l-7.44,-0.8l-0.7,-0.52l-0.51,-2.02l1.96,-7.29l-1.75,-1.6l-1.32,1.02l-0.86,2.96l-0.66,0.86l-0.8,-3.39l-0.36,0.05l-0.69,1.39l-0.51,0.33l-0.69,-0.25l-0.03,3.64l-0.59,0.96l-2.66,1.84l-2.56,0.21l-1.53,-0.41l-3.1,-1.67l-1.72,-0.08l-2.07,-2.82l-1.64,-0.65l0.78,-3.5l-2.24,2.78l-0.3,0.88l0.26,2.05l-1.84,-0.59l-1.88,0.4l-1.05,-1.48l-1.84,-1.51l-0.81,-1.7l-1.91,-8.88l0.08,-0.73l0.94,-1.01l-0.14,-0.79l-2.43,-3.72l-0.55,-2.38l-0.02,-3.86l3.07,-9.03l-1.04,-6.87l-4.7,-9.91l-3.43,-9.02l-0.9,-0.46l-1.04,0.24l-2.25,1.83l-0.94,1.45l-6.43,-0.35l-1.82,-0.56l-1.36,0.15l-2.33,1.34l-2.49,-0.25l-1.56,-3.74l-3.53,-2.02l-1.05,-1.14l-0.72,-1.56l0.24,-1.02l2.01,-0.92l1.24,-1.83l-1.99,0.71l-0.88,-0.13l-5.99,-5.17l-2.16,-1.38l0.02,-2.53l1.78,1.45l0.8,0.11l1.25,-0.43l0.44,-0.91l-3.31,-3.61l-0.38,-0.97l0.49,-2.31l0.66,-0.53l2.76,-0.78l2.83,-1.81l1.9,-0.65l1.89,0.1l4.59,1.86L418.71,525.31zM459.66,541.1l-0.42,0.52l-1.35,-0.27l-0.45,0.51l-1.71,-1.39l-3.51,-8.18l0.28,-2.08l1.03,-0.88l2.45,-1.05l1.68,0.03l2.27,3.73l-0.12,1.56l-1.02,2.74l0.16,2.69L459.66,541.1zM277.89,601.18l0,-24.13l0,0l8.21,1.17l0.73,-0.3l0.52,-0.96l0.43,-2.96l-0.41,-2.71l-7.63,-5.98l-0.67,-2.43l3.73,-3.41l0.22,-3.27l-0.51,-1.33l-2,-2.54l-1.77,-0.38l-0.85,-0.81l0,0l-0.01,-8.95l0,0l1.24,-1.64l4.72,-9.21l2.15,-2.04l2.39,-0.37l2.49,2.47l0.55,0.15l0.23,0.65l-0.41,2.23l-1.1,2.78l0.07,0.85l0.61,1.94l0.42,3.74l2.86,4.14l0.63,3.65l-2.32,4.41l-0.04,1.83l1.98,0.46l1.32,-0.41l1.49,0.28l1.15,2.31l-0.28,2.04l-2.38,4.97l0.62,0.31l0.3,-0.21l1.93,-2.76l1.45,-0.87l1.1,-0.2l1.81,0.55l1.49,1.69l1.23,6.04l0.2,-3.74l1.83,-1.34l-1.18,-1.96l-0.23,-2.91l1.51,-2.67l1.33,-1.09l1.18,-0.26l4.41,1.9l2.44,2.35l1.36,7.32l-0.35,4.11l-1.42,4.71l-0.22,3.17l-1.43,7.8l-2.06,3.57l-4.44,2.57l-3.34,2.61l-1.72,0.45l-2.77,-0.86l-3.21,-1.66l-1.83,0.47l-1.82,1.2l-2.22,0.16l-2.48,-1.55l1.06,-1.09l-0.29,-0.59l-1.48,-0.85l-6.02,6.29L277.89,601.18zM356.57,538.33l-2.32,0.17l-1.07,-0.46l-0.07,-0.68l0.93,-0.9l3.09,-1.46l1.82,-2.68l0.68,-0.33l2.38,-0.38l3.16,0.72l-4.28,3.31L356.57,538.33zM388.17,542.67l-0.34,5l1.87,5.8l0,2.7l-0.74,2.12l-0.33,2.73l0.43,4.72l-0.83,1.77l-1.76,1.54l0.25,0.81l4.08,2.38l-0.02,4.34l0.66,4.73l-0.25,0.09l-2.6,-3.23l-2.02,3.27l0.23,5.52l1.33,2.44l0.27,2.22l-1.51,0.19l-1.15,-1.1l-0.67,-1.66l-0.42,0.86l0.13,0.81l0.78,1.48l0.33,1.76l-1.5,0.95l-1.56,0.02l-3.66,0.91l-1.18,-0.43l-2.88,0.08l-1.53,-1.17l-0.85,0.2l-1.85,2.08l-5.45,-0.83l-1.1,-2.05l-1.14,-4.25l0.21,-1.08l2.76,-0.58l0.06,-0.37l-5.25,-3.54l0.17,-2.12l3.88,-1.95l2.82,-3.85l1.75,-1.57l0.13,-0.76l1.48,-0.79l3.42,-0.48l0.13,-1.08l-6.46,0.62l-8.84,2.2l-2.73,1.08l-2.28,-0.63l-10.1,3.39l-1.01,-1.07l-0.87,-2.02l0.62,-1.41l2.84,-2.68l1.42,-2.36l-0.17,-1.28l1.13,-2.28l1.81,-0.32l3.08,1.88l1.6,1.85l1.43,0.87l1.27,-0.17l1.31,-1.3l-2.56,0.54l-1.4,-2.28l-0.81,-2.65l0.67,-2.73l-2.56,-0.59l-0.96,-1.24l-0.44,-1.55l0.9,-2.5l2.17,-2.52l-0.25,-0.7l-3.16,0.06l-0.7,-0.33l-1.35,-1.58l0.3,-1.75l2.21,-4.1l0.64,-0.47l0.99,0.01l2.35,1l2.48,3.04l0.75,3.77l8.52,10.64l0.77,0.77l1.39,0.57l1.47,-0.64l0.11,-0.67l-2.59,-2.58l-1.21,-3.27l0.24,-0.61l0.75,-0.21l1.9,0.25l2.23,-0.51l-2.48,-0.8l-1.62,-1.06l-1.66,-0.05l-2.07,-1.7l0.51,-1.08l2.82,-0.76l0.58,-0.8l-1.77,-1.78l-4.27,-1.4l-1.52,-1.57l-0.64,-1.47l0.55,-1.86l2.29,-2.34l1.67,-1.12l2.86,-0.82l2.28,0.1l1.3,0.31l3.04,3.97l1.43,2.59l2.5,-0.46l-1.19,-5.74l2.8,-3.08l1.64,1.03l2.61,3.56l3.83,2.18l0.74,0.87L388.17,542.67zM331.5,538.19l0.44,0.21l2.25,-0.91l1.24,2.4l4.78,3.41l0.16,0.7l-0.44,1.01l-2.05,2.19l-1.44,0.7l-7.16,0.11l-0.78,-0.32l-1.96,-7.86l-0.08,-2.56l0.76,-0.92l2.65,-1.39l1.17,0l0.73,0.35l0.3,0.71L331.5,538.19zM347.6,559.69l1.97,2.79l-2.78,1.63l-0.94,0.96l-1.4,3.25l-3.26,0.61l-3.33,-0.03l0.63,-2.15l1.82,-3.52l-1.43,-1.46l-5.09,2.44l-1.93,-1.5l1.65,-3.85l-3.96,-0.37l-1.47,-2.29l0.5,-2.76l11.23,-4.87l3.32,0.17l1.29,0.96l0.84,7l0.58,0.32L347.6,559.69zM555.25,562.98l0.1,2.16l-0.65,-0.1l-2.07,1.41l-1.69,0.2l-0.84,-0.63l-0.54,-1.48l1.32,-2.77l4.86,-6.97l1.47,1.48l-0.91,3.01l-0.99,1.49L555.25,562.98zM416.63,569.44l-0.88,0.02l-1.14,-0.76l-1.34,-5.91l0.55,-0.87l0.85,-0.1l1.85,-1.45l0.6,0.93l1.57,6.74l-0.3,0.81L416.63,569.44zM402.72,578.08l-0.7,1.18l-0.72,0.09l-0.97,-1.11l-1.05,0.42l-2.34,4.04l-1.2,0.41l-0.52,-0.37l-0.95,-3.15l0.34,-1.49l4.12,-2.65l0.85,-0.82l0.54,-1.74l1.99,1.49l1.66,2.13L402.72,578.08zM425.45,595.07l0.58,2.63l0.13,3.28l-0.98,6.4l-3.69,0.83l-4.93,0.25l-1.46,-0.18l-0.96,-0.61l-4.32,-4.56l-5.19,-1.24l-2.05,-3.51l-0.78,-0.63l-0.79,1.05l-1.04,-2.73l-1.56,0.31l-0.36,-1.44l0.3,-2.33l1.64,-3.94l1.82,-1.01l0.56,-2.14l-0.06,-2.03l1.53,-3.04l2.54,-3.03l5.57,-3.35l1.54,-0.29l2.06,0.25l1.98,1.07l4.65,6.12l1.42,2.61l2.27,7.46L425.45,595.07zM330.63,594.78l-1.69,0.19l-2.92,-1.05l-2.27,-3.01l2.14,-7.11l1.57,-2.25l1.15,-0.6l2.43,0.19l2,1.91l0.94,4.18l0.92,2.31l-0.19,1.66l-1.34,2.07L330.63,594.78zM409.64,612.89l-1.21,-0.02l-3.01,-1.5l-0.66,-1.07l1.71,-1.84l1.35,0l1.41,1.73l0.67,1.55L409.64,612.89zM391.27,612.19l-2.69,2.03l-0.84,-1.5l2.99,-3.91l1.12,1.69L391.27,612.19zM428.78,624.32l5.24,2.56l3.26,3.59l5.31,-1.8l4.86,0.6l4.13,1.87l1.52,1.4l0.93,1.28l-0.24,1.41l-1.65,4.43l-1.78,3.36l-1.52,1.67l-2.83,7.02l-2.73,2.11l1.15,1.28l-0.3,1.53l-2.95,7.06l-2.95,4.91l-1.05,0.82l-1.41,0.25l-8.5,-2.52l-2.13,0.04l-5.67,1.32l3.95,2.68l1.78,3.29l0.34,1.77l-0.19,2.33l-2.83,4.98l-1.5,6.54l-0.95,0.81l-3.17,-1.24l-4.58,0.89l-1.66,-0.43l0.23,-4.45l-0.75,-9.51l-2.66,-8.4l-0.49,-3.13l-0.28,-25.27l0.57,-1.04l1.64,-0.86l3.5,2.22l1.61,0.74l1.07,-0.03l-1.79,-1.67l-1.46,-2.85l-0.67,-2.45l0.12,-3.36l1.32,-1.83l2.19,-1.45l2.21,-0.89l4.88,-0.6l1.38,0.43l2.11,-1.6l1.25,-0.38L428.78,624.32zM383.07,633.84l-2.58,0.68l-1.19,-0.29l-1.13,1.27l-1.41,0.16l-2.91,-1.61l-1.07,-1.08l0.64,-0.98l3.06,-1.27l0.9,-1.36l0.77,-0.46l2.09,-0.44l4.7,-2.29l3.25,-0.13l0.35,1.21l-0.86,2.15l-3.52,3.78L383.07,633.84zM367.55,631.34l7.57,6.9l9.02,-2.78l2.87,-1.97l2.24,-0.26l3.2,1.41l1.01,1.72l0.9,2.69l0.09,1.27l-1.39,2.36l-2.14,0.89l-0.85,1.19l-0.96,-0.32l-0.26,1.08l0.36,0.98l1.04,-0.54l1.07,0.23l1.08,1.88l-0.38,1.08l-4.69,3.17l-5.2,7.44l-0.55,1.36l0.05,1.29l0.08,0.52l0.49,0.21l1.67,-1.8l2.16,-1.3l2.72,0.24l1.44,1.08l1.32,1.66l0.3,0.6l-0.73,1.62l1.26,0.83l1.39,2.26l0.09,1.37l-0.77,2.25l0.28,0.46l2.32,-1.79l1.77,-0.79l1.16,0.44l0.87,4.39l-0.24,3.52l-1.48,2.73l-1.46,0.58l1.19,1.51l0.68,1.96l-0.23,1.72l-1.33,2.91l1.27,2.27l0.1,3.86l-2.99,1.21l-2.47,3.38l-2.14,1.12l-1.08,0.13l-5.37,-0.93l-0.92,-1.51l-0.35,-3.92l-1.22,2.27l2.04,6.1l0.29,3.33l-1.92,2.58l-2.25,1.31l-1.08,-0.32l-1.81,-1.56l-1.62,0.07l-0.51,-0.56l-1.61,-4.79l-2.97,-5.69l-5.3,-7.11l-2.41,-4.32l-1.01,-0.98l-2.48,-0.71l-0.98,-2.03l-1.04,-1.12l-0.99,0.12l-1.61,1.03l-2.02,-1.09l-2.24,-5.07l-3.84,-3.24l-2.75,-5.11l0.19,-2.37l1.22,-4.13l1.93,-2.63l1.18,-0.41l2.52,0.63l0.78,1.2l0.72,2.3l1.89,1.82l1.73,4.15l0.69,0.74l1.66,0.25l5.4,-1.8l0.38,-1.03l0.42,-5.18l1.5,2.38l0.35,0.26l0.54,-0.5l0.28,-1.72l-1.25,-4.06l-0.88,-1.02l-1,0.25l-0.76,-0.55l-0.04,-1.84l0.87,-1.76l0.88,-0.33l1.03,0.33l1.42,1.35l0.9,0.3l1.27,-0.39l-1.62,-0.8l-2.26,-3.14l-0.97,-0.59l-1.98,1.86l-2.71,0.75l-5.03,-4.87l-0.65,-1.74l0.54,-1.5l1.25,-1.21l3.11,-0.88l1.09,0.9l2.98,3.85l-0.77,-3.98l-1.57,-1.19l-1.52,-2.5l-0.09,-3.2l0.43,-0.45l3.87,-1.23l2.7,1.36l1.71,0.2l0.71,-1.67l-0.25,-0.33l-1.92,0.42l-0.66,-1.45l0.79,-1.29L367.55,631.34zM487.78,718.88l0.36,0.61l2.05,-0.77l6.07,-3.75l4.92,0.01l0.84,0.4l-0.58,1.63l0.16,0.55l1.59,1.57l0.72,-2.52l1.03,-9.64l0.13,-4.16l-0.35,-1.29l-1.26,-0.77l-2.61,-0.07l-1.87,-1.03l-2.3,-4.85l-2.83,-3.47l0.44,-1.03l2.84,-2.31l1.25,-3.31l0.75,-0.54l2.72,0.44l6.59,5.07l-0.57,-1.45l-2.65,-2.78l-1.78,-3.48l0.28,-0.63l1.49,-0.65l0.19,-0.74l-2.03,-0.88l-2.75,0.69l-1.66,-1.14l-2.46,-5.46l-0.31,-3.53l0.27,-2.93l2.08,-3.83l1.13,-0.28l2.44,1.04l6.57,3.74l-0.16,-1.2l-7.35,-5.07l-2.6,-1.31l-0.64,-1.85l3.91,-7.14l3.61,-1.69l1.79,-2.1l2.93,-0.09l2.75,1.33l-1.19,-2.88l0.1,-0.63l1.56,-1.5l2.86,-1.77l3.5,-1.41l1.59,-1.26l1.65,-0.45l4.09,-0.22l2.3,0.21l3.06,1.08l1.79,1.96l1.5,4.91l0.78,5.19l1.13,2.14l1.82,1.18l1.26,1.28l0.7,1.38l0.1,5.94l1.44,3.39l1.38,1.4l-0.41,1.59l-8.13,12.1l-0.1,1l4.3,-5.3l1.34,0.19l-0.82,3.33l-2.14,3.77l2.24,3.12l-0.38,0.42l-0.99,-0.21l-0.7,0.7l-0.04,4.77l1.1,-0.62l3.73,-6.38l1.83,-1.76l0.59,-0.16l2.08,1.08l-2.01,-4.56l0.6,-1.83l1.89,-1.54l0.48,0.22l1.11,3.15l0.63,0.52l1.4,-0.67l0.93,-1.58l2.9,3.51l-0.07,6.7l2.08,3.26l1.71,1.44l-0.33,-1.57l-0.79,-1.08l-1.36,-3.73l0.38,-4.82l1.08,-2.53l2.42,2.11l2.8,-0.02l3.5,2.95l1.88,0.06l-0.17,-1.2l-1.42,-0.58l-5.31,-3.58l-1.49,-2.23l-0.28,-1.05l0.55,-3.01l3.78,-3.48l2.22,-1.12l4.46,-0.33l3.24,0.46l1.75,0.77l4.56,3.69l0.91,0.33l2.28,-0.46l1.16,0.15l3.68,2.71l1.56,3.06l0.72,3.19l-0.11,1.27l-3.06,5.45l-1.33,0.92l-3.41,8.37l0.9,-0.82l1.99,-4.96l4.05,-4.19l2.19,-1.09l1.87,0.1l2.85,0.88l1,0.84l0.48,2.87l-0.92,2.77l-5.17,3.36l-2.8,0.47l0.12,0.5l2.08,0.69l2.32,-0.23l-1.15,2.97l-0.35,1.87l0.25,2.76l-1.74,4.92l0.35,0.35l2.13,-3.35l1.43,-6.95l1,-1.8l0.75,-0.69l2.38,-0.28l1.32,-1.92l1.13,-0.61l1.43,0.71l-0.06,0.76l-1.39,3.43l-2.95,5.51l1.2,-0.63l3.14,-4.55l0.82,1.76l1.26,1.31l0.75,2.98l1.95,2.53l-0.1,-1.87l-1.06,-3.78l0.29,-1.52l3.37,-3.97l2.88,2.02l1.94,-0.12l4.39,1.41l3.72,2.75l1.14,1.7l1.31,3.49l-0.29,1.11l-1.59,2.56l-1.76,1.67l-2.36,-0.51l-0.73,0.29l-3.22,4.28l-3,2.96l2.87,-0.05l2.72,-4.96l2.39,-0.92l3.33,1.97l1.65,-0.08l1.26,-1.98l1.97,-1.62l1.38,1.56l0.3,4.12l-1.1,3.01l-2.33,3.21l-1.52,1.2l-3.53,1.72l-1.29,2.1l-1.44,1.5l1.06,1l0.4,-0.03l1.46,-2.96l1.24,-1.25l0.46,0.1l0.89,1.29l-0.03,2.01l-1.34,7.9l1.04,-2.15l2.99,-9.92l1.16,-1.69l2.6,-2.56l4.27,-2.48l1.21,-0.42l1.38,0.29l0.9,1.33l3.64,0.07l7.55,5.13l0.79,1.92l-0.05,1.12l-1.07,1.78l-1.44,0.84l-1.79,1.83l-5.31,1.63l-2.36,1.69l-3.25,3.12l0.03,0.74l1.3,0.36l1.05,-0.47l1.45,-2.15l1.36,-0.83l5.06,-1.24l1.26,0.09l0.49,1.53l-2.55,4.38l1,0.68l1.37,0.3l2.28,-3.23l0.88,-0.18l1.44,-1.07l0.18,-0.43l-0.97,-0.85l-0.08,-0.52l1.11,-2.68l0.74,-0.88l0.55,-0.07l1.83,0.94l4.81,7.47l1.31,5.19l-0.44,1.78l-1.03,0.25l-4.21,-1.46l-1.92,0.19l-1.52,1.02l-0.9,1.7l-0.74,0.52l-2.67,0.02l-1.5,0.52l-3.5,1.95l-0.21,0.91l1.58,-0.16l2.6,-1.18l2.44,-0.33l4.08,2.6l1.34,0.4l1.65,-0.49l4.37,0.49l1.65,0.99l3.01,2.78l0.34,3.05l-0.25,0.58l-0.86,0.39l-4.74,-0.8l-1.36,0.45l-2.52,-0.84l-1.55,-1.21l-2.33,1.15l-1.87,-0.75l-1.91,0.66l-3.78,2.72l0.42,0.47l5.18,-2.33l1,0.14l4.23,2.52l0.72,0.68l0.01,2.62l-1.18,3.72l-3.95,-1.49l-1.13,-0.17l-2.46,1.01l-4.42,-1.55l-1.11,0.08l4.22,2.71l4.82,0.68l1.1,0.73l0.52,0.54l0.04,1.6l0.99,1.6l0.89,0.65l2.53,-0.65l1.8,1.29l2.27,0.78l3.12,-0.14l1,0.34l0.26,0.29l-0.43,0.51l-2.11,1.23l-0.32,1.17l1.81,2.67l-0.83,3.61l1.74,-1.52l0.59,2.27l0.51,-1.81l-0.23,-2.42l0.9,-0.96l2.85,-0.73l-0.56,5.77l-1.25,3.26l-1.04,1.05l0.77,0.63l0.46,0.05l0.44,-0.51l1.06,-2.51l2.15,-2.63l0.39,-0.06l-0.29,2.71l0.99,0.83l1.46,-1.52l1.73,0.44l-0.29,4.82l1.25,2.14l-0.37,-3.73l0.24,-1.12l3.15,-3.51l0.78,-0.41l0.49,0.28l0.78,1l-1.71,2.34l-0.41,1.62l0.45,0.86l1.71,0.08l1.72,-1.33l0.99,0.65l3.33,4.48l1.23,-0.75l1.52,2.09l-2.04,1.65l0.62,3.46l-6.2,-0.07l0.99,0.81l1.91,0.34l0.17,1.04l4.66,-0.18l0.11,-1.2l2.08,-1.44l2.47,0.96l2.47,2.35l-1.09,1.4l-0.87,3.45l-3.97,4.62l0.59,0.04l6.04,-2.93l1.74,0.39l0.52,-0.51l2.96,1.11l2.3,-3.24l1.39,0.63l6,8.43l-0.07,0.9l-1.98,1.14l-1.76,-1.8l-1.62,-0.91l-0.98,0.1l-0.98,0.69l4.22,3.15l0.68,2.03l0.05,0.89l-2.62,1.34l-0.84,0.08l-1.81,-0.64l-1.94,-1.63l-1.6,0.09l1.32,2.03l-1.15,1.98l2.61,1.75l1.96,1.78l0.29,0.71l-2.27,0.65l-3.1,-0.63l-0.3,0.4l1.58,1.56l0.59,2.46l-0.93,0.63l-1.12,1.76l-0.44,1.82l-1.01,0.17l-0.41,-0.34l-1.36,0.55l-1.79,-0.76l-2.6,-4.27l0.34,3.15l-2.07,0.75l0.01,0.29l2.81,0.96l-0.23,8.33l-0.34,2.37l-1.84,4.04l-1.17,-1.29l-1.42,-2.55l-1.49,-0.27l-0.81,1.19l-1.74,-2.26l0.68,-4.89l-1.79,3.18l-0.76,2.9l-4.96,-7.44l-0.6,-2.25l-2.03,-4.26l0.21,-1.27l1.73,-2.58l1.37,-1.07l1.6,-0.6l1.62,-3.91l0.98,-1.77l1.06,-1l-0.53,-0.19l-1.35,0.86l-3.13,4.64l-3.69,1.83l-3.68,-0.05l-0.59,-0.51l0.3,-1.46l1.8,-2.62l-0.29,-0.18l-1.5,1.57l-1.86,0.21l-1.3,-1.63l-2.41,-1.63l-2.11,-4.04l-0.67,-2.14l-1.78,-1.62l-0.25,0.12l0.41,1.69l-0.97,0.49l-1.01,-0.17l-1.05,-0.83l-0.09,1.11l1.13,1.97l0.02,2.48l-0.32,0.26l-1.29,-0.16l-1.71,-1.85l-2.77,-2.01l-0.13,0.51l1.6,4.44l4.67,5.19l-0.8,1.74l-0.7,0.57l-1.79,0.18l-2.49,-0.96l-1.17,-1.07l-1.69,-2.56l-2.8,-2.65l-2.59,1.09l2.53,0.6l2.24,2.09l0.17,0.88l-0.56,0.98l0.03,1.23l0.63,1.48l0.64,0.95l1.98,0.75l0.25,0.43l-0.79,3.28l0.16,1.26l1.97,-1.31l1.32,-0.39l1.52,1.2l0.86,2.28l1.66,0.92l-1.96,2.02l1.42,0.92l1,1.28l0.86,3.39l0.74,-0.19l0.51,0.42l1.2,5.48l0.55,-3.91l3.69,3.09l0.13,0.55l-0.82,1.06l0.78,1.16l0.56,-0.26l1.1,-2.35l0.82,-0.83l1.53,0.68l2.29,3.09l0.73,-0.42l1.41,1.99l-2.28,2.64l3.14,-0.1l0.75,0.52l0.18,1l-1.24,2.76l-2.64,-0.31l-0.77,0.15l0.12,0.36l2.08,1.27l1.78,2.98l-0.18,1.21l1.43,0.39l2.98,-0.39l-0.07,1.37l-1,0.92l1.45,-0.05l0.54,0.43l1.48,3.87l-1.35,0.54l0.56,4.36l-0.14,3.97l-1.35,0.37l-2.41,-7.08l-2.32,-3.33l0.92,3.2l0.76,5.46l-0.58,1.39l3.55,6.76l-0.71,0.68l-1.05,0.14l-2.37,-1.42l-0.27,0.39l1.04,4.53l-0.03,1.08l-0.52,0.38l-4.16,-4.74l-1.51,-1.24l-0.84,0.46l-3.5,-3.92l0.21,1.99l-0.25,0.3l-1.67,-0.71l-2.16,-4.71l0.17,3.66L666.1,903l-0.68,-1.84l-1.81,-1.85l-0.39,-1.21l-1.45,0.23l-0.73,-0.71l-5.67,-7.9l1.53,6.26l-1.03,-0.53l-3.64,-3.77l-2.24,-1.79l-3.27,-0.53l-0.47,0.98l1.09,2.18l3.72,4.87l2.09,3.58l2.03,1.16l2.15,0.4l-0.55,1.66l3.32,1.88l3.47,4.18l3,1.92l3.26,5.79l2.7,1.8l-0.42,1.38l-0.95,0.67l0.67,3.6l-2.38,0.83l-4.3,-2.71l-3.39,-1.15l-2.32,-1.5l-9.82,-2l-5.29,-3.25l-2.16,-2.87l-1.61,-3.37l-0.53,-0.45l-1.75,-0.45l-2.43,0.65l-1.48,-0.12l-3,-2.07l-2.06,-0.81l-2.73,-1.81l1.43,-2.34l-2.76,1.55l-0.84,-0.47l-2.42,-2.4l-2.14,-3.34l-1.23,-1.22l0.17,-0.27l3.22,-0.29l1.42,-1.37l0.67,-1.37l-1.19,-0.13l-1.9,-2.41l-1.01,-0.38l-3.46,0.32l-0.6,-0.39l1.04,-3.36l-2.47,1.53l-0.43,-0.11l-1.61,-4l-2.11,-1.99l-3.2,-4.45l-1.65,-1.36l1.64,-3.81l-1.27,0.17l-1.92,-0.59l-0.91,0.71l-1.63,-0.21l-0.36,2.34l-0.27,0.58l-0.75,0.27l-0.59,-3.81l-0.67,-0.42l-2.3,-0.35l-1.55,-3.76l-0.42,-0.14l-1.18,0.72l-0.92,0.09l-0.03,0.56l2.5,4.36l-0.49,1.26l-3.34,0.83l-2.34,-0.7l-1.43,-1.05l-2.04,0.34l-0.46,2.75l-3.15,0.32l-2.59,1.51l-1.39,0.03l-1.46,1.23l-1.19,0.09l-1.5,-0.69l-3.4,-0.6l-2.02,-1.31l-1.19,0.07l-2.55,-2.88l-1.37,-3.45l0.91,-5.77l0.91,-1.76l1.06,-1.07l3.84,-1.89l0.78,-0.75l-0.89,-3.41l1.2,-2.09l0.68,-0.21l1.41,0.69l2.83,0.37l2.67,0.95l5.86,3.06l2.76,3.64l0.16,0.91l-0.79,2.29l1.23,1.34l0.85,-3.53l-0.79,-1.93l-2.93,-3.36l-0.23,-0.87l0.81,-0.39l3.51,0.88l1.35,-0.2l1.65,-2.09l4.37,0.21l0.93,-0.56l1.38,-1.86l2.22,-0.71l3.93,0.68l-0.09,-1.25l-1.66,-4.86l-2.57,-2.41l-2.18,-2.98l-1.12,-1.86l-0.14,-1.55l0.37,-0.91l3.96,-3.34l3.13,-3.33l2.72,-3.79l2.22,-1.21l0.78,-3.53l1.42,-3.37l3.8,-2.36l1.3,-2.79l-0.13,-0.7l-1.06,-1.33l-3.34,-11.03l-3.03,-7.05l-2.37,-3.85l0.39,-2.19l-0.2,-0.26l-3.03,1.78l-1.58,-1.66l-0.53,-1.62l0.87,-3.63l-0.36,-2.65l-1.01,-0.62l-1.24,-0.1l-0.4,0.35l1.36,3l-0.21,0.74l-2.52,0.18l-1.37,-0.95l-2.02,-3.14l-0.47,-2.49l-0.97,0.31l-0.76,-0.3l-0.16,-0.37l1.5,-2.24l-0.65,-0.57l-0.98,-0.11l-0.26,-0.51l2.13,-2.11l-1.24,-0.51l-2.24,3.13l-0.98,0.78l-1.34,-0.97l-0.85,-0.32l-0.59,0.21l-0.9,1.62l-5.48,3.96l-1.51,0.88l-1.63,-0.16l-0.28,-1.51l0.53,-6.21l1.58,-1.08l2.62,0.66l1.21,-0.12l2.56,-3.21l0.18,-1.35l-1.25,-2.68l-2.33,-1.72l-3.24,-1.4l-0.51,-0.72l-0.5,-1.21l0.04,-1.91l0.47,-0.75l2.05,-1.08l-1.7,-0.64l-0.8,0.07l-2.05,2.86l-1.55,-0.98l-0.93,-0.15l-0.98,-0.92l2.33,-2.39l0.09,-0.78l-0.93,-1.28l-2.42,-0.77l-2.35,0.48l-0.87,-0.24l-1.63,-10.31l-0.61,-0.23l-2.82,0.74l-1.13,-0.27l-3.04,-3.3l-1.88,-2.93l-1.33,-3.17l-0.78,-0.6l-2.51,3.27l-0.53,2.17l0.52,0.76l2.96,1.25l0.75,0.84l1.43,5.03l-0.39,2.45l-2.46,2.23l-1.89,0.8l-1.9,0.19l-5.8,-2.83l-2.01,-0.38l-2.54,-1.09l-1.39,-0.12l-2.44,-0.91l-4.13,-0.53l-0.83,0.44l1.1,1.22l0.96,0.61l0.83,0.01l1.19,1.09l2.44,3.45l0.76,2.06l-0.73,1.05l-5.76,-5.5l-5.15,2.64l-1.39,0.11l-7.67,-4.49l-3.41,1.16l-2.94,0.05l-5.94,-1.11l-2.18,-0.75l-1.29,-1.17l-4.69,-0.87l-3.12,1.96l-3.75,-1.8l-1.11,-1.06l-1.44,-3.79l-0.15,-1.64l0.92,-3.07l-2.75,1.99l-3.75,-0.57l-0.44,0.32l0.97,1.99l-1.57,0.41l-2.37,-0.42l-1.03,0.18l-1.97,1.92l-0.56,-0.14l-4.49,-5.08l-2.34,-0.76l-1.66,-1.4l-3.23,-6.4l-1.46,-6.46l-0.76,-1.81l6.82,0.45l1.6,0.41l1.86,1.27l2.42,0.91l1.74,0.19l5.95,-1.19l0.37,-0.66l-3.88,-2.65l-2.69,-2.8l-1.69,-0.52l-4.74,-0.36l-4.39,-1.33l-3.03,-1.8l-3.48,-3.09l-0.75,-3.49l-1.22,-10.39l0.84,-2.91l2.4,-3.18l0.06,-0.5l-1.48,-0.96l-0.32,-1.19l-0.14,-3.5l0.51,-2.98l4.12,-10.1l1.19,-9.29l2.23,-4.47l1.94,-1.87l0.5,-2.84l4.8,-6.06l4.04,-4.06l2.22,-1.17l6.31,-2.39l3.25,-0.67l4.08,0.15l7.53,1.35l0.91,0.95l0.56,1.82l-2.31,3.76l-4.28,4.49l-2.86,4.67l-5.64,13.61l-0.24,4.45l2.99,7.88l-0.17,9.95l1.1,6.5l1.63,3.68l4.47,6.14l4.11,4.43l0.5,1.27l-3.42,3.53l-4.84,1.78l-2.1,1.85L487.78,718.88zM551,640.7l1.53,0.42l9.68,-0.78l2,0.58l7.68,4.69l1.8,4.51l2.21,1.44l0.91,1.74l0.78,2.94l2.51,2.41l-0.18,2.55l1.97,3.57l-0.84,1.16l-1.95,0.68l-5.5,-0.71l-7.37,-1.61l-4.29,0.46l-7.35,3.34l-3.28,0.47l-2.87,-2.13l-1.39,-2.01l-1.87,-10.21l-0.98,-0.65l-2.92,-0.78l-1.42,-1.98l-0.42,-2.97l0.22,-1.34l0.56,-0.36l-0.82,-1.63l-0.28,-1.8l0.09,-4.13l0.77,-1.17l3.14,-0.25l2.62,1.87l2.07,0.18L551,640.7zM320.15,663.58l-0.45,0.15l-0.85,-0.7l-5.71,-7.95l-0.98,-3.35l-3.1,-3.42l-3.55,-2.09l-0.25,-0.96l1.06,-2.81l1.95,-3.07l9.88,-2.24l1.74,-0.04l1.82,0.73l2.51,3.1l1.04,0.35l0.62,0.7l0.84,2.32l-0.6,7.22l-1.52,4.46l-1.59,2.44l-0.3,1.57L320.15,663.58zM216.46,755.12l1.84,0l-0.39,-1.18l-3.42,-5.02l0.18,-2.96l37.42,0.02l0.06,4.38l2.02,-0.03l1.35,-2.01l0,-2.34h22.41l-0.02,-84.3l0,0l3.51,3.24l2.27,3.05l2.11,1.47l1.38,2.18l-0.24,1.74l2.15,1.34l4.29,19.1l0.79,5.07l2.36,2.43l1.01,0.36l1.13,-2.56l3.05,-2.95l-0.27,-1.92l0.63,-0.25l-2.12,-3.78l-1.37,-3.61l-0.88,-4.5l-0.27,-4.15l-0.98,-2.31l-0.02,-2.01l-2.72,-15.74l0.31,-2.39l2.4,-1.06l-1.27,-2l-0.11,-0.69l0.54,-1.41l2.77,0.62l5.44,4.26l1.46,-2.61l1.1,0.31l3.1,2.16l3.59,3.84l2.41,1.88l1.69,2.54l1.87,4.23l-0.13,1.45l0.96,3.18l0.8,6.55l3.19,12.75l4.41,11.55l0.27,5.5l-1.86,6.96l0.43,1.88l3.12,3.77l1.91,4.49l3.31,3.57l2.6,1.58l1.95,1.71l0.5,-0.19l0.18,-0.68l-0.73,-2.1l-0.05,-0.83l0.35,-0.15l2.68,3.59l6.82,6.33l0.47,0.28l2.34,-0.1l1.02,3.79l3.71,-0.33l0.95,0.97l1.2,6.33l-0.23,3.99l-0.42,0.92l-0.55,0.29l-1.55,-0.28l-1.09,-0.79l-1.31,-3.63l-1.47,3.93l-1.91,-1.02l-2.89,-2.8l-1.49,0.86l-2.22,2.46l0.55,2.5l-0.25,1.21l-0.52,0.57l-2.68,-0.34l-3.94,-3.11l-0.95,1.05l3.73,4.43l0.08,2.66l-0.72,4.13l2.12,-3.46l3.92,-3.44l2.65,-0.29l0.95,0.58l0.63,1.47l-0.82,1.78l0.19,2.01l0.48,0.55l1.08,-0.1l0.75,1.47l-0.61,3.96l-5.66,3.37l-2.24,0.59l-1.41,1.03l-2.4,-0.13l-2.74,0.5l-5.37,-1.41l-2.56,-1.56l-1.96,1.4l-4.79,-1.2l-0.57,-0.87l1.32,-2.43l0.02,-0.72l-7.04,-1.81l-1.82,0.14l-2.35,-1.18l-0.64,-0.75l-0.18,-3.97l-1.6,-1.58l-1.07,0.09l-1.76,2.35l-1.59,4.21l-3.64,4.48l-3.8,1.19l-4.5,0.49l-1.68,0.93l-3.53,3.41l-4.72,2.05l-4.36,1.14l-7.97,1.27l-0.98,-0.39l-1.53,0.14l-1.64,1.14l-15.32,1.48l-0.97,-0.31l-0.93,-1.01l-2.9,-5.71l-0.56,-1.76l0.22,-3.02l-0.91,-5.9l-3.4,-1.42l-2.24,-0.45l-7.5,0.11l-4.12,-0.46l-4.33,-1.38l-3.9,-2.45l-0.65,-2L216.46,755.12zM396.41,663.08l-1.45,0.3l-1.34,-2.15l0.21,-4.1l0.49,-0.84l1.37,-0.98l2.37,3.55l-0.65,3.46L396.41,663.08zM414.43,960.67l-64.81,0.01l0,0l0.02,-81.06l-62.52,-11.46l-2.17,-0.71l-2.7,-1.89l-10.34,-12.68l-16.44,-0.11l-36.64,-27.67l-36.64,-29.12l-0.04,-38.73l0,0l4.86,4.76l2.57,0.97l8.82,2.16l6.93,5.39l7.78,3.23l1.8,-0.06l5.39,0.88l3.27,1.08l-1.72,-3.01l0.07,-0.4l2.75,0.4l0.47,-0.73l0.69,0.02l3.26,1.14l4.02,2.26l3.35,2.57l3.6,4.77l1.13,2.85l1.14,0.88l-0.51,2.25l-0.67,0.96l-1.6,0.46l-4.4,-0.54l-0.78,1.81l-2.46,1.52l-0.54,1.15l0.18,1.57l-2.33,2.27l-0.07,0.5l2.7,1.98l1.09,0.3l1.38,-0.17l5.29,1.95l3.35,0.57l12.46,0.59l2.39,-1.16l5.93,-0.61l3.44,-1.56l0.33,0.58l1.48,0.18l5.54,-3.88l1.4,0l1.28,-0.93l1.23,2.5l0.94,0.52l1.8,3.16l3.64,0.07l1.67,0.91l0.79,4.63l0.88,1.68l1.23,-3.76l0.31,-0.55l0.6,0.19l1.09,2.69l1.3,1.87l3.21,3.42l0.71,2.17l-0.74,1.55l-2.06,1.03l-1.11,-0.16l-1.36,-0.8l6.59,9.32l2.52,4.33l1.98,2.09l-4.04,-7.69l-0.13,-5.56l0.89,-0.44l1.14,1.53l0.72,0.13l0.15,-0.4l2.2,1.51l-1.72,-3.96l0.58,-1.12l-1.79,-2.21l-0.76,-1.71l-0.69,-2.6l-0.05,-2.95l-2.73,-4.44l-0.04,-2.81l1.75,-2.1l0.31,-1.24l-0.62,-1.87l2.59,-0.53l0.57,0.23l2.88,-1.41l1.81,-0.14l1.18,-0.74l1.1,-1.71l2.19,0.37l0.18,-2.87l1.19,-1.55l1.25,-0.16l1.79,-1.3l1.36,-2.04l0.28,-1.61l-0.22,-0.46l-1.42,-0.62l-4.71,2.94l-0.76,1.36l-0.58,2.51l-2.2,-0.72l-0.83,0.3l-1.8,1.7l-1.36,0.19l-2.88,-0.84l-1.1,1.1l0.57,2l-0.51,0.7l-5.28,0.47l-3.54,-3.46l3.63,-7.64l4.9,-0.94l2.96,-0.98l11.4,-5.72l3.29,1.37l1.01,0.91l1.31,2.71l1,6.39l0.46,1.08l2.48,2.81l0.52,0.25l0.75,-0.55l0.43,1.45l1.28,-0.03l1.04,0.52l-0.07,1.96l1.56,2.06l2.63,0.77l2.62,-0.24l2.19,-0.67l1.64,-1.1l5.67,6.27l4.67,2.78l2.36,-0.42l1.56,0.19l2.95,1.23l6.27,-2.5l3.01,-0.46l0.57,-0.5l6.12,0.58l2.7,0.73l2.92,1.43l2.03,-0.05l2,-1.28l2.56,-0.65l-0.5,-1.15l-2.11,-2.62l-0.15,-1.82l0.79,-0.73l1.94,2.01l4.34,6.59l2.9,1.88l1.37,0.33l1.62,-1.16l1.07,-1.42l0.14,-1.65l-0.6,-1.4l-3.05,-2.52l-1.73,-0.42l-3.33,1.79l-0.74,-0.48l-2.76,-4.66v-0.35l1.02,0.41l0.05,-0.41l-2.42,-5.58l1.63,-0.45l2.24,1.57l3.8,-1.7l-1.05,-1.51l-0.13,-1.81l0.87,-0.22l1.69,1.24l0.82,0.17l1.23,-0.53l1.3,1.06l2.59,4.8l3.13,0.12l1.77,-1.46l-2.61,6.55l1.71,-0.58l0.82,-2.11l4.21,-2.37l-2.05,12.69l-1.55,3.86l0.02,1.03l1.65,3.13l0.39,2.41l1.16,0.02l2.62,-1.06l0.22,0.42l-0.74,2.64l1.98,-0.71l1.26,1.38l-0.03,3.27l-0.75,0.76l-2.39,0.3l-2.25,-1.19l-0.68,0.58l-1.08,-0.1l-1.21,-1.66l-0.65,0.42l0.57,1.43l4.25,5.65l0.65,1.16l0.23,1.66l0.4,-1.66l-2.45,-4.09l-0.19,-1.53l0.58,-0.34l3.11,0.82l1.21,-0.18l0.81,-0.58l0.41,-0.71l0.85,-6.49l-1.83,-8.11l-1.53,-2.21l-0.15,-0.79l1.7,-6.75l0.69,-0.82l1.34,-0.1l0.98,-0.57l2.37,1l1.05,-0.7l3.23,-3.76l4.09,-5.99l2.47,-1.69l1.82,-1.86l-1.75,-0.35l-0.34,-6.28l-0.75,-2.05l-0.78,-0.77l-0.39,0.45l-0.86,4.02l-0.66,0.89l-3.71,1.04l-0.97,-0.81l-0.12,-0.69l0.34,-2.69l4.29,-5.29l0.02,-0.32l-1.26,-0.01l-0.3,-0.38l-0.27,-2.27l0.27,-1.83l0.88,-0.71l4.81,-1.91l-1.8,4.17l0.64,0.67l2.85,-3.77l-0.95,-0.18l0.04,-2.51l-1.05,-0.98l-3.28,1.85l-2.29,-0.22l-1.33,-1.58l-1.92,-3.4l-0.71,0.01l-0.98,1.84l-4.21,-2.3l-2.65,-2.28l-3.38,-1.22l-1.38,-1.8l-3.35,-6.63l-0.53,-2.25l0.05,-3.1l2.22,-4.92l1.57,-1.34l0.67,-0.16l1.52,0.49l-0.98,-1.83l0.91,-2.09l-2.69,1.52l-0.64,-0.11l-0.9,-0.98l-1.7,-3.53l0.7,-7.16l-0.49,-1.58l0.93,-1.37l-0.23,-1.76l1.57,-2.77l1.88,-2.1l1.24,0.58l1.78,1.82l0.83,0.26l0.61,-0.5l1.42,-4.35l-0.35,-0.39l-2.94,-0.25l-0.51,-0.33l-0.38,-1.33l2.3,-3.19l0.93,-2.61l2.78,-3.65l4.18,-2.29l1.59,0.12l0.59,1.83l0.11,1.93l1.53,2.4l4.47,-0.04l0.57,0.67l-0.15,2.99l4.54,5.02l2.02,3.52l0.74,2.06l0.59,5.35l-0.19,4.22l-0.69,1.75l1.78,1.48l1.27,2.16l2.56,2.29l1.27,3.81l1.48,2.76l0.02,2.3l0.57,0.47l0.51,-0.25l0.95,-1.25l0.94,1.13l1.36,3.21l-0.47,0.8l-2.17,0.4l-2.35,-0.98l-1.52,-1.85l-0.27,0.12l-1.71,3.47l0.59,0.54l2.86,-0.04l1.35,1.2l-2.76,3.83l-5.41,5.8l0.76,0.43l2.77,-0.82l1.63,0.27l0.73,0.5l-0.25,0.49l0.44,0.8l2.66,1.85l1.68,-0.37l3.05,-2.67l1.63,0.12l0.46,0.2l-0.17,0.43l-2.42,2.43l1.36,-0.45l3.03,0.71l2.54,0l1.94,1.02l0.31,0.47l-2.41,0.75l-0.58,0.9l-0.66,2.59l-0.63,0.59l-1.01,-0.25l-0.47,-1.05l-1.44,0.41l-0.17,0.42l4.42,4.53l1.41,3.98l0.97,1.63l-0.54,1.53l0.26,3.23l-0.57,5.25l3.31,5.28l2.75,-5.67l0.12,-3.3l0.91,-2.72l1.04,-6.92l3.47,-6.06l0.73,-0.35l1.27,0.08l3.76,5.22l3.71,3.59l1.63,2.57l0.69,2.53l1.22,6.41l0.13,2.49l-0.71,2.36l-1.96,-0.07l-1.11,-2.13l-1,1.23l0.3,8.12l1.06,4.38l1.78,3.31l4.46,6.33l0.73,3.27l0.53,0.85l0.83,-0.15l3.07,-4l1,-1.07l1.17,-0.46l1.09,-1.4l0.76,-5.43l0.69,-2.06l3.99,-6.49l1.99,-9.01l-0.12,-3.26l0.49,-2.28l1.78,-2.54l1.94,0.81l3.65,-0.79v-0.42l-2.14,-1.33l0.21,-1.59l0.67,-1.03l0.83,-0.32l0.48,-2.79l-2.25,-2.31l-1.45,-0.16l-1,-1.5l-0.41,-3.09l0.14,-4.95l-0.77,-2.67l0.5,-3.26l-0.8,-1.49l1.07,-0.38l2.14,1.15l1.41,0.01l3.36,-1.17l2.92,0.16l5.86,3.73l9.38,0.22l2.19,1.27l-0.14,1.05l-0.95,1.76l-2.32,0.97l1.01,0.92l2.98,1.23l0.91,2.87l-0.17,1.22l2.47,-0.69l1.97,0.46l2.87,1.51l0.81,1.49l-2.6,3.41l-3.05,2.34l-0.06,0.63l2.43,0.12l2.74,0.72l1.05,1.72l-0.16,3.05l-2.2,2.49l-3.48,2.38l-0.82,-0.09l-0.89,-0.88l-0.93,-0.19l-1.68,0.7l-0.91,-0.02l-0.45,0.24l-0.04,0.54l1.25,2.17l-0.09,1.47l1.8,3.65l0.64,0.13l1.24,-1.3l-0.79,4.9l1.11,3.05l5.06,6.3l1.06,2.3l-0.06,3.28l-1.49,6.64l-1.46,1.56l-2.65,0.63l-2.45,4.79l-3.97,4.01l-2.76,0.83l-3.13,3.56l-2.01,0.52l-0.6,-0.43l-0.54,-2.17l-3.11,-5.5l-1.88,-0.18l-1.42,-1.7l0.84,-0.64l-2.38,-3.05l-1.38,-1l-1.37,-0.28l-1.74,1.67l-0.64,1.49l0.83,0.43l1.44,-1.57l1.07,0.16l0.89,0.71l2.87,4.33l0.86,0.66l1.16,3.52l2.41,5.29l0.25,1.15l-0.64,0.55l-3.8,-1.74l-0.95,0.74l-0.72,1.76l-1.34,-0.63l-4.2,-2.62l-3.1,-4.75l-1.45,-0.7l-1.68,0.79l-2.43,0.28l-5.78,-0.06l-0.26,0.27l0.43,1.2l-0.52,0.91l0.55,1.27l0.9,0.86l4.23,2.15l1.01,0.85l0.38,1.5l-0.75,2.13l-9.31,12.67l-1.89,1.85l-3.47,0.42l-2.62,-0.29l-6.3,-5.67l-0.64,-1.46l-3.08,-1.31l-2.98,-2.66l-2.95,-1.65l-1.74,0.05l0.86,1.34l-0.38,0.08l-2.03,-0.3l-1.79,-0.96l-1.77,0.13l-4.45,-0.99l-3.6,0.14l-0.14,0.25l1.27,1.17l2.19,1.41l-0.21,-1.53l0.73,-0.42l3.47,0.75l6.03,2.29l2.9,2.88l3.21,4.36l2.4,2.11l6.96,1.47l7.22,0.41l2.54,0.76l0.72,0.57l-0.01,2.86l-2.26,5.02l-5.42,8.89l-1.01,3.23l-0.97,1.25l-4.91,3.57l-1.48,0.35l-2.17,-0.86l-1.26,-1.62l0.83,2.71l-0.21,0.26l-2.44,-1.46l-0.87,0.52l-1.03,-0.33l-1.33,-1.41l-0.43,-1.66l-2.07,0.82l-0.34,0.27l1.13,0.96l0.88,2.53l-0.59,0.27l-2.21,-0.72l1.39,3.55l-2.08,3.28l-1.11,0.35l-1.48,-0.83l-0.56,0.08l-0.99,1.3l-2.14,0.18l-5.32,-2.78l-3.47,-0.64l-0.27,-0.31l0.24,-0.81l-0.48,-0.2l-1.01,0.77l-2.18,-0.07l-9.78,-4.91l-2.39,-2.42l0.89,2.18l-0.6,2.02l0.94,1.55l1.29,0.56l1.3,-0.06l-0.99,-1.2l-0.23,-0.84l0.25,-0.15l10.95,5.21l-2.76,2.75l1.57,-0.16l4.01,-2.71l1.4,0.76l3.19,3.08l3.23,1.28l2,1.82l0.32,0.95l0.11,4.77l-0.71,1.82l-3.02,0.99l-2.1,2.02l-0.89,0.29l-5.25,-1.17l-0.68,0.04l-0.77,0.64l-1.48,0.18l-0.15,0.92l0.65,1.19l1.4,0.91l1.73,0.4l0.18,1.02l-0.65,1.01l-2.35,-0.9l-0.49,0.43l-1.55,0l-0.48,0.35l-0.39,1.49l-1.55,1.74l0.02,0.58l1.24,1.37l0.89,2.13l-3.03,-2.65l-3.04,-1.13l1.95,1.52l0.74,1.36l-1.44,1.25l0.45,1.09l-0.51,0.61l-0.84,0.51l-1.63,0.07l-0.15,0.29l0.83,1.02l-0.54,0.54l-2.23,-0.17l0.79,1.81l1.63,1.51l-3.56,3.11l-1.82,2.27l-0.25,0.71l0.47,1.86l-0.48,0.67l-1.06,-0.18l-0.2,0.26l0.14,3.06l-3.96,9.83l-0.53,1.14l-0.99,0.08l-0.74,0.72l1.03,1.48L414.43,960.67zM364.8,732.88l-0.12,0.22L362,731.5l-0.52,-2.68l0.39,-0.65l1.81,0.56l1.41,1.48l-0.4,0.44L364.8,732.88zM484.88,743.05l2.69,0.2l0.87,2.33l-0.38,0.57l-1.58,0.5l-2.24,-0.91l-0.54,0.3l-1.32,-0.49l-1.19,-1.62l0,-0.58l1.94,-1.17L484.88,743.05zM390.52,755.3l0.28,0.31l0.92,-1.1h0.62l3.23,4.2l1.62,1l3.54,3.23l3.13,8.08l1.79,3.15l1.49,1.55l1.89,-1.42l0.95,1.64l-1.77,1.95l-1.97,0.28l-1.87,2.68l-1.16,0.49l-3.38,3.34l-1.77,0.24l-3.67,-1.9l-2.29,0.27l-1.87,-0.39l-3.71,-3.16l-3.13,-1.65l-0.77,-2.56l-1.96,1.1l-1.47,-0.11l-1.13,-0.89l-0.67,-2.33l-1.37,0.37l-0.3,1.35l-2.04,-0.32l-1.1,-1.03l-1.1,-2.91l0.97,-2.43l4.87,-0.92l1.69,-1.3l1.97,-2.25l0.48,-1.16l-0.97,-2.73l0.2,-0.42l0.79,-0.04l-0.77,-1.23l-0.1,-1.17l0.63,-0.16l0.78,0.36l1.5,2.06l1.62,0.71l-1.09,-1.42l-1.27,-4.04l0.59,-2.86l1.42,-1.38l2.6,-0.74l0.89,0.53l2.51,2.67l0.23,0.99l-0.75,0.86L390.52,755.3zM551.96,751.55l0.59,1.95l-1.68,2.1l-2.95,0.57l-1.49,-0.66l0.68,2l-0.06,1.19l-1.65,-0.67l-0.74,-1.47l-0.76,0.17l-1.06,-1.62l-2.96,-0.7l-0.15,-0.32l0.61,-1.32l0.66,-0.26l1.67,0.35l0.37,-1.57l1.89,-0.11l0.8,1.68l1.38,-0.04l3.38,-1.85L551.96,751.55zM564.52,753.44l0.54,1.96l-0.64,0.79l-3.86,2.72l-0.74,0.28l-0.98,-0.28l-1.67,0.51l2.42,-4l1.58,-0.3l0.52,-0.62l0.44,0.2l0.3,-1.28l0.55,-0.59L564.52,753.44zM655.19,757.91l-2.58,-1.01l-0.17,-0.93l2.08,-1.6l0.72,-0.08l0.71,0.18l0.67,1.12L655.19,757.91zM407.78,757.07l1.19,1.72l-0.51,3.27l-1.26,1.08l-1.36,-0.3l0.54,-1.38l-0.11,-2.51l-0.19,-0.97l-0.92,-0.58l-0.05,2.9l-0.73,2.43l-0.83,-1.02l-0.08,-1.98l1.07,-3.49l0.7,-0.51l0.82,0.04L407.78,757.07zM357.06,761.59l-0.87,0.17l-0.19,-1.29l0.74,-0.99l-1.34,-1.53l0.39,-0.93l1.92,0.91l0.88,2.02l-0.77,0.47L357.06,761.59zM573.79,768l-1.97,0.14l-0.96,-1.4l-0.51,-2.03l0.34,-3.3l1.38,-0.92l1.73,0.72l2.23,0.2l0.69,0.96l-0.17,0.98l-1.1,1.54l-0.91,2.33L573.79,768zM455.42,761.03l0.2,1.58l-0.81,2.13l-0.56,0.52l-1.45,-2.98l1.52,-1.5l0.62,0.28l0.22,-0.46L455.42,761.03zM553.93,775.45l-0.62,0.17l-0.73,-0.47l-0.4,-1.63l1.46,-3.15l0.88,-0.96l2.2,-1.21l0.86,-2.51l0.29,-0.43l0.98,-0.26l-0.24,-1.59l0.35,-0.66l1.72,-0.97l1.12,0.09l0.93,2.08l-2.73,3.99l-2.21,4.9l-0.66,0.87L553.93,775.45zM452.79,766.05l-0.73,0.29l-1,-1.96l-0.77,-0.14l0.26,-1.64l0.71,-0.43l0.57,0.16l0.54,1.1L452.79,766.05zM367.61,771.26l-0.21,1.49l-1.59,-0.94l-0.46,-1.53l0.84,-1.92l1.06,1.08L367.61,771.26zM365.62,776.41l-0.28,0.78l-1.33,1.27l-0.89,-1.69l-0.89,0.64l-0.13,-5.56l0.41,-0.92l1.36,-0.03l1.86,2.54l0.25,0.55L365.62,776.41zM351.02,781.84l-4.14,-2.35l2.1,-2.27l0.55,-1.27l1.66,0.66l0.85,1.13l0.01,2.5l-0.56,0.38L351.02,781.84zM592.74,787.64l-0.7,0.16l-3.95,-4.46l0.27,-2.71l0.74,-1.27l1.91,0.08l0.82,0.91l1.66,4.65l-0.29,0.42l0.11,1.14L592.74,787.64zM326.86,786.25l-1.42,-0.3l-1.36,-0.87l-1.71,-1.89l-0.09,-0.67l1.29,-0.56l2.74,0.5l1.41,2.22l-0.11,0.96L326.86,786.25zM555.97,791.41l-0.73,0.27l-0.99,-1.28l-0.01,-0.71l0.19,-1.71l1.8,-0.43l1.11,2.06L555.97,791.41zM585.62,788.28l4.68,2.14l0.68,1.47l0.14,2.35l-0.58,2.64l0.33,7.83l-1,4.12l-1.78,2.16l-3.41,1.93l-8.19,1.11l-2.24,-0.34l-1.18,-1.61l-0.73,-2.06l-1.32,-6.49l0.68,-3.91l0.92,-2.31l3.46,-6.82l1.29,-1.15l2.07,-0.96l1.72,0.24l2.75,-0.68L585.62,788.28zM487.73,802.32l-0.99,-0.34l-1.67,-2.05l-0.14,-1.55l0.55,-2.59l-1.01,-2.16l0.67,-2.17l1.64,-2.78l1.19,0.43l1.33,2.52l0.22,7.05l-0.84,2.5L487.73,802.32zM283.99,796.26l-0.34,0.08l-1.23,-1.42l0.26,-1.22l1.14,1.25L283.99,796.26zM604.03,801.19l-6.74,-0.14l-1.79,-0.93l-1.55,-3.72l0.35,-1.97l2.93,-0.63l4.47,1.71l3.47,0.51l0.52,0.73l0.25,4.21L604.03,801.19zM285.39,796.46l1.76,0.06l0.55,0.96l0.14,1.31l-1.81,-0.94l-0.59,-0.66L285.39,796.46zM296.75,810.16l-0.45,1.95l-1.81,-2.59l0.22,-4.67l0.7,-0.85l0.52,1.01l0.01,2.55l0.75,1.09L296.75,810.16zM702.1,818.16l-1.11,0.63l-0.59,-0.78l2.21,-2.63l1.87,-0.27l0.18,0.23l-0.79,1.02L702.1,818.16zM295.02,819.33l2.57,0.15l-0.25,1.77l-0.99,1.45L295.02,819.33zM518.85,835.65l1.57,0.24l0.15,0.33l-1.15,1.29l-1.38,-1.73l-0.21,-1.21L518.85,835.65zM513.45,846.37l2.3,1.34l2.11,0.44l-0.88,1.83l-1.46,-0.54l-1,-0.99l-0.38,0.95l-1.24,-0.24l-0.1,-0.89l0.86,-1.01l-1,-0.68l-1.75,0.79l-0.98,-0.44l-0.22,-3.15l-2.76,-3.27l-0.05,-0.92l0.44,-0.55l2.55,1.17l3.01,2.47l0.77,1l0.07,0.65l-0.64,1.3L513.45,846.37zM504.95,851.19l-0.97,0.11l-1.33,-2.58l-1.48,-1.46l-0.7,-4.1l0.22,-1.58l1.06,-0.22l0.83,0.37l1.62,3.29l1.39,4.4L504.95,851.19zM502.75,857.95l0.69,0.11l2.06,-4.11l1,-0.24l2.1,1.96l1.63,3.2l5.33,1.83l0.75,0.59l1.85,3.06l1.89,1.17l2.89,2.61l3.55,1.24l1.99,1.61l2.36,4.55l1,4.41l-0.04,1.38l-1.99,2.34l0.14,0.3l1.53,-0.11l3.41,-1.1l2.8,0.91l0.92,-1.42l0.83,0.22l2.33,3.23l-0.09,0.46l-0.8,0.16l1.95,0.78l1.7,1.24l-0.37,0.81l-5.84,5.68l-0.83,0.38l-8.22,-4.08l-3.72,-0.86l-0.8,-4.47l-0.94,-0.69l-4.15,-1.28l0.16,-2.13l-0.44,-0.66l-2.14,0.31l-2.51,1.76l-0.7,3.78l-0.6,1.2l-2.63,3.11l-1.07,0.93l-1.49,0.56l-1.78,3.93l-1.14,1.61l-2.95,2.23l-3.86,1.54l-0.92,-0.38l-1.96,-10.37l-0.49,-0.86l-4.78,0.88l-2.46,-0.11l-3.04,1.88l-2.12,-0.33l-0.33,-1.75l2.3,-4.65l4.58,-3.06l1.52,-1.75l-0.92,-4.94l-0.18,-3.93l1.67,-9.34l1.02,-11.21l1.01,-3.7l1.32,-2.79l2.32,-1.9l1.01,1.6l1.8,1.09l0.58,1.06l0.63,2.7l-1.21,2.43l1.65,1.57L502.75,857.95zM567.99,884.47l-0.65,0.94l-1.92,-0.33l-0.33,-0.63l0.31,-0.45l1.98,-0.43l1.27,0.11L567.99,884.47zM576.64,896.55l-0.95,0.2l-1.24,-0.45l-3.97,-3.65l2.07,-1.89l3.32,2.19l1,1.41L576.64,896.55zM565.89,895.02l0.76,0.86l0.79,-0.06l1.48,2.87l0.05,1.06l-1.12,1.37l-2.55,1l-2.81,-2.49l-2.52,-3.67l0.26,-0.55l2.44,-0.77L565.89,895.02zM528.92,905.27l0.46,1.38l-0.69,3.02l-0.79,1.52l-4.08,4.83l-4.01,3.72l-1.02,0.11l-2.22,-0.65l-2.89,1.49l-0.56,-2.75l-1.27,-1.91l-0.07,-1l1.54,-2.22l3.25,-6.57l0.78,-0.33l2.9,0.94l2.32,-1.39l2.21,0.17l2.02,-0.81L528.92,905.27zM633.48,913.2l-1.83,-0.07l-2.01,-0.87l-0.64,-1l-0.12,-1.1l-1.21,-1.63l-1.35,-0.55l-0.75,-1.14l3.46,0.66l3.51,2.08l1.56,3.04L633.48,913.2zM600.64,911.85l-2.27,-0.07l-2.21,-0.91l-1.08,-1.12l4.58,0.9l0.83,0.34L600.64,911.85zM682.9,913.01l2.77,0.13l0.45,0.31l0.42,0.94l-0.54,1.34l-1.61,0.66l-2.19,-0.72l-0.5,-0.72l0.23,-0.52l0.93,-0.39L682.9,913.01zM550.93,915.86l0.71,0.53l1.61,2.64l-0.34,4.24l-3.09,7.24l-0.85,0.91l-0.47,0.02l-4.03,-4.22l0.05,-5.54l0.73,-1.99l2.26,-3.47L550.93,915.86zM681.05,926.06l0.63,0.14l1.03,1.74l-0.46,0.88l-2.41,-1.22l-0.62,-1.9l0.22,-0.58l0.76,-0.26L681.05,926.06zM429.92,926.72l-0.37,0.04l-1,-1.46l1.08,-0.31l0.74,0.86L429.92,926.72zM682.82,935.72l-0.42,0.17l-0.67,-1l-3.94,-2.86l-0.34,-1.63l2.71,-0.68l3.05,0.44l1.08,1.3l-0.24,2.28L682.82,935.72zM560.02,947.51l-1.23,0.21l0.51,-1.01l3.32,-0.85l-0.33,0.64L560.02,947.51zM652.33,956.37l-0.81,0.14l-0.37,-0.38l-0.02,-1.1l2.51,-4.96l1.55,0.88l0.85,1.64l-0.93,1.99L652.33,956.37zM686.64,954.09l-0.31,1.25l-2.65,-1.41l-0.64,-0.63l-0.25,-1.64l1.71,-0.25L686.64,954.09zM546.28,964.78l-0.92,0.12l0.75,-1.57l1.15,-0.45l0.51,0.42L546.28,964.78zM544.3,967.39l-0.35,-0.16l0.23,-0.73l0.8,-0.89l0.38,0.28l-0.14,0.45L544.3,967.39zM644.03,977.63l-0.54,1.26l-1.18,0.12l0.44,-3.2l0.97,-0.02L644.03,977.63zM549.4,1003.58l-0.53,0.02l-0.3,1.2l-0.1,-1.65l0.69,-1.11L549.4,1003.58zM548.05,1015.8l-0.25,0.29l-0.44,-0.32l0.41,-1.45l0.64,0.36L548.05,1015.8zM551.17,1017.72l-0.53,0.19l0.24,-1.44l-0.29,-0.77l0.28,-0.29l0.63,1.38L551.17,1017.72zM556.4,1024.05l-2.15,6.11l-0.47,0.1l-0.41,-0.7l1.18,-3.42l-0.36,-1.22l-2.02,4.44l-0.79,0.96l-0.99,-0.01l-1.42,1.1l2.4,-4.58l-0.42,-0.56l-3.23,4.12l-0.93,-0.64l4.42,-6.67l0.51,-3.45l0.24,1.5l-0.94,4.31l1.29,-1.55l1.08,-5.24l1.33,1.31l0.41,1.08l1.03,0.52l0.51,1.64L556.4,1024.05zM547.05,1025l-1,-0.11l0.28,-1.18l1.84,-1.29l0.92,-0.15l1.52,-1.45l-0.97,2.26L547.05,1025zM557.37,1025.99l-0.78,0.2l1.03,-4.03l0.67,-0.9l0.5,0.01l-0.04,2.88L557.37,1025.99zM547.41,1070.02l-0.01,0.45l-0.58,-0.09l-0.63,-0.96l0.22,-0.3l0.67,0.18L547.41,1070.02zM540.29,1078.3l-0.63,0.2l-2.64,-0.68l-6.66,-2.64l-1.49,-0.78l-0.31,-0.59l1.72,-2.03l4.59,-0.57l1.79,0.28l3.32,4.21l0.49,1.36L540.29,1078.3zM552.37,1089.94l-1.22,-0.01l-1.1,-0.83l2.77,-1.28l0.57,0.17L552.37,1089.94z"
				},
				{
					"id":"CA-ON",
					"title":"Ontario",
					
"d":"M551.16,1104.76l0.06,46.05l-0.42,0.97l1.11,4.6l3.77,6.89l2.09,2.77l2.87,1.12l6.97,1.55l2.79,1.6l1.24,2.05l1.81,1.23l0.81,0.08l0.25,-0.96l0.8,-0.05l1.41,3.04l1.02,1.28l1.25,0.58l2.61,-0.11l1.09,0.27l0.87,0.81l2.49,-0.39l6.83,-2.44l2.57,0.13l1.62,0.82l-0.73,3.18l1.23,1.31l0,0l-3.3,2.67l-1.33,0l-2.89,1.32l-5.54,5.14l-2.33,1.55l-3.14,1.3l-2.51,0.55l-2.72,1.79l-0.45,0.04l-0.13,-0.44l1.27,-1.14l-0.87,0.56l-0.44,-0.65l-2.39,0.34l-2.32,1.04l2.26,-0.73l0.01,0.61l0.32,0.08l0.22,-0.51l1.4,-0.43l0.29,0.31l-0.17,1.27l2.15,-0.67l-1.62,1.84l1.56,-0.16l-0.08,0.27l-1.57,0.74l-1.38,0.09l0.16,-0.89l-0.69,0.32l-0.43,-0.31l0.5,-0.22l-2.19,0.02l-0.58,-0.56l0.17,-0.21l-1.19,-0.25l-0.4,0.44l-11.32,1.91l-3.65,2.6l-0.75,0.12l-1.04,1.04l-1.58,3.08l0.41,0.59l3.5,0.68l2.48,-1.04l-0.11,2.33l1.23,2.27l-1.08,0.55l-2.95,-0.22l-6.4,0.95l-1.08,0.34l-2.07,1.96l3.49,0.72l-0.28,0.09l-8.47,-1.41l-3.27,0.39l-2.92,2.22l-1.23,2.27l-0.07,-0.68l-4.82,2.55l-0.89,2.06l-1.2,-1.26l-2.61,0.37l-1.54,-0.78l0.31,-2.76l1.84,-1.03l2.89,-2.9l1.15,-4.78l2.95,-1.41l2.72,-2.38l0.4,-0.79l0.31,-2.04l-0.03,-7.1l1.28,-2.86l1.46,-1.26l1.12,-2.29l0,-1.84l-0.72,-1.53l0.03,-0.84l-0.86,-0.47l-1.25,-1.91l-1.04,-0.73l0.08,-0.35l3.7,0.13l-0.25,1.08l0.48,1.62l1.09,0.76l0.04,0.63l0.53,0.05l0.91,-0.71l-0.3,1.18l-1.11,1.34l1.5,-0.5l0.61,0.35l-0.13,2.05l1.07,-1.04l1.07,-0.34l0.69,1.11l1.19,0.76l3.37,1.11l0.69,-1.03l0.09,-1.01l-0.99,-1.94l1.6,-0.71l0.04,0.63l0.88,0.56l1.33,-0.01l-0.16,-1.34l-0.68,0.7l-0.51,-1.48l-0.66,-0.25l-1.65,-1.93l0.71,-0.56l-1.03,-0.89l0.64,-0.99l-0.07,-0.93l-1.07,-0.28l-0.01,0.67l-1.54,-0.7l-0.58,-2.81l-0.27,0.46l-0.6,-0.07l-2.75,-4.63l-2.5,0.12l-0.57,-0.17l-0.12,-0.79l-0.57,0.54l-1.91,-0.26l-1.32,0.36l-0.39,-0.95l0.88,-0.45l-0.66,-0.58l-1.34,0.79l-0.04,-0.6l-3.83,-0.38l-1.38,-0.76l-2.58,0.27l-0.73,-0.45l-2.75,0.33l-7.33,-1.56l-0.35,-0.4l-1.88,-0.36l0.04,-1.89l-0.7,-0.72l-2.39,0.53l-0.61,0.5l-0.61,-1.21l1.17,-1.91l-0.45,-0.27l-0.46,0.6l-0.12,-1.41l1.67,-0.97l-1.08,-0.84l-1.23,0.28l-1.35,-1.07l1.62,-4.16l-1.09,-1.4l-1.97,-1.5l-0.7,-1.31l1.43,-4.14l-6.81,0.12l-2.68,-1.19l-1.71,-2.42l-1.6,-5.22l-1.58,-2.26l-1.09,0.16l-1,-0.74l-1.14,0.48l-3.62,-0.04l-6.65,-2.48l-0.51,-0.54l-2.02,0.18l0.21,1.61l1.04,1.24l-0.27,1.26l-0.85,1.16l-1.89,0.5l-0.51,1.26l-0.52,0.27l-0.06,-1.09l2.18,-2.85l-0.65,-1.44l-0.96,0.16l-0.42,2.37l-0.68,0.8l-0.98,2.9l-1.78,0.65l1.42,-3.34l-3.82,1.78l-0.19,1.88l-1.11,2.54l-0.83,0.3l-1.25,1.3l-3.73,-0.18l-0.88,-1.38l-5.85,0.18l-0.86,-1.29l-0.68,-0.12l-1.14,0.21l-3.08,1.81l-1.17,0l-3.05,-1.87l-1.32,-1.4l-1.49,-0.49l-1.14,0.13l-0.45,0.7h-0.59l-0.77,-2.13l-4.44,-2.38l-3.41,-0.07l-0.78,0.76l-2.19,0.48l-0.86,-0.32l-0.43,-0.79l-1.83,-0.7l-5.07,-1.13l-0.75,-0.89l-0.88,-2.64l-0.46,-4.12l-0.76,-0.62l-1.94,-0.28l0,0l0.01,-49.18l13.75,-13.85l20.1,-24.19l21.78,-24.6l0,0l1.09,0.61l3.4,3.35l3.33,2.29l5.31,7.18l5.05,1.71l8.38,3.48l2.76,1.5l2.42,2.68l1.7,1.29l0.05,0.81l-1.37,3.42l1.36,-2.27l1.37,-0.96l4.87,0.42l5.44,-0.88l6.24,1.57l2.04,-0.26l1.06,1.11l2.6,0.19l1.65,1.27l0.76,1.09l0.8,2.87l-1.78,7.06l-0.05,1.71l1.65,3.05l0.88,3.45l-0.44,3.12l0.28,5.21l-0.9,1.56l-0.28,1.92l0.28,1.04l2.16,2.21l3.77,5.58l0.25,0.96l-0.36,0.63l-1.94,1.46l2.5,-0.18l0.75,0.47l1.62,1.68l2.84,1.7l2.78,3.1l1.92,5.32l-3.66,3.77l3.34,-2.6l0.99,-0.32l0.92,0.19l1.45,0.48l2.4,1.56L551.16,1104.76zM551.15,1104.09l-1.74,-2.16l-0.21,-0.98l0.44,-2.29l1.5,-2.84l0,0L551.15,1104.09zM474.86,1135.26l-0.4,-0.31l0.17,-1.3l1.27,-0.38l1.34,0.32l-0.46,0.99L474.86,1135.26zM478.53,1134.73l-0.98,0.03l-0.16,-1.08l0.73,0.18L478.53,1134.73zM496.06,1148.47l-1.73,0.19l-0.83,-0.38l0.61,-0.58l1.05,-0.21l1.52,0.66L496.06,1148.47zM512.71,1168.98l-0.61,0.24l-0.28,0.65l-0.64,-0.16l-1.06,-2.3l0.32,-0.29l1.53,0.33l0.86,0.9L512.71,1168.98zM516.98,1172.67l-0.49,0.15l-0.84,-0.49l0.79,-1.05l1.09,0.35L516.98,1172.67zM521.56,1171.43l-0.02,0.86l0.52,0.66l0.94,-0.02l1.16,0.69l0.1,-0.55l-0.54,-0.6l0.48,-0.55l1.75,-0.56l1.7,1.45l0.79,-1.1l1.04,-0.31l0.88,1.21l0.33,1.82l0.95,-1.93l0.3,0.28l-0.18,0.9l0.83,0.13l-0.83,1.73l-1.28,1.4l-0.48,0.14l-0.86,-0.44l1.01,-0.52l0.94,-1.11l-2.65,1.74l-1.8,-1.26l-3.32,-1.43l-2.79,-0.5l-2.56,-1.17l0.41,-0.86l0.71,0.43L521.56,1171.43zM530.82,1177.97l-0.37,-0.41l1.04,-0.37L530.82,1177.97zM545.29,1186.29l-0.56,-0.7l0.58,0L545.29,1186.29zM579.44,1194.46l-0.52,0.43l-0.55,-0.08l-0.07,-0.43l0.55,-0.81l1.82,-0.34L579.44,1194.46zM576.55,1194.69l-1.09,-0.03l1.5,-0.74L576.55,1194.69zM523.2,1223.87l-0.42,0.13l0.27,-1.1L523.2,1223.87z"
				},
				{
					"id":"CA-PE",
					"title":"Prince Edward Island",
					"d":"M691.98,1165.07L692.64,1164.92L693.14,1163.86L695.16,1164.62L695.95,1164.56L698.09,1165.68L706.75,1164.83L708,1165.68L703.5,1168.51L703.34,1170.76L703.93,1171.13L703.45,1171.42L701,1171.47L700.34,1171.11L700.12,1170.25L699.05,1170.27L700.2,1169.54L699.67,1168.61L699.12,1168.68L698.75,1168.24L698.78,1167.65L699.44,1167.05L696.82,1168.55L697.88,1168.7L697.34,1169.07L693.5,1168.16L692.07,1166.39L692.45,1165.99L689.29,1165.63L689.07,1163.37L686.81,1162.84L686.67,1162.17L687.11,1161.16L690.34,1157.34L690.45,1159.28L689.5,1161.08L691.16,1162.86L691.51,1163.73L691.13,1164.55z"
				},
				{
					"id":"CA-QC",
					"title":"Quebec",
					
"d":"M684.78,955.19l-2.08,1l0.51,0.99l1.5,0.99l-0.25,0.56l-2.13,1.34l0.48,0.89l1.55,1.15l-1.16,1.89l-0.24,4.88l0.93,1.3l2.42,-1.09l0.53,0.23l0.06,0.7l-1.12,1.35l-0.15,3.03l0.37,1.91l1.38,1.67l-0.62,0.37l-3.38,-0.87l-0.56,0.5l-0.14,1.23l4.97,1.44l0.92,1.68l4.17,-1.61l1.21,0.55l0.85,1.32l-4.16,1.19l-0.99,0.73l0.08,1.49l1.61,-0.01l0.31,1.64l-2.24,1.72l-2.66,3.65l0.07,0.77l1.44,1.38l1.62,3.91l0.75,-0.28l1.5,1.61l0.7,0.17l1.02,-0.46l-0.12,0.9l-1.29,1.94l0.15,2.61l-0.52,1.28l0.38,1.51l-1.06,3.37l-0.24,2.19l-1.9,2.97l1.7,3.77l-0.26,0.59l-1.62,0.72l0.13,1.54l1.99,1.4l-0.83,1.09l-0.11,0.76l3.82,1.15l0.18,0.53l-1.25,1.1l-0.02,1l2.56,4.21l0.99,0.85l1.35,0.45l0.38,2.74l-3.79,3.13l-0.15,0.85l0.67,1.94l-2,5.38l-1.89,-0.29l-3.86,-1.43l-7,0.11l-4.97,-0.4l-1.08,-0.93l-0.78,-1.59l-2.45,-0.94l-5.53,-5.64l-0.21,0.54l0.65,1.27l-0.2,1.32l0.87,5.15l-0.66,0.78l-1.28,-0.51l-2.69,-2.43l-1.21,-1.97l-0.95,-0.13l-0.07,1.37l2.41,5.13l-0.03,0.56l-0.77,0.48l-0.44,1.03l-2.25,-0.83l-0.58,0.31l-0.07,1.56l0.88,3.31l-2.24,2.68l2.6,4.01l-0.02,2.77l2.77,1.06l0.8,1.89l1.18,0.93l-0.23,4.21l-0.75,2.27l-0.13,2.44l1.05,0.84l1.22,0.17l1.13,-0.6l0.66,-3.03l0.84,-0.4l0.48,-0.89l0.36,0.12l1.15,1.69l-1.13,3.49l0.29,3.57l-0.61,1.81l0.49,1.62l0.56,0.42l0.59,-2.13l1.64,1.33l0.55,1.46l1.37,0.8l0.5,0.03l0.42,-0.75l1.72,0.45l1.23,-1.89l2.82,0.7l1.84,1.45l2.74,3.33l-0.68,1.16l0.94,2.09l0.82,-0.12l1.94,-1.73l-0.4,-1.63l0.57,-3.5l1.26,-1.51l0.25,-2.8l-0.72,-2.58l0.04,-3.85l0.35,-0.58l1.49,-0.6l0.61,-2.7l1.64,-0.48l0.46,0.13l1.05,2.03l0.04,2.82l1.26,1.26l-4.38,1.47l-1.44,1.53l-0.02,0.4l0.99,0.42l0.14,0.7l1.52,1.22l0.91,3.46l-1.09,0.14l0.26,0.58l59.67,0.14l0.01,8.05l0,0l-1.79,-0.5l-1.46,0.13l-2.76,0.62l-2.27,1.49l-4.37,0.39l-5.87,7.32l-1.91,1.48l-2.1,2.58l-1.82,1.04l-0.64,1.43l-1.74,0.87l-4.73,0.47l-1.78,-0.4l-1.34,0.62l-2.99,0.05l-3.9,1.37l-1.75,-1.8l-7.14,-0.96l-3.77,0.11l-0.92,0.72l-3.12,-0.22l-2.4,-0.79l-2.84,0.63l-3.03,-0.55l-3.22,0.47l-3.59,-0.62l-4.43,0.85l-1.73,-0.49l-1.53,1.3l-3.32,-0.15l-2.2,2.04l-1.79,1l-2.63,5.43l-0.25,2.07l-0.99,1.41l-6.13,1.26l-2.02,0.82l0.55,0.65l-2.9,1.28l-1.12,1.59l-2.33,1.5l-2.71,3.46l-1.29,2.52l-1.57,1.82l-1.11,0.69l-1.59,-0.11l-4.77,-2.14l-5.69,-1.2l1.61,1.19l3.03,0.18l5.69,2.45l0.81,0.99l-1.17,3.55l-0.8,1.23l-4.07,4.19l-2.31,3.74l-3.67,2.82l-1.36,1.69l-4.39,1.59l-1.1,-0.17l-2.91,1.67l-0.47,0.96l-3.8,2.56l-2.7,1l-0.37,1.15l-1.11,0.7l-2.97,4.21l-2.11,0.35l-1.66,1.88l-1.26,0.79l-2.49,-0.37l2.83,1.25l0.23,1.12l-1.11,0.27l-2.17,1.39l0,0l-1.23,-1.31l0.73,-3.18l-1.62,-0.82l-2.57,-0.13l-6.83,2.44l-2.49,0.39l-0.87,-0.81l-1.09,-0.27l-2.61,0.11l-1.25,-0.58l-1.02,-1.28l-1.41,-3.04l-0.8,0.05l-0.25,0.96l-0.81,-0.08l-1.81,-1.23l-1.24,-2.05l-2.79,-1.6l0,0l0,0l0,0l-6.97,-1.55l-2.87,-1.12l-2.09,-2.77l-1.35,-2.88l-1.79,-2.55l-1.63,-5.07l-0.11,-1l0.42,-0.97l-0.06,-46.05l0,0l1.54,2.21l-1.55,-2.88l0,0l-0.01,-8.27l0,0l1.64,-1.2l0.37,0.08l0.29,1.02l2.01,1.27l1.23,3.77l0.4,-2.63l1.14,-1.63l-2.21,-3.4l-0.04,-0.59l0.48,-0.35l0.89,-2.38l1.13,-1.01l1.48,-2.63l0.8,-0.7l-0.7,-0.72l-0.28,-2.66l-1.68,-2.41l-0.19,-1.54l0.39,-1.43l-1.58,-2.77l-1.81,-9.19l-0.12,-0.92l0.65,-1.52l0.85,-0.21l-1.16,-1.53l0.71,-1.07l-0.64,-0.75l-1.57,-0.71l0.56,-0.28l0.29,-0.8l-1.88,-1.44l-2.17,-5.2l-1.03,-1.08l11.09,-5.27l6.27,-4.39l5.47,-5.88l3.62,-5.3l1,-1.78l0.93,-4.05l0.24,-5.65l-0.48,-7.78l-2.85,-9.6l-2.38,-4.39l-3.55,-3.74l-4.13,-2.72l-3.03,-3.11l-1,-0.37l-0.47,-1.37l0.76,-3.79l3.25,-5.19l2.02,-1.83l0.74,-1.32l-0.88,-1.68l1.13,-1.86l0.07,-1.68l1.22,-0.08l1.74,1.97l0.43,-0.17l-1.22,-1.87l1.38,-1.99l-0.37,-2.29l0.75,-1.73l-0.2,-0.36l-2.11,-0.34l-0.35,-0.48l1.19,-1.04l-2.05,-5.08l0.75,-1.45l0.85,-0.65l-0.11,-0.37l-1.79,-0.27l-0.68,-1.13l1.17,-2.74l0.64,-0.35l-0.12,-0.3l-2.41,0.72l-1.13,-0.59l-1.64,-0.02l3.15,-4.88l0.89,-2.27l-0.05,-4.31l1.99,-2.23l-3.37,-3.25l-1.18,-1.96l-1.13,-7.19l0.71,-2.82l4.16,-3.4l2.08,-0.8l4.42,0.92l9.53,4.05l1.27,1.28l-1.2,1.08l0.17,0.27l2.7,-2.05l1.32,-0.49l2.86,0.92l3.5,2.85l-0.51,-1.3l0.4,-0.53l8.43,-5.05l3.64,2.86l3.74,3.83l1.75,0.02l0.49,1.86l-1.25,3.55l0.4,0.03l1.99,-1.6l2.51,1.73l1.67,2.86l-0.38,0.73l-1.48,0.74l0.28,0.28l1.73,-0.46l1.41,-1.44l2.04,1.35l0.17,0.83l-1.22,0.87l-0.88,1.63l1.87,0.5l-0.78,0.77l-0.1,0.65l2.88,3.32l2.22,0.23l4.05,1.69l1.64,0.23l2.34,-0.48l1.09,0.89l0.11,1.82l0.45,0.76l0.92,0.44l2.55,-1.07l0.76,-2.49l0.6,-0.19l0.48,0.36l0.8,2.18l0.09,1.39l-2.11,2.88l-0.99,3.69l0.1,2.81l1,2.41l-0.4,2.21l-1.09,0.83l-1.5,0.21l-6.2,-0.15l0.31,0.75l7.3,0.71l0.64,0.48l0.93,1.71l0.46,2.61l-1.01,3.3l0.09,2.58l2.53,0.07l0.5,0.61l-0.95,2.15l0.33,1.63l-1.05,3.78l-1.05,0.84l-1.22,-2.34l-0.75,1.73l-2.62,1.15l0.05,0.5l3.27,1.23l4.65,-3.36l5.14,-0.36l2,1.4l0.84,1.38l0.49,2.55l0.66,0.67l0.21,1.23l-0.04,1.46l-1.1,4.02l-1,1.47l-4.28,1.82l-0.86,1.12l2.33,-1.24l2.56,-0.6l0.73,-0.68l1.12,-2.13l1.02,-3.83l0.58,-1.21l0.81,-0.21l1.19,3.24l-1.57,2.66l1.86,-2.27l0.9,-2.25l0.59,2.74l0.1,4.28l0.97,-3.77l4.93,-3.74l2.67,-0.99l1.02,-0.99l0.83,-2.55l1.37,-1.62l1.12,0.33l1.31,1.95l0.79,3.91l0.71,-2.41l-1.08,-4.28l1.69,-0.45l0.17,-0.24l-0.76,-0.94l0.71,-1.08l1.24,0.11l-0.16,-0.92l1.59,0.21l0.16,-0.42l1.17,-0.04l0.11,-0.38l-2,-0.88l-0.84,-1.79l0.35,-0.29l0.48,0.29l0.85,-2.41l0.91,0.62l-0.57,-2.73l1.12,-0.15l2.47,1.77l0.32,-0.17l-1.19,-1.31l-2.12,-1.36l-0.71,-1.93l0.48,-2.27l1.3,-0.74l2.1,1.16l0.24,-0.32l-1.17,-1.06l-0.11,-1.39l2.16,-6.17l1.02,-1.43l1,-0.09L684.78,955.19zM710,1130.15l-3.75,0.2l-7.37,-1.99l-4.7,-2.39l-1.89,-2.79l-5.95,-3.12l-0.41,-0.82l1.01,-0.54l2.17,-0.22l7.53,1.73l3.89,1.54l9.33,5.81l1.08,1.98L710,1130.15zM666.04,1144.62l-1.98,0.79l-0.24,0.85l-0.95,-0.25l-2.24,0.42l-0.52,0.43l-1.92,-1.13l-0.3,-0.79h-4.49v0.92h-2.37l-0.01,4.53l-0.45,0.8l-1.78,1.42l-3.81,1.66l0,0l0.03,-1.74l-1.73,-0.48l-6.86,9.9l-0.53,3.48l-1.62,2.46l-0.5,2.5l0.07,1.95l-1,1.34l-0.12,0.82l-2.52,2.39l0.11,1.57l-0.98,0.3l-0.59,1.7l-0.3,0.1l-0.91,-0.95l-1.21,0.94l-1.73,-0.35l-0.82,1.14l-0.88,2.44l-28.61,0.05l3.94,-2.33l1.97,-0.67l2.56,-1.96l1.85,-0.38l0.83,-2.64l2.74,-4.84l1.52,-1.21l2.3,-1.01l2.13,-2.21l2.3,-1.16l1.17,-1.42l1.87,-1.05l2.06,-0.28l3.68,-1.34l0.98,-0.82l5.67,-2.79l4.03,-4.54l0.47,-1.24l3.91,-4.67l0.99,-1.91l1.48,-1.07l2.86,-3.05l3.9,-2.45l2.81,-2.28l6.07,-3.11l8.63,-3.68l3.76,-1.19l5.87,-0.73l6.16,1.02l2.41,1.19l3.15,3.15l0.07,0.92l-2.73,-0.47l2.4,2.03l-0.07,1.9l-0.85,1.71l-2.55,0.84l-1.69,2.2l-3.92,2.35l-1.94,-0.14l-4.04,-2.11l-1.4,1.15l-3.28,-0.23L666.04,1144.62zM708.98,1154.41l1.27,0.33l-0.55,0.49l-1.56,-0.15l0.75,-2.52l3.38,-2.73l1.37,-0.08l-0.72,0.98l-0.96,0.05l-0.91,0.81l-1.82,2.04L708.98,1154.41zM627.3,1159.81l-0.82,0.11l1.31,-1.26l1.3,-0.44L627.3,1159.81zM604.53,1177.92l-3.53,0.35l0.96,-0.95l1.48,-0.58l1.48,-1.79l0.42,-0.05L604.53,1177.92zM603.37,1176.44l-1.46,0.15l1.19,-1.26l1.37,-0.29L603.37,1176.44z"
				},
				{
					"id":"CA-SK",
					"title":"Saskatchewan",
					
"d":"M355.31,1131.52L277.92,1131.52L277.92,1131.52L277.92,960.68L277.92,960.68L349.62,960.68L349.62,960.68L349.63,1031.23z"
				},
				{
					"id":"CA-YT",
					"title":"Yukon",
					
"d":"M40.86,774.22l-0.02,27.85l0.4,1.91l1.5,1.54l0.57,2.02l-0.07,2.14l0.65,2.76l-1.01,2.85l-0.05,2.14l0.48,1.68l18.95,0.25l0.22,1.38l2.13,2.86l-0.1,1.94l0.38,1.87l1.15,1.92l-0.17,2.53l-0.77,0.29l-0.54,2.55l0.09,0.47l1.86,0.43l0.13,2.41l-0.97,1.79l0.5,2.67l1.88,0.41l1.64,-1.1l2.61,-0.5l0.19,0.59l-0.46,1.49l0.59,0.44l0.73,-0.32l1.86,-2.23l1.17,0.89l1.01,-0.1l0.25,0.32l0.02,0.52l-1.78,1.52l-0.14,0.64l2.33,3.08l0.9,2.57l-1.35,3.33l-1.76,2.21l-0.5,1.3l-1.48,1.18l-0.1,0.46l0.58,0.77l1.15,-0.37l0.35,0.31l0.22,1.62l1.47,0.79l-1.29,2.11l-0.07,1.56l-0.86,1.22l0.12,0.67l2.4,0.66l1.92,1.27l1.91,2.61l1.47,0.9l-0.61,3.03l1.89,0.16l2.04,-1.62l2.26,1.19l1.73,4.3l-0.15,1.38l1.54,2.71l4.26,3.47l1.48,0.59l-0.03,0.41l-1.24,0.72l-0.39,0.68l0.53,0.51l1.19,-0.34l0.43,1.2l0.78,0.4l0.79,1.22l0.38,1.39l-0.54,1.6l-1.76,1.74l-0.29,0.84l2.04,1.77l0.7,1.9l1.93,0.65l-0.92,2.53l-0.04,1.94l0.88,2.34l0.85,0.76l0.31,1.46l2.7,2.1l-0.96,1.26l0.51,1.01l-0.48,1.52l0.54,1.43l-0.2,1.29l1.06,0.52l2.05,0.12l0.84,1.06l1.21,-0.93l1.06,-0.09l1.44,1.59l1.74,3.21l1.43,0.98l0.48,1.93l1.67,1.74l1.78,1.61l2.77,0.39l1.19,0.89l0.84,1.78l0.46,2.48l-0.05,2.05l-0.59,1.04l0.34,0.36l0.99,-0.02l0.76,5.21l1.74,0.13l1.3,-0.7l2,0.29l0.56,-0.45l0.11,-0.86l0.55,-0.18l1.42,1.05l0.93,-1.5l1.72,0.92l3.45,0.88l1.53,-0.95l2.43,-0.29l0.66,-1.85l2.01,0.15l0.7,3.02l-0.95,1.6l0.11,0.71l1.76,3.06l1.38,0.38l0.21,0.38l0.37,2.39l1.68,3.5l-0.12,1.44l1.18,0.11l0.54,0.69l0,0l-136.6,-0.01l0,0l-1.15,-1.47l0.95,-4.69l-5.35,0.28l-2.66,2.62l-4.3,-2.1l-0.65,1.47L0,955.3V755.09l5.35,1.24l3.84,-0.5l7.13,2.72l4.41,5.06l7.35,5.65l5.46,3.22l1.7,0.33l3.17,1.54L40.86,774.22zM17.56,756.99l-0.74,0.96l-1.48,-1.5l1.36,-1.33l0.6,0.05l1.74,1.49L17.56,756.99z"
				}
			]
		}
	}
};