﻿// (c) ammap.com | SVG (in JSON format) map of Oman - Low
// areas: {id:"AE-SH"},{id:"AE-DU"},{id:"AE-FU"},{id:"AE-RK"},{id:"AE-NZ1"},{id:"AE-NZ2"},{id:"OM-BAN"},{id:"OM-BAS"},{id:"OM-BU"},{id:"OM-DA"},{id:"OM-MA"},{id:"OM-MU"},{id:"OM-SHN"},{id:"OM-SHS"},{id:"OM-WU"},{id:"OM-ZA"},{id:"OM-ZU"}
AmCharts.maps.omanLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"51.880933",
				"topLatitude":"26.388573",
				"rightLongitude":"59.840216",
				"bottomLatitude":"16.641322"
			}
		},
		"g":{
			"path":[
				{
					"id":"AE-SH",
					"title":"Ash Shāriqah",
					"d":"M254.06,101.03l-0.22,1.29l0,0l-0.43,0.86l0,0l-0.19,-0.09l0,0l-4.45,-0.88l-0.86,-1.08v-0.97l1.19,-0.97l0.11,-2.05l-0.86,-1.73l-0.86,-1.08l-0.11,-0.97l0,0l0.03,-0.71l0,0l1.05,-0.15l1.29,0.54l0.97,1.4l0,0l0.56,0.56l-0.03,0.59l0,0l-0.09,0.93l1.5,1.48l0,0l0.19,0.01l-0.84,0.96l0,0l0.11,1.19l0,0L254.06,101.03zM256.11,77.96v0.97l-0.97,0.54l-0.97,-0.43v-0.86l0.97,-0.65L256.11,77.96zM258.34,70.61l1.34,-1.2l0,0l0.03,1.93l-0.42,1.28l-0.43,0.09l-0.11,0.41l0.1,0.53l0.45,0.51l0.48,-0.09l-0.19,-0.41l0.19,-0.14l0.15,0.41l0.45,0.28l-0.13,0.39l0.42,0.39l-0.27,0.35l0.31,0.42l-0.66,0.55l0.11,0.25l0,0l-2.23,1.64l0,0l-0.09,-1.76l0,0l-0.43,-1.4l0.32,-1.62l-0.18,-1.81l0,0L258.34,70.61zM259.81,94.79l0.06,1.02l-0.35,-0.19L259.81,94.79zM259.41,90.89l0.21,2.98l0.27,0.6l-0.47,1.18l0.39,0.34l0.48,1.82l0,0l-1.22,0.13l0,0l-0.62,0.23l-0.4,0.94l0,0l-0.76,-0.45l0,0l-1.44,-0.19l0,0l0.15,-3.47l-1.19,-2.05v-1.19l0.86,-0.86L259.41,90.89z"
				},
				{
					"id":"AE-DU",
					"title":"Dubayy",
					"d":"M249.8,107.52L249.34,109.52L249.34,109.52L248.99,110.56L247.71,110.94L247.26,112.57L246.94,112.82L245.5,113.28L243.72,113.16L242.48,112.82L241.95,112.36L241.95,112.36L243.73,110.34L244.69,107.82L244.69,107.82L245.01,107.78L245.01,107.78L245.77,107.54z"
				},
				{
					"id":"AE-FU",
					"title":"Al Fujayrah",
					"d":"M260.21,76.61l-0.11,2.55l-0.66,3.15l-0.26,4.21l0.23,4.37l0,0l-3.73,0.01l-0.86,0.86v1.19l1.19,2.05l-0.15,3.47l0,0l-0.18,-0.02l0,0l-0.86,-0.32l0,0l-2.16,-0.11l0,0l-1.5,-1.48l0.09,-0.93l0,0l0.03,-0.59l-0.56,-0.56l0,0l-0.97,-1.4l-1.29,-0.54l-1.05,0.15l0,0l0.08,-1.88l0,0v-4.53l0.75,-2.48l0.11,-1.19l2.13,-1.1l0,0l0.25,0.4l0.6,0.27l0,0l2.08,0.41l0.82,-0.12l0,0l1.93,-1.43l0,0l0.39,-0.28l0,0l0.82,-0.53l0,0l0.27,-0.69l0,0l0.29,-1.29l0,0l2.23,-1.64l0,0L260.21,76.61zM255.17,105.37l-0.25,0.32l0,0l-0.69,-1.86l-0.4,-0.46l0,0l-0.4,-0.19l0,0l0.43,-0.86l0,0l0.18,-1.07l1.55,-0.22l1.51,0.11l0,0l1.25,0.42l0,0l0.07,0.8l0,0l-0.04,0.5l0,0l-0.79,0.66l0,0l-1.79,0.47l0,0l0,0l0,0l-0.46,1.13l0,0L255.17,105.37zM247.61,54.44l1.56,-0.23l0.97,0.81l0.24,0.73l0.97,1.05l1.44,0.4l0,0l1.35,-1.21l0.4,1.12l0.79,0.67l0.21,-0.16l0.45,-0.16l-0.19,-0.32l3.38,1.26l0.02,3.09l0.82,1.35l-0.64,2.47l0.27,1.01l-0.29,2.2l0.11,0.51l0.27,0.09l-0.06,0.3l0,0l-1.34,1.2l0,0l-1.38,1.54l-2.67,1.17l-0.4,0.97l0,0l-0.27,1.63l-1.45,0.71l-1.67,0.18l0,0l-0.68,-0.39l0.31,-0.74l-2.22,-0.62l-0.76,0.07l-1.51,1.12l-0.13,0.62l1.43,-0.11l0.5,0.64l1.43,0.07l0.14,0.21l-0.6,1.01l-1.85,0.51l0.18,2.25l-0.63,0.18l-0.37,0.92l-0.42,0.23l-1.26,-0.05L242.75,82l-1.45,0.67l-1.45,-0.64l-2.08,0.04l0,0l0.34,-1.59l-0.85,-2.02l0.66,-0.62l0.53,-0.09l0.58,-0.64l-0.27,-1.22l-1.16,-0.6l1.05,-3.14l0,0l0.72,0.62l0.42,0.81l3.93,1.17l0.97,-0.35l0.68,-1.19l1.32,0.21l0.32,-1.04l-0.11,-1.68l-2.08,0.28l-0.56,-0.28l-0.35,-0.87v-0.32l1.63,-1.58l0.68,-1.22l-0.02,-0.35l-1.71,-1.97l-0.68,0.11l-1.54,0.96l-1.22,-0.16l-1.96,0.21l-1.45,-0.44l-0.79,-3.49l0.21,-0.43l-0.5,-1.49l0.06,-0.91l0.58,-0.6l1.85,0.27l1.4,-0.57l0.48,-1.21l1.56,-1.31l1.05,0.6l1.42,-0.8l1.35,0.07l0.74,-0.23l0.55,-0.58l0,0L247.61,54.44z"
				},
				{
					"id":"AE-RK",
					"title":"Ra’s al Khaymah",
					"d":"M241.03,36.81l-1,2.65l-0.18,-0.3l0.92,-2.24L241.03,36.81zM237.77,82.07l2.08,-0.04l1.45,0.64l1.45,-0.67l1.32,0.73l1.26,0.05l0.42,-0.23l0.37,-0.92l0.63,-0.18l-0.18,-2.25l1.85,-0.51l0.6,-1.01l-0.14,-0.21l-1.43,-0.07l-0.5,-0.64l-1.43,0.11l0.13,-0.62l1.51,-1.12l0.76,-0.07l2.22,0.62l-0.31,0.74l0.68,0.39l0,0l-0.5,1.31l0.4,3.08l0,0l0.08,0.29l0,0l-2.13,1.1l-0.11,1.19l-0.75,2.48v4.53l0,0l-0.11,2.59l0,0l0.11,0.97l0.86,1.08l0.86,1.73l-0.11,2.05l-1.19,0.97v0.97l0.86,1.08l4.45,0.88l0,0l0.6,0.28l0,0l0.4,0.46l0.69,1.86l0,0l-0.33,0.35l0,0l0,0l0,0l-2.28,0.8l0,0l0,0l0,0l-1.83,0.11l0,0l-0.67,0.56l0,0l-4.03,0.02l-0.76,0.25l0,0l-0.61,-0.05l0,0l-0.9,-1.02l0,0l-1.84,-1.73l0,0l-0.04,-0.43l0,0l-0.53,-1.34l0,0l-0.03,-0.99l0,0l-0.29,-2.17l-0.62,-1.34l0,0l-0.59,-0.37l0,0l-1.25,-0.57l-1.1,-0.07l-0.24,-1.42l-1.38,-2.33l0.13,-1.06l-0.26,-1.52l1.53,-3.52l0.51,-0.51l-0.61,-1.11l-1.14,-1.11l0.06,-1.29l0.18,-0.34l1.67,-0.76L237.77,82.07zM241.74,35.1l0.11,0.3l-0.55,0.27l-0.4,1.14l0.56,-1.89L241.74,35.1zM247.75,27.75l0.61,0.8l0.31,1.45l0,0l-0.23,2.73l0,0l0.25,1.14l-0.64,4.67l0,0l-1.09,4.25l0,0l-0.12,2.19l0.9,2.31l-0.44,1.15l-0.18,1.73l0.09,3.36l0,0l0.14,0.53l0,0l0.23,0.33l0,0l-0.55,0.58l-0.74,0.23l-1.35,-0.07l-1.42,0.8l-1.05,-0.6l-1.56,1.31l-0.48,1.21l-1.4,0.57l-1.85,-0.27l-0.58,0.6l-0.06,0.91l0.5,1.49l-0.21,0.43l0.79,3.49l1.45,0.44l1.96,-0.21l1.22,0.16l1.54,-0.96l0.68,-0.11l1.71,1.97l0.02,0.35l-0.68,1.22l-1.63,1.58v0.32l0.35,0.87l0.56,0.28l2.08,-0.28l0.11,1.68l-0.32,1.04l-1.32,-0.21l-0.68,1.19l-0.97,0.35l-3.93,-1.17l-0.42,-0.81l-0.72,-0.62l0,0l-1.29,-0.71l-0.9,0.27l-0.18,2.25l-0.93,1.7l-1.96,-2.87l-1.24,-0.99l-0.95,-0.39L231,71.14l1.48,-1.51l-0.06,-0.51l-3.12,-2.96l-0.32,-0.83l0.06,-3.81l-1.51,-3.09l-0.39,-2.34l-0.26,-0.32l-1.96,-0.03l-0.96,-1.33l1.45,-2.02l0.85,0.2l-0.24,-0.2l0.05,-0.34l0.55,0.09l0.1,-0.3l-0.69,-0.27l-0.11,0.44l-0.43,0.25l1.37,-2.03l0.23,0.21L227,50.79l1.88,0.11l1.32,-0.3l0.89,-0.52l1.53,-1.28l2.2,-2.56l0.53,-0.68l0.26,-0.92l0.23,1.37l-0.79,0.73l-0.06,0.44l0.27,0.05l0.02,-0.34l0.26,0.2l-0.03,-0.28l0.53,-0.34l0.23,0.27l0.32,-0.07l-0.08,-0.41l-0.58,-0.32l0.69,0.09l0.08,-0.3l-0.82,-0.07l-0.03,-0.91l1.17,-0.92l1.85,-3.02l-1.35,2.49l-0.84,0.87l0.76,-0.2l1.37,-2.61l0.35,0.02l0.27,-1.46l1.06,0.2l0.23,-0.2l0.27,0.21l0.24,-0.18l0.03,-1.25l0.47,-0.39l-0.16,-1.28l0.52,-0.82l-0.06,-1l-0.47,-0.37l0.05,-0.45l-0.34,-0.09l-0.03,-0.6l0.16,0.52h0.34l0.97,-0.98l1.09,-5.04l0.45,-0.42l0,0l0.85,0.18l0,0l1.16,-0.44L247.75,27.75z"
				},
				{
					"id":"AE-NZ1",
					"title":"Neutral Zone",
					"d":"M241.95,112.36L241.52,111.51L241.6,111.02L240.86,110.25L240.2,108.9L240.15,107.34L238.46,105.83L237.56,104.07L237.89,103.53L238.95,103.25L240.14,103.74L241.66,104.98L241.66,104.98L241.66,104.98L241.66,104.98L243.5,106.71L243.5,106.71L244.4,107.73L244.4,107.73L244.69,107.82L244.69,107.82L243.73,110.34z"
				},
				{
					"id":"AE-NZ2",
					"title":"Neutral Zone",
					"d":"M258.32,101.56L257.08,101.14L257.08,101.14L255.57,101.03L254.02,101.25L254.06,101.03L252.12,100.17L252.12,100.17L252.01,98.98L252.01,98.98L252.85,98.02L254.81,98.12L254.81,98.12L255.68,98.44L255.68,98.44L257.29,98.66L257.29,98.66L258.06,99.11L258.06,99.11L258.05,99.15L258.05,99.15L258.27,101.11L258.27,101.11z"
				},
				{
					"id":"OM-BAN",
					"title":"Al Bāţinah North",
					"d":"M325.94,170.5L324.03,173.21L319.18,179.16L317.8,179.93L316.04,179.98L312.63,180.7L309.93,183.9L307.17,183.79L306.62,184.28L306.24,185.22L305.41,185.49L302.33,185.71L298.16,189.52L298.16,189.52L296.9,189.01L290.21,188.76L289.08,187.75L288.7,186.36L287.94,185.35L286.71,184.61L286.17,182.58L287.44,181.82L286.68,180.93L285.61,180.44L283.78,180.56L282.52,179.8L280.87,179.42L276.96,180.05L275.95,180.56L274.06,180.3L272.04,178.41L271.16,177.15L270.4,173.74L267.5,172.23L266.87,170.59L266.61,166.8L265.86,165.29L264.47,165.03L263.58,164.02L262.32,163.64L260.18,160.62L259.04,160.11L259.04,160.11L258.79,158.6L260.56,156.58L260.18,154.94L257.65,153.55L256.64,153.3L253.7,149.32L253.86,148.04L254.5,146.93L255.39,142.24L256.25,140.55L256.25,138.63L258.17,136.72L260.08,136.72L259.29,134.96L257.85,133.53L256.41,133.05L252.66,132.96L253.38,126.35L254.66,124.59L253.54,122.68L252.43,121.56L251.63,119.96L251.15,117.89L250.19,116.61L251.15,114.7L252.27,114.22L251.63,112.63L251.31,110.87L250.19,110.87L249.34,109.52L249.34,109.52L249.8,107.52L249.8,107.52L250.47,106.96L250.47,106.96L252.3,106.84L252.3,106.84L252.3,106.84L252.3,106.84L254.58,106.04L254.58,106.04L254.58,106.04L254.58,106.04L255.33,105.12L255.33,105.12L255.79,103.99L257.57,103.51L257.57,103.51L258.36,102.85L258.36,102.85L258.4,102.35L258.4,102.35L258.27,101.11L258.27,101.11L258.05,99.15L258.05,99.15L258.46,98.17L259.07,97.93L259.07,97.93L260.3,97.81L260.3,97.81L262.15,103.7L263.39,106.54L265.01,109.34L265.98,113.22L269.92,121.31L275.08,129.22L278.56,132.76L279.56,133.65L280.27,133.95L286.22,143.19L289.2,146.96L289.91,148.52L292.8,152.24L295.96,155.17L297.82,156.66L298.28,156.77L301.27,159.34L303.78,161.79L305.97,163.25L312.55,166.1L323.77,169.55z"
				},
				{
					"id":"OM-BAS",
					"title":"Al Bāţinah South",
					"d":"M298.16,189.52L302.33,185.71L305.41,185.49L306.24,185.22L306.62,184.28L307.17,183.79L309.93,183.9L312.63,180.7L316.04,179.98L317.8,179.93L319.18,179.16L324.03,173.21L325.94,170.5L325.94,170.5L330.56,172.5L336.3,174.06L340.05,174.34L341.42,173.97L342.39,173.36L342.42,174.13L342.76,174.81L343.74,175.86L347.38,177.84L351.77,178.12L355.41,177.77L355.41,177.77L355.33,182.13L354.07,186.55L355.21,186.93L356.6,188.57L356.6,188.57L356.95,188.54L356.6,189.71L355.46,191.98L355.46,191.98L354.07,192.99L354.07,194.25L354.07,194.25L354.83,195.13L354.83,196.14L354.83,196.14L351.8,196.27L351.8,196.27L350.66,197.28L349.65,197.53L349.65,197.53L348.77,197.03L348.77,197.03L347.64,196.9L347.13,198.79L347.13,198.79L346.75,200.18L345.87,201.57L344.73,202.45L343.6,202.83L343.98,203.71L344.86,204.6L343.85,206.49L342.84,206.74L342.08,207.5L340.62,210.7L339.77,213.23L337.24,214.29L334.92,213.02L331.12,213.23L328.38,211.55L322.26,212.39L318.88,212.6L316.98,211.33L315.08,211.12L312.55,210.28L311.29,209.23L311.08,206.69L308.54,205.22L308.33,203.32L304.54,201.84L302.04,199.73L300.25,199.08L300.25,199.08L299.89,198.46L299.89,198.46L298.84,196.78L298.42,194.67L296.31,193.82L298.16,190.53z"
				},
				{
					"id":"OM-BU",
					"title":"Al Buraymī",
					"d":"M241.09,103.2L241.62,104.55L241.62,104.55L241.66,104.98L241.66,104.98L240.14,103.74L238.95,103.25L237.89,103.53L237.56,104.07L238.46,105.83L240.15,107.34L240.2,108.9L240.86,110.25L241.6,111.02L241.52,111.51L241.95,112.36L241.95,112.36L242.48,112.82L243.72,113.16L245.5,113.28L246.94,112.82L247.26,112.57L247.71,110.94L248.99,110.56L249.34,109.52L249.34,109.52L250.19,110.87L251.31,110.87L251.63,112.63L252.27,114.22L251.15,114.7L250.19,116.61L251.15,117.89L251.63,119.96L252.43,121.56L253.54,122.68L254.66,124.59L253.38,126.35L252.66,132.96L256.41,133.05L257.85,133.53L259.29,134.96L260.08,136.72L258.17,136.72L256.25,138.63L256.25,140.55L255.39,142.24L254.5,146.93L253.86,148.04L253.7,149.32L256.64,153.3L257.65,153.55L260.18,154.94L260.56,156.58L258.79,158.6L259.04,160.11L259.04,160.11L256.73,160.33L254.98,161.45L252.27,161.45L250.35,162.4L248.12,162.24L246.36,161.6L242.81,161.72L239.48,163.98L241.58,167.83L242.85,171.02L240.3,171.18L237.91,171.82L235.67,172.93L234.88,175.49L235.19,178.2L236.15,179.79L236.95,182.03L239.98,186.65L239.02,187.93L239.02,190L237.91,190.96L234.56,191.28L228.81,193.19L225.78,195.43L223.23,196.86L220.84,199.1L218.44,200.37L214.45,200.69L210.31,200.69L202.54,200.12L202.54,200.12L204.04,192.93L205.31,191.16L207.54,189.23L208.31,188.1L209.04,185.4L209.64,181L210.75,178.58L212.79,176.1L213.78,174.25L213.38,170.97L213.62,167.75L213.44,167.11L213.16,166.58L210.48,165.13L208.79,163.91L208.49,161.91L212.14,161.3L215.51,159.72L214.75,159.71L216.42,158.46L217.85,157.91L221.81,158.06L223.25,158.36L225.7,157.5L226.3,157.58L226.61,158.07L227.97,159.06L228.53,159.13L232.83,156.98L239.06,155.38L239.96,154.9L239.78,154.1L238.44,151.68L237.31,150.26L236.94,147.37L236.35,146.72L236.23,145.46L235.68,144.81L233.53,144.93L230.74,146.32L228.59,145.36L226.83,145.51L225.81,144.93L226.47,142.45L229.03,138.61L229.12,137.42L228.9,134.41L228.29,133.6L226.84,132.45L226.8,127.22L226.14,124.6L226.27,123.66L227.82,122.71L227.76,120.32L229.28,118.89L229.49,118.19L228.33,115.43L227.96,113.92L228.39,111.16L227.43,106.85L227.43,104.83L227.91,103.8L230.83,99.98L233.02,98.55L234.82,97.7L236.14,97.47L238.31,97.76L239.56,98.33L239.56,98.33L240.15,98.7L240.15,98.7L240.77,100.04L241.06,102.21L241.06,102.21z"
				},
				{
					"id":"OM-DA",
					"title":"Ad Dākhilīyah",
					"d":"M358.11,188.44L361.01,188.19L362.26,193.45L365.47,193.02L365.68,194.5L366.44,195.01L366.94,196.27L368.33,197.78L369.09,199.42L369.09,199.42L369.72,201.06L371.03,202.47L371.03,202.47L373.13,208.95L373.13,208.95L373.76,211.98L373.76,211.98L374.01,215.26L373.25,216.78L371.87,216.9L371.36,216.15L369.47,216.65L366.31,218.29L364.04,218.79L362.53,220.31L360.89,220.81L358.74,221.07L356.72,222.33L351.8,228.26L351.93,233.56L350.03,234.07L348.9,235.45L353.42,331.77L353.42,331.77L353.42,331.77L353.42,331.77L354.33,353.55L354.33,353.55L354.33,353.55L354.33,353.55L271.41,322.11L271.41,322.11L275.75,293.06L278.79,277.17L279.85,267.88L281.75,258.39L282.38,253.96L281.32,252.9L281.54,249.53L287.02,228.22L288.71,225.89L289.76,221.04L291.66,215.98L293.35,217.45L295.46,218.51L301.79,212.18L302.64,209.65L301.16,206.69L301.58,201.42L301.58,201.42L300.25,199.08L300.25,199.08L302.04,199.73L304.54,201.84L308.33,203.32L308.54,205.22L311.08,206.69L311.29,209.23L312.55,210.28L315.08,211.12L316.98,211.33L318.88,212.6L322.26,212.39L328.38,211.55L331.12,213.23L331.12,213.23L331.12,213.23L331.12,213.23L334.92,213.02L334.92,213.02L334.92,213.02L334.92,213.02L337.24,214.29L339.77,213.23L340.62,210.7L342.08,207.5L342.84,206.74L343.85,206.49L344.86,204.6L343.98,203.71L343.6,202.83L344.73,202.45L345.87,201.57L346.75,200.18L347.13,198.79L347.13,198.79L347.64,196.9L348.77,197.03L348.77,197.03L349.65,197.53L349.65,197.53L350.66,197.28L351.8,196.27L351.8,196.27L354.83,196.14L354.83,196.14L354.83,195.13L354.07,194.25L354.07,194.25L354.07,192.99L355.46,191.98L355.46,191.98L356.95,188.54z"
				},
				{
					"id":"OM-MA",
					"title":"Masqaţ",
					"d":"M357.16,177.7L360.51,177.92L364.19,179.13L365.71,179.81L370.36,183.38L374.25,184.62L377.21,184.76L380,184.35L382.31,183.34L382.33,182.87L382.93,182.43L382.97,182.14L383.25,182.28L383.52,182.03L384.37,182.97L387.21,182.59L387.19,182.87L387.59,183.13L387.16,183.2L387.06,183.59L387.85,183.52L387.96,183.22L388.3,183.53L388.45,183.25L389.02,183.88L388.93,183.15L389.22,183.31L389.22,184.23L389.52,184.46L389.09,184.98L389.51,185.21L389.44,185.72L389.93,186.71L390.73,186.97L391,187.3L391.7,187.22L391.65,187.57L392.15,187.43L392.26,187.58L391.78,187.81L392.07,188.33L392.53,188.13L392.68,187.67L393.1,188.49L394.01,189.17L396.25,189.12L396.41,189.28L396.17,189.8L396.52,190.1L396.25,190.29L396.44,190.6L396.52,190.31L396.78,190.53L396.7,189.85L396.99,189.82L397.15,190.08L397.67,189.7L398.13,189.75L398,190.24L398.7,190.5L398.31,190.64L398.46,191.02L398.87,191.28L399,191.88L399.23,191.79L399.61,192.7L399.5,193.57L399.89,196.05L400.71,196.78L401.05,197.84L403.57,199.36L403.81,199.93L405.17,200.84L405.89,201.78L407.26,202.36L407.45,203.3L407.69,203.47L407.58,204.31L407.87,205.41L408.59,207.04L410.38,208.31L411.84,209.73L412.07,210.75L411.84,211.92L413.08,214.89L414.18,216.2L415.8,217.31L416.3,219.4L418.67,221.89L421.79,223.89L423.24,224.51L424.35,226.01L425.04,227.97L409.1,229.46L409.1,229.46L408.97,226.05L408.97,226.05L409.73,221.63L408.46,220.25L406.95,220.5L406.19,221.51L406.19,221.51L404.8,223.53L401.9,221.63L400.26,221L400.26,221L398.37,220.25L396.6,219.11L396.6,219.11L394.96,217.72L394.96,217.72L391.3,216.21L390.29,214.95L388.78,214.31L386.25,210.91L386.25,210.91L385.75,210.15L385.5,208.76L385.5,208.76L380.7,208.51L379.19,207.12L377.55,206.36L377.55,206.36L374.64,204.6L372.37,202.83L372.37,202.83L370.98,202.45L369.72,201.06L369.09,199.42L369.09,199.42L368.33,197.78L366.94,196.27L366.44,195.01L365.68,194.5L365.47,193.02L362.26,193.45L361.01,188.19L358.11,188.44L358.11,188.44L356.6,188.57L356.6,188.57L355.21,186.93L354.07,186.55L355.33,182.13L355.41,177.77L355.41,177.77z"
				},
				{
					"id":"OM-MU",
					"title":"Musandam",
					"d":"M269.16,7.69l0.45,0.7l0.18,0.41l0.11,0.2l-1.66,0.54l0.05,-0.27l0.53,-0.23l0.16,-0.36l-0.19,-0.66L269.16,7.69zM264.74,8.37l0.27,0.32l0.61,-0.05l-0.31,0.68l-0.93,-0.46L264.74,8.37zM257.83,76.45l0.09,1.76l-0.29,1.29l0,0l-0.27,0.69l0,0l-0.82,0.53l0,0l-0.39,0.28l0,0l-1.93,1.43l0,0l-0.82,0.12l-2.08,-0.41l0,0l-0.79,-0.46l-0.14,-0.5l0,0l-0.4,-3.08l0.5,-1.31l0,0l1.67,-0.18l1.45,-0.71l0.27,-1.63l0,0l0.4,-0.97l2.16,-0.89l1.11,-0.82l0,0l0.18,1.81l-0.32,1.62L257.83,76.45zM256.11,78.93l-0.97,0.54l-0.97,-0.43v-0.86l0.97,-0.65l0.97,0.43V78.93zM260.54,7.62l-0.39,1.36l0.39,0.07l0.1,-0.52l0.47,-0.16l-0.27,1.18l0.42,-0.11l0.31,-0.68l0.18,0.04l-0.13,0.89l0.31,-0.07l0.53,-0.98l0.23,0.25l0.11,0.61l-0.45,0.04l0.24,0.34l-0.21,0.18l0.05,0.82l1,-0.93l0.35,0.46l0.1,0.13l0.26,1.04l0.69,-0.07l0.05,-0.32l0.42,-0.23l-0.11,0.79l0.56,0.25l0.27,-0.38l0.92,0.32l0.56,-0.25l-0.02,-0.25l-0.48,-0.52l0.1,-0.29l-0.56,-0.07l-0.35,-0.59l1.13,0.39l0.24,-0.73l0.39,0.04l-0.18,1.02l0.32,0.52l-0.21,0.73l0.82,-0.09l0.13,0.27l-0.4,0.59l-0.61,-0.21l-0.37,0.25l0.14,-0.45l-0.26,-0.21l-1.87,0.23l-0.68,0.66l-0.16,-0.39l-1.17,0.39l-0.26,-0.16l-0.05,0.39l0.56,0.96l-0.58,-0.05l-0.42,-0.36l-0.4,0.07l0.03,0.32l-0.52,-0.21l-0.29,0.43l0.14,0.39l0.31,-0.11l0.5,0.7l-0.06,0.29l-0.93,0.3l0.52,0.38l-0.03,0.21l0.43,0.45l0.74,-0.21l0.06,1.03l0.51,-0.21l0.69,0.71l0.64,-0.29l-0.05,-0.39l0.34,-0.13l-0.23,-0.77l0.29,0.02l0.16,0.61l0.85,-0.11l0.07,0.43l0.69,-0.11l-1.08,0.68l0.66,2.12l-0.55,0.31l-0.29,-0.09l0.13,-0.5l-0.5,-0.09l0.45,-0.5V19.1l-0.69,-0.5l-0.43,0.21l-0.18,0.73l-0.52,-0.02l0.31,0.54l-0.14,0.32l-0.48,-0.29l-0.1,0.14l0.31,0.25l0.11,0.87l-0.23,0.84l0.5,0.45l0.26,-0.11l0.16,-0.55l0.35,-0.14l-0.06,0.36l0.64,-0.13l0.19,1.43l0.63,-0.23l0.24,0.91l-0.35,-0.21l-0.48,0.39l0.05,-0.48l-0.24,-0.2l-0.85,0.16l-0.19,-0.18l-0.43,0.05h-0.42l-0.45,0.45l-0.26,-0.13l-0.53,-1.23l-0.29,0.09l0.26,-0.66l-0.32,-0.12l0.05,-0.3l0.16,-0.34l0.31,0.02l-0.15,-0.3l0.21,-0.39l-0.24,-0.34l-0.39,0.16l-0.26,0.64l-0.61,-0.09l-0.29,0.29l0.05,0.64l0.23,-0.04l0.02,0.21l-0.35,0.09l-0.18,0.57l-0.37,0.04l0.4,-1.12l-0.43,-0.66l0.32,-0.04l0.14,-0.48l0.45,0.21l0.39,-0.16l-0.26,-0.75l-0.63,-0.3l-0.56,0.09l-0.11,0.39l-0.48,-0.18l0.05,0.45l-0.37,0.02l-0.32,0.68l0.53,0.25l-0.27,0.37l-0.89,0.43l-0.61,-0.18l-0.37,0.48l0.5,0.5l-0.02,0.98l0.76,-0.7l-0.48,1.05l0.15,0.43l-0.34,0.32l-0.13,0.7l0.19,0.05l-0.27,0.59l0.85,-0.21l0.02,-0.59l0.24,-0.11l0.19,-0.68l1.11,-0.84l0.29,0.39l-0.05,0.45l-0.72,1.68l0.53,0.04l0.21,0.52l0.48,-0.23l-0.05,-0.68l0.58,-0.59l0.15,1.03l0.79,-0.57l-0.16,0.94l0.34,0.48l1.17,-0.78l0.16,0.45l0.43,-0.55l0.14,0.32l0.45,-0.05l0.18,0.37l0.82,-0.29l0.16,0.27l-0.72,0.28l-0.52,0.53l-0.35,0.05l-0.45,-0.07l-0.31,0.82l0.24,0.27l-0.08,0.73l-0.47,0.05l-0.21,-0.25l-0.21,0.3l-0.69,0.07l-0.13,-0.55l-1.37,0.8l0.5,0.29l-0.32,0.2l0.16,0.3l-0.37,0.14l0.32,0.25l0.45,-0.59l0.45,-0.02l0.31,0.55l0.92,-0.41l-0.32,1.37l0.34,0.2l-0.1,0.37l0.48,0.64l-0.84,-0.37l0.06,0.43l-0.69,0.18l0.19,0.34l-0.4,0.05l-0.23,0.43l1.08,0.52l0.39,-0.16l-0.1,1.05l0.4,0.69l1.58,-0.59l-1.01,0.66l0.15,0.82l-0.53,-0.44h-0.58l-0.39,0.41l-0.08,-0.48L262.02,37l-0.15,-0.29l-0.45,0.09l0.03,2.01l0.89,0.37l-0.53,0.85l0.18,0.16l-0.19,0.75l-0.61,0.75l-0.69,-0.07l-0.05,-0.2l-0.58,0.27l0.05,0.41h0.55l0.48,0.55l-0.61,0.39l-0.82,-0.25l0.15,0.53l0.53,0.16l-0.29,0.82l0.16,0.59l-0.55,0.36l-0.48,0.92l-0.4,-0.94l-0.11,0.84l0.26,0.64l-0.4,0.37l-0.66,1.48l-1.34,1.07l0.82,-1.81l0.02,-0.3l-0.19,0.04l-0.4,0.44l0.06,0.52l-0.55,0.37l0.03,0.3l-0.43,0.18l-1.14,1.55l-0.19,0.8l0.71,0.12l-0.4,0.34l0.27,0.78l-0.55,0.35l-0.27,0.8l-0.05,0.64l0.23,0.21l-0.18,0.09l-0.02,0.94l-1.33,1.21l0,0l-1.44,-0.4l-0.97,-1.05l-0.24,-0.73l-0.97,-0.81l-1.56,0.23l0,0l-0.26,-0.38l0,0l-0.14,-0.53l0,0l-0.09,-3.36l0.18,-1.73l0.44,-1.15l-0.9,-2.31l0.12,-2.19l0,0l1.09,-4.25l0,0l0.64,-4.67l-0.25,-1.14l0,0l0.23,-2.73l0,0l-0.31,-1.45l-0.61,-0.8l-1.5,-0.24l-1.16,0.44l0,0l-0.85,-0.18l0,0l0.79,-1.79l0.45,-0.3l1.43,-2.69l0.23,-0.05l0.02,0.34l0.43,-0.07l0.79,-1l0.39,-1.03l0.48,-3.07l0.76,-1.02l0.45,-0.23l-0.02,-0.39l0.42,-0.36l0.42,0.18l-0.02,1.05l0.03,0.39l0.29,0.96l-0.19,0.3l0.08,1.02l0.31,-0.23l0.27,-0.95l0.71,0.14l0.02,0.68l0.45,0.16l0.53,-1.18l0.6,0.07l0.23,0.27l0.53,-0.57l0.16,0.2l0.35,0.61l-0.11,1.02l0.42,0.59l0.8,-0.04l-0.08,-0.25l-0.45,-0.02l0.13,-0.32l1.08,0.45l0.21,-0.32l0.42,-0.07l0.11,0.68l0.37,0.09l0.34,-0.7l-0.16,-0.25l0.26,0.04l0.39,-0.98l0.32,0.34l0.93,-0.3l0.24,0.2l0.47,-0.09l0.02,0.41l0.48,0.36l0.45,-0.13l-0.39,-0.64l0.87,0.14l-0.08,-0.34l-0.82,-0.45l0.66,-0.2l-0.13,-0.61l-0.5,-0.16l-0.63,0.32l0.18,-0.55l-0.24,-0.38l-0.42,0.84l-0.4,0.13l-0.52,-0.55l-1.13,1.39l-0.39,-0.36l-0.39,0.95l-1.38,0.41l-0.37,-0.46l-0.02,-1.61l0.45,-0.87l0.32,0.18l0.16,-0.27l-0.32,-0.86l0.26,-0.09l-0.24,-0.45l0.37,-1.32l0.51,0.68l0.39,-0.05l0.29,0.62l0.43,0.11l-0.13,0.89l0.68,0.16l0.16,-0.18l0.47,0.3l0.37,-0.52l-0.06,-0.41l-0.72,-0.46l0.42,-0.25l-0.08,-0.2l-0.89,-0.07l-0.19,0.18v-0.79h-0.53l-0.21,-0.57l-0.74,-0.38l0.11,-0.43l0.63,-0.55l0.24,0.45l0.64,-0.63l0.39,0.43l0.34,-0.18l0.14,-1.07l-0.37,-0.07l0.48,-1l-0.05,-1.13L260.54,7.62zM259.17,8.42l0.53,0.54l-0.4,0.27l-0.13,1.8l-0.61,0.32l-0.1,-1.5l0.39,-0.73l0.13,-0.25l-0.02,-0.38L259.17,8.42zM262.97,7.83l-0.23,0.57l-0.23,-0.11l0.18,-0.43L262.97,7.83z"
				},
				{
					"id":"OM-SHN",
					"title":"Ash Sharqīyah North",
					"d":"M406.6,365.43l0.71,0.29l0.26,0.43l-0.89,3.73l0.15,1.13l0.51,1.16l1.5,0.89l-0.18,0.85l0.32,0.5l-0.19,0.27l0.1,0.58l0.42,0.75l0.82,0.32l0.11,0.27l-0.92,1.33l-2.4,0.85l-0.06,0.43l-3.25,1.74l-0.42,0.5l0.06,0.31l-0.92,0.6l-0.39,0.87l0.16,0.79l-1.37,2.1l0.19,0.97l-0.39,0.94l0.13,0.46l-1.19,1.48l0.31,0.53l-0.21,0.41l0.23,0.03l0.13,0.46l-0.93,0.43l-0.16,0.48l-0.51,-0.03l-0.85,0.68l-0.79,1.14l-0.26,1.02l-0.72,0.39l-0.27,0.43l-0.32,-0.1l-1.79,0.82l-0.72,1.31l-0.82,0.03l-0.5,0.43l-0.11,-1.31l-0.23,-0.26l0.26,-0.53l-0.27,-0.75l0.16,-0.55l-0.34,-0.56l-0.06,-0.77l0.13,-1.36l-0.23,-0.48l0.32,-0.73l-0.15,-0.68l0.31,-0.19l0.11,-3.09l1.71,-2.42l0.29,0.05l0.83,-0.5l0.05,-0.9l0.87,-0.73l0.31,-0.75l0.32,-0.07l0.45,-0.79l0.45,-0.15l-0.56,0.56l0.5,0.9h1.54l1.38,-1.2l0.06,-1.31l0.5,-0.48l-0.16,-0.75l0.24,-2.27l2.69,-4.48l0.87,-0.92l1.05,-0.62l-0.1,-1.23l0.19,-0.5l-0.27,-0.27l0.37,0.21l0.13,-0.32l0.26,-1.56l-0.18,-0.74L406.6,365.43zM400.26,221l1.64,0.63l2.9,1.89l1.39,-2.02l0,0l0.76,-1.01l1.51,-0.25l1.26,1.39l-0.76,4.42l0,0l0.13,3.41l0,0l15.96,-1.46l0.39,0.92l-0.15,0.56l0.9,2.4l1.03,1.28l0.45,0.21l0.13,0.87l1.42,2.99l0.98,0.62l0.74,-0.1l0.43,0.31l0.39,-0.03l1.32,2.58l1.35,0.52l-0.1,0.64l0.32,0.83l2.33,1.51l2.99,2.98l3.56,2.44l-0.14,0.5l-0.53,-0.24l-0.66,0.26l0.23,-0.52l-0.23,-0.12l-0.58,0.62l0.39,0.16l-0.06,0.33l0.8,0.24l0.32,-0.5l0.45,0.1l0.24,-0.95l6.2,0.66l3.3,1.11l0,0l-0.52,0.74l-1.38,0.69l-3.58,1.17l-1.38,0.96l-1.65,0.21l-1.72,-0.55h-3.17l-0.89,0.34l-0.48,1.72l-2.75,3.65l-1.38,0.21l-1.72,-0.28l-2.34,-2.13l-1.86,-0.69l-0.48,0.48l-0.28,1.31l0.62,1.1l0.69,3.51l0.34,2.27l-0.21,1.38l-1.93,1.45l-0.55,1.72l-0.83,0.96l-1.1,0.69l-1.24,-0.21l-4.34,-4.2l-1.79,-1.38l-1.79,-3.99l-1.45,-2l-1.24,-0.69l-3.3,-1.1l-1.65,-1.1l-2.69,-2.75l-0.34,-1.17l-0.28,-5.16l-3.3,-4.48l-1.79,-1.52l-1.65,-0.76l-1.79,-0.21l-0.55,1.17l-0.21,1.45l0.41,2.07v1.58l-2.69,5.44l-0.69,2l-0.48,3.72l-1.58,1.65l-1.24,0.41l-1.79,-0.07l-1.31,-0.62l-0.55,-1.51l0.21,-5.16l-0.21,-1.31l-0.69,-1.58l-3.03,-3.24l-1.24,-0.9l-1.24,-0.62l-2.13,-0.55l-1.38,-0.9l-2.41,-2.48l-0.69,-0.96l-0.34,-1.1l0.62,-3.3l0.76,-1.86l-0.41,-1.45l-1.17,-1.38l-2.34,-5.03v-4.68l2.62,0.14l0.96,-0.62l0.62,-1.03l0.14,-1.52l2.89,-4.89v-1.31l-0.69,-0.9l-1.31,-0.41l-1.27,-0.08l0,0l-0.54,-2.61l0,0l-2.1,-6.49l0,0l1.34,0.36l0,0l2.27,1.77l2.9,1.77l0,0l1.64,0.76l1.51,1.39l4.8,0.25l0,0l0.25,1.39l0.5,0.76l0,0l2.52,3.41l1.51,0.63l1.01,1.26l3.66,1.51l0,0l1.64,1.39l0,0l1.77,1.14L400.26,221z"
				},
				{
					"id":"OM-SHS",
					"title":"Ash Sharqīyah South",
					"d":"M453.27,251.18L454.8,251.6L454.51,252.19L454.65,252.38L453.77,253.29L453.77,253.75L454.81,254.39L454.69,254.8L455.83,255.34L457.29,254.47L455.73,253.83L455.46,253.03L454.66,252.22L454.99,251.51L456.21,251.68L456.17,251.98L457.16,252.76L457.9,252.57L457.82,252.05L457.24,251.93L456.6,252.24L456.47,251.72L457.81,251.37L458.58,251.46L459.11,253.73L459.77,254.25L459.93,254.97L460.29,255.34L461.01,258.44L460.29,259.06L459.69,261.12L460.17,262.31L459.72,263.84L459.75,264.3L460.13,264.7L460.14,266.69L459.37,269.08L459.32,270.84L457.07,272.65L456.87,273.07L457.05,273.55L456.76,274.04L456.12,274.83L455.36,275.28L453.35,278.54L451.68,280.46L451.21,282.03L451.56,282.71L449.83,286.69L449.74,287.21L450.2,287.99L449.83,288.92L447.49,290.83L445.43,293.68L445.82,294.44L445.75,294.87L443.19,297.31L441.02,299.9L440.43,301.47L440.57,303.15L438.83,306.22L439.04,306.84L438.8,307.36L437.06,309.95L435.55,312.91L434.79,313.74L434.36,315.13L432.46,317.54L432.11,318.57L432.77,319.04L432.56,319.96L430.43,321.18L424.61,323.57L422.06,325.12L414.79,331.01L412.34,333.48L410.53,335.85L407.64,338.39L403.91,342.79L400.76,347.68L400.63,349.02L401.16,349.65L400.93,350.66L398.02,353.93L397.51,355.47L397.59,356.52L397.23,356.74L397.46,357.77L396.14,358.62L396.62,357.58L396.46,357.05L396.65,356.79L396.28,356.57L394.63,358.2L394.77,358.76L393.97,359.96L393.52,360.01L393.4,359.43L393.02,359.74L393.24,359.92L392.95,360.21L392.97,360.63L393.31,360.99L392.03,361.55L392.68,361.72L392.55,361.86L393.11,361.81L392.79,362.06L393.1,362.08L393.48,361.05L393.71,361.82L394.25,362.11L394.96,361.72L395.51,362.03L394.24,362.25L393.92,362.83L394.38,362.95L394.67,362.59L394.88,362.8L396.77,361.84L396.96,361.09L396.48,359.98L396.78,359.26L396.44,359.17L397.1,358.54L397.52,359.48L397.41,362.11L397.22,362.37L395.66,362.71L393.9,364.8L390.86,366.65L388.64,369.23L389.57,369.26L389.75,369.42L389.49,369.69L389.85,369.95L388.38,371.52L387.74,372.96L387.61,374.18L387.11,374.68L387.24,375.24L386.84,376.06L386.4,376.1L386.03,376.87L386.03,377.76L385.63,378.2L385.73,378.39L386,378.29L386.06,378.54L385.19,380.08L385.05,382.13L384.52,382.83L383.96,383.1L383.67,383.73L382.91,383.78L382.59,384.23L382.09,384.31L381.98,384.94L381.56,385.08L380.37,386.45L380.37,386.84L378.02,386.74L377.33,386.14L376.6,386.04L374.86,384.96L372.98,384.98L371.02,385.66L369.78,385.69L369.02,384.77L367.56,384.11L366.67,383.99L366.06,383.51L365.88,381.84L366.59,381.34L367.36,379.22L368.57,377.28L368.72,376.29L368.72,376.29L371.63,376.55L372.06,373.18L373.11,370.64L373.11,368.32L372.06,362.2L354.33,353.55L354.33,353.55L348.9,235.45L350.03,234.07L351.93,233.56L351.8,228.26L356.72,222.33L358.74,221.07L360.89,220.81L362.53,220.31L364.04,218.79L366.31,218.29L369.47,216.65L371.36,216.15L371.87,216.9L373.25,216.78L374.01,215.26L373.76,211.98L373.76,211.98L373.67,211.56L373.67,211.56L374.94,211.64L376.25,212.06L376.94,212.95L376.94,214.26L374.05,219.15L373.91,220.66L373.29,221.69L372.32,222.31L369.71,222.18L369.71,226.86L372.05,231.88L373.22,233.26L373.63,234.71L372.88,236.57L372.26,239.87L372.6,240.97L373.29,241.94L375.7,244.42L377.07,245.31L379.21,245.86L380.45,246.48L381.69,247.38L384.72,250.61L385.41,252.19L385.61,253.5L385.41,258.67L385.96,260.18L387.26,260.8L389.05,260.87L390.29,260.46L391.88,258.8L392.36,255.09L393.05,253.09L395.73,247.65L395.73,246.07L395.32,244L395.53,242.56L396.08,241.39L397.87,241.59L399.52,242.35L401.31,243.86L404.62,248.34L404.89,253.5L405.23,254.67L407.92,257.43L409.57,258.53L412.88,259.63L414.12,260.32L415.56,262.32L417.35,266.31L419.14,267.69L423.48,271.89L424.72,272.09L425.82,271.4L426.65,270.44L427.2,268.72L429.13,267.27L429.33,265.9L428.99,263.62L428.3,260.11L427.68,259.01L427.96,257.7L428.44,257.22L430.3,257.91L432.64,260.04L434.36,260.32L435.74,260.11L438.49,256.46L438.97,254.74L439.87,254.4L443.03,254.4L444.75,254.95L446.41,254.74L447.78,253.78L451.36,252.61L452.74,251.92z"
				},
				{
					"id":"OM-WU",
					"title":"Al Wusţá",
					"d":"M354.33,353.55L372.06,362.2L373.11,368.32L373.11,370.64L372.06,373.18L371.63,376.55L368.72,376.29L368.72,376.29L369.39,375.02L369.46,373.64L369.81,372.97L370.04,373.04L370.05,372.19L366.51,370.77L365.58,370.67L365.35,370.92L364.18,371.18L363.65,371.93L362.5,372.44L361.75,373.25L361.18,373.26L359.17,374.25L358.8,374.9L358.9,376.24L358.33,377.52L358.45,379.82L357.76,380.15L357.19,380.78L355.95,380.97L353.44,382.13L351.59,383.71L351.13,384.77L351.25,386.17L351.64,386.8L352.96,387.14L352.01,389.07L347.46,391.77L345.75,393.49L345.35,394.73L344.16,396.13L343.75,397.8L343.92,399.64L344.09,400L344.74,400.1L344.9,400.65L343.93,404.6L344.27,405.2L343.47,407.6L343.53,409.28L342.4,411.09L342.15,412.47L341.1,414.44L340.94,415.17L341.16,415.5L340.17,417.83L340.26,418.15L339.37,419.3L339.39,420.12L336.56,423.5L335.89,424.93L335.77,426.7L336.17,428.06L336.87,428.7L337.49,428.55L337.88,429.18L338.46,429.04L338.27,430.44L337.78,431.37L337.98,432.44L337.01,435.46L336.87,437.33L337.22,438.26L338.32,439.35L338.51,440.55L339.01,441.03L339.41,441.96L339.86,442.17L340.68,445.69L340.52,447.29L339.47,450.68L339.67,455.1L340.97,458.66L341.47,459.15L342.5,459.05L343.09,459.84L342.6,462.11L342.68,465.04L343.14,465.58L343.66,465.55L343.92,467.83L344.62,468.97L345.22,469.14L345.3,469.43L343.87,470.58L343.61,470.39L343.22,471.24L339.54,471.56L338.46,472.52L337.41,473.01L336,473.21L324.85,473.06L320.08,473.32L314.61,473.98L311.91,474.55L298.26,478.22L288.99,482.04L285.16,484.54L283.18,486.26L275.39,495.43L275.05,496.68L275.47,496.36L276.34,494.54L274.88,498.06L275.31,502.87L273.88,506L273.81,509.14L273.28,512L270.88,516.42L270.1,519.26L270.11,520.04L270.45,520.68L270.51,522.5L269.03,523.08L268.1,524.43L266.36,525.21L263.95,526.97L263.55,527.61L263.39,529.23L260.84,531.48L259.51,532.1L259.06,532.77L259.04,533.23L259.04,533.23L238.45,497.88L219.25,466.86L198.78,435L180.64,408.23L180.64,408.23L205.18,329.9L205.18,329.9L271.41,322.11L271.41,322.11z"
				},
				{
					"id":"OM-ZA",
					"title":"Az̧ Z̧āhirah",
					"d":"M202.54,200.12L210.31,200.69L214.45,200.69L218.44,200.37L220.84,199.1L223.23,196.86L225.78,195.43L228.81,193.19L234.56,191.28L237.91,190.96L239.02,190L239.02,187.93L239.98,186.65L236.95,182.03L236.15,179.79L235.19,178.2L234.88,175.49L235.67,172.93L237.91,171.82L240.3,171.18L242.85,171.02L241.58,167.83L239.48,163.98L242.81,161.72L246.36,161.6L248.12,162.24L250.35,162.4L252.27,161.45L254.98,161.45L256.73,160.33L259.04,160.11L259.04,160.11L260.18,160.62L262.32,163.64L263.58,164.02L264.47,165.03L265.86,165.29L266.61,166.8L266.87,170.59L267.5,172.23L270.4,173.74L271.16,177.15L272.04,178.41L274.06,180.3L275.95,180.56L276.96,180.05L280.87,179.42L282.52,179.8L283.78,180.56L285.61,180.44L286.68,180.93L287.44,181.82L286.17,182.58L286.71,184.61L287.94,185.35L288.7,186.36L289.08,187.75L290.21,188.76L296.9,189.01L298.16,189.52L298.16,189.52L298.16,190.53L296.31,193.82L298.42,194.67L298.84,196.78L299.89,198.46L299.89,198.46L301.58,201.42L301.58,201.42L301.16,206.69L302.64,209.65L301.79,212.18L295.46,218.51L293.35,217.45L291.66,215.98L289.76,221.04L288.71,225.89L287.02,228.22L281.54,249.53L281.32,252.9L282.38,253.96L281.75,258.39L279.85,267.88L278.79,277.17L275.75,293.06L271.41,322.11L271.41,322.11L205.18,329.9L205.18,329.9L219.26,285.09L209.02,267.7L192.9,241.41L192.67,239.39L193.63,234.33L193.1,226.96L193.44,221.14L194.7,218.44L194.61,217.12L195.12,215.09L198.81,209.3L199.27,207.96L200.75,205.76L202.28,201.55z"
				},
				{
					"id":"OM-ZU",
					"title":"Z̧ufār",
					"d":"M180.64,408.23L198.78,435l20.47,31.86l19.2,31.02l20.59,35.35l0,0l-0.13,0.42l0.27,0.44l0,0.72l-0.68,0.34l-2.22,-0.2l-1.29,-0.49l-0.31,-0.34l-1.38,-0.13l-0.34,-0.24l-3.35,-0.02l-0.69,-0.32l-0.97,0.37l-0.71,0.67l-2.08,0.1l-0.53,0.37l-3.81,-0.59h-3.46l-2.03,0.86l-0.72,0.76l-1.13,0.42l-0.26,-0.18l-0.4,0.29l-8.72,-0.47l-6.07,0.86l-6.23,1.38l-6.24,2.72l-0.61,0.91l0.11,0.4l-0.47,1.26l0.26,0.45l-0.23,0.6l-1.21,0.77l-0.72,1.19l0.13,1.83l-0.31,1.09l-3.41,1.81l-0.9,0.96l-0.02,0.39l-2.17,1.36l-0.4,0.49l0.11,0.59l-1.24,1.61l-0.77,1.93l-0.03,1.63l0.34,0.35l-0.03,1.22l0.26,0.75l0.79,0.8l1.38,0.03l1.43,2.56l0.02,0.45l0.51,0.17l-0.48,0.44l0.11,0.67l-0.4,0.5l0.11,0.74l-0.8,0.59l0.03,0.97l-0.82,0.97l-0.19,0.92l-0.85,0.54l-0.42,0.84l-0.05,0.6l1.32,1.76l-0.51,0.39l-0.18,0.67l-0.84,0.59l-0.24,0.57l-1.42,0.8l-0.92,1.67l0.18,1.07l-2.08,0.4l-0.74,0.37l-1.35,2.17l-1.3,1.79l-0.82,0.32l0.08,0.33l-0.31,0.43l-1.93,1.07l-0.19,0.47l-0.97,0.3l-0.61,0.99l-0.11,-0.99l-0.66,-0.33l-0.8,0.07l-0.72,1.55l-1.29,0.55l-0.85,-0.22l-0.16,0.69l-0.8,0.17l-0.13,-0.47l-0.64,-0.37l-0.02,0.69l-0.47,0.72l-1.48,-0.02l-0.37,0.42l-0.95,-0.27l-1.3,0.29l-0.37,0.07l-0.69,0.13l0.19,0.32l-0.18,0.18l-1.19,0.18l-1.03,-0.65l-0.69,0.45l-0.61,-0.74l-0.45,0.08l0.02,0.3l-0.55,-0.13l-0.53,0.22l0.05,-0.55l-0.52,0.12l-0.06,-0.45l-0.74,-0.1l-0.37,-0.03l-0.05,0.27l-0.26,-0.17v-0.47l-0.26,0.12l-0.47,-0.3l0.45,-1.1l-0.47,-0.95l-0.63,-0.35l-2.43,-0.64l-2.67,0.03l-3.36,-0.33l-4.44,0.05l-0.4,0.35l-0.47,-0.02l-0.43,-0.29l-4.67,-0.1l-4.65,0.5l-11.54,1.84l-2.66,0.65l-0.6,0.4l-0.98,1.51l0.34,0.17l-0.03,0.72l0.48,-0.2l0.23,0.28l-0.32,0.4l-0.69,-0.02l-0.63,0.3l-0.84,1.02l-0.35,-0.25l-0.76,0.13l-0.21,0.69l-1.82,-0.03l-0.76,0.29l-1.4,-0.15l-1.59,0.57l-2.03,0.03l-2.46,0.48l-1.06,0.45l-0.02,0.37l-2.27,1.85l-0.19,0.47l-0.55,0.02l-0.52,0.6l-0.55,0.03l-0.64,1.07l0.19,0.79l-0.16,0.22l-4.17,1.34l-1,0.6l-4.46,-0.8l-2.56,0.38l-4.26,1.09l-2.33,0.28l-1.4,0.6l-1.3,0.15l-6.31,1.74l-4.25,2.25L69.54,612l-21.42,-26.35l2.07,-15.38L0,495.01l6.88,-25.76L18.44,465l1.54,-0.31l1.08,-0.62l12.95,-4.66l51.97,-18.33L180.64,408.23zM229.93,559.76l0.95,0.75l0.92,0.15l0.02,0.54l-0.32,0.47l-0.76,0.37l-0.4,-0.47l-0.15,0.25l-0.26,-0.27l0.21,-0.18l-0.13,-0.27l-0.61,0.29l-0.58,-0.32l-0.15,0.29l-0.19,-0.57l0.14,-0.27l0.35,0.12L229.93,559.76zM241.53,557.06l0.34,0.52l0.26,1.79l1.96,0.22l0.05,0.27l-0.42,0.52l-0.98,0.25l-1.58,0.86l-1.13,-0.2l-0.02,0.22l-0.66,0.1l-0.21,-0.28l-1.96,-0.2l-0.74,-0.47l0.03,-0.52l-0.39,-0.17l0.37,-0.55l1.67,-0.57l0.08,-0.32l0.9,0.07l1.03,-0.4L241.53,557.06z"
				}
			]
		}
	}
};