function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { mergeData, pluckProps } from "../../utils";
import { arrayIncludes, concat } from "../../utils/array";
import { assign, keys } from "../../utils/object";
import { addClass, removeClass } from "../../utils/dom";
import Link, { propsFactory as linkPropsFactory } from "../link/link";

var btnProps = {
    block: {
        type: Boolean,
        default: false
    },
    disabled: {
        type: Boolean,
        default: false
    },
    size: {
        type: String,
        default: null,
        validator: function validator(size) {
            return arrayIncludes(["sm", "", "lg"], size);
        }
    },
    variant: {
        type: String,
        default: null
    },
    type: {
        type: String,
        default: "button"
    },
    pressed: {
        // tri-state prop: true, false or null
        // => on, off, not a toggle
        type: Boolean,
        default: null
    }
};

var linkProps = linkPropsFactory();
delete linkProps.href.default;
delete linkProps.to.default;
var linkPropKeys = keys(linkProps);

export var props = assign(linkProps, btnProps);

function handleFocus(evt) {
    if (evt.type === "focusin") {
        addClass(evt.target, "focus");
    } else if (evt.type === "focusout") {
        removeClass(evt.target, "focus");
    }
}

export default {
    functional: true,
    props: props,
    render: function render(h, _ref) {
        var _ref2;

        var props = _ref.props,
            data = _ref.data,
            listeners = _ref.listeners,
            children = _ref.children;

        var isLink = Boolean(props.href || props.to);
        var isToggle = typeof props.pressed === "boolean";
        var on = {
            click: function click(e) {
                if (props.disabled && e instanceof Event) {
                    e.stopPropagation();
                    e.preventDefault();
                } else if (isToggle) {
                    // Concat will normalize the value to an array
                    // without double wrapping an array value in an array.
                    concat(listeners["update:pressed"]).forEach(function (fn) {
                        if (typeof fn === "function") {
                            fn(!props.pressed);
                        }
                    });
                }
            }
        };

        if (isToggle) {
            on.focusin = handleFocus;
            on.focusout = handleFocus;
        }

        var componentData = {
            staticClass: "btn",
            class: [props.variant ? "btn-" + props.variant : "btn-secondary", (_ref2 = {}, _defineProperty(_ref2, "btn-" + props.size, Boolean(props.size)), _defineProperty(_ref2, "btn-block", props.block), _defineProperty(_ref2, "disabled", props.disabled), _defineProperty(_ref2, "active", props.pressed), _ref2)],
            props: isLink ? pluckProps(linkPropKeys, props) : null,
            attrs: {
                type: isLink ? null : props.type,
                disabled: isLink ? null : props.disabled,
                // Data attribute not used for js logic,
                // but only for BS4 style selectors.
                "data-toggle": isToggle ? "button" : null,
                "aria-pressed": isToggle ? String(props.pressed) : null,
                // Tab index is used when the component becomes a link.
                // Links are tabable, but don't allow disabled,
                // so we mimic that functionality by disabling tabbing.
                tabindex: props.disabled && isLink ? "-1" : data.attrs ? data.attrs['tabindex'] : null
            },
            on: on
        };

        return h(isLink ? Link : "button", mergeData(data, componentData), children);
    }
};