webpackJsonp([5,37],{823:function(t,e,a){function o(t){a(900)}var n=a(1)(a(853),a(935),o,"data-v-347b2712",null);t.exports=n.exports},853:function(t,e,a){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.default={data:function(){return{vertical:"bottom",horizontal:"center",duration:4e3}},methods:{open:function(){this.$refs.snackbar.open()}}},t.exports=e.default},867:function(t,e,a){e=t.exports=a(795)(),e.push([t.i,"",""])},900:function(t,e,a){var o=a(867);"string"==typeof o&&(o=[[t.i,o,""]]),o.locals&&(t.exports=o.locals);a(796)("762cdb96",o,!0)},935:function(t,e){t.exports={render:function(){var t=this,e=t.$createElement,a=t._self._c||e;return a("page-content",{attrs:{"page-title":"Components - Snackbar"}},[a("docs-component",[a("div",{slot:"description"},[a("p",[t._v("Snackbars contain a single line of text directly related to the operation performed. They may contain a text action, but no icons.")])]),t._v(" "),a("div",{slot:"api"},[a("api-table",{attrs:{name:"md-snackbar"}},[a("md-table",{slot:"properties"},[a("md-table-header",[a("md-table-row",[a("md-table-head",[t._v("Name")]),t._v(" "),a("md-table-head",[t._v("Type")]),t._v(" "),a("md-table-head",[t._v("Description")])],1)],1),t._v(" "),a("md-table-body",[a("md-table-row",[a("md-table-cell",[t._v("md-position")]),t._v(" "),a("md-table-cell",[a("code",[t._v("String")])]),t._v(" "),a("md-table-cell",[t._v("Specify which vertical and horizontal position the snackbar will take. Accepts "),a("code",[t._v("top left")]),t._v("|"),a("code",[t._v("top center")]),t._v("|"),a("code",[t._v("right center")]),t._v("|"),a("code",[t._v("bottom left")]),t._v("|"),a("code",[t._v("bottom center")]),t._v("|"),a("code",[t._v("bottom right")]),t._v(". Default: "),a("code",[t._v("bottom center")])])],1),t._v(" "),a("md-table-row",[a("md-table-cell",[t._v("md-duration")]),t._v(" "),a("md-table-cell",[a("code",[t._v("Number")])]),t._v(" "),a("md-table-cell",[t._v("The duration visibility in miliseconds. Default: "),a("code",[t._v("4000")])])],1)],1)],1),t._v(" "),a("md-table",{slot:"events"},[a("md-table-header",[a("md-table-row",[a("md-table-head",[t._v("Name")]),t._v(" "),a("md-table-head",[t._v("Value")]),t._v(" "),a("md-table-head",[t._v("Description")])],1)],1),t._v(" "),a("md-table-body",[a("md-table-row",[a("md-table-cell",[t._v("open")]),t._v(" "),a("md-table-cell",[t._v("None")]),t._v(" "),a("md-table-cell",[t._v("Triggered when the snackbar open.")])],1),t._v(" "),a("md-table-row",[a("md-table-cell",[t._v("close")]),t._v(" "),a("md-table-cell",[t._v("None")]),t._v(" "),a("md-table-cell",[t._v("Triggered when the snackbar closes.")])],1)],1)],1),t._v(" "),a("md-table",{slot:"methods"},[a("md-table-header",[a("md-table-row",[a("md-table-head",[t._v("Name")]),t._v(" "),a("md-table-head",[t._v("Description")])],1)],1),t._v(" "),a("md-table-body",[a("md-table-row",[a("md-table-cell",[t._v("open")]),t._v(" "),a("md-table-cell",[t._v("Opens the Snackbar.")])],1),t._v(" "),a("md-table-row",[a("md-table-cell",[t._v("close")]),t._v(" "),a("md-table-cell",[t._v("Closes the Snackbar.")])],1)],1)],1)],1)],1),t._v(" "),a("div",{slot:"example"},[a("example-box",{attrs:{"card-title":"Default"}},[a("div",{slot:"demo"},[a("form",{attrs:{novalidate:""},on:{submit:function(e){e.stopPropagation(),e.preventDefault(),t.open(e)}}},[a("div",[a("div",{staticClass:"md-body-2"},[t._v("Vertical")]),t._v(" "),a("md-radio",{attrs:{id:"top",name:"snackbar-vertical","md-value":"top"},model:{value:t.vertical,callback:function(e){t.vertical=e},expression:"vertical"}},[t._v("top")]),t._v(" "),a("md-radio",{attrs:{id:"bottom",name:"snackbar-vertical","md-value":"bottom"},model:{value:t.vertical,callback:function(e){t.vertical=e},expression:"vertical"}},[t._v("bottom")])],1),t._v(" "),a("div",[a("div",{staticClass:"md-body-2"},[t._v("Horizontal")]),t._v(" "),a("md-radio",{attrs:{id:"left",name:"snackbar-horizontal","md-value":"left"},model:{value:t.horizontal,callback:function(e){t.horizontal=e},expression:"horizontal"}},[t._v("left")]),t._v(" "),a("md-radio",{attrs:{id:"center",name:"snackbar-horizontal","md-value":"center"},model:{value:t.horizontal,callback:function(e){t.horizontal=e},expression:"horizontal"}},[t._v("center")]),t._v(" "),a("md-radio",{attrs:{id:"right",name:"snackbar-horizontal","md-value":"right"},model:{value:t.horizontal,callback:function(e){t.horizontal=e},expression:"horizontal"}},[t._v("right")])],1),t._v(" "),a("div",[a("div",{staticClass:"md-body-2"},[t._v("Delay")]),t._v(" "),a("md-input-container",[a("md-input",{attrs:{type:"number"},model:{value:t.duration,callback:function(e){t.duration=e},expression:"duration"}})],1)],1),t._v(" "),a("md-button",{staticClass:"md-primary md-raised",attrs:{type:"submit"}},[t._v("Open Snackbar")]),t._v(" "),a("md-snackbar",{ref:"snackbar",attrs:{"md-position":t.vertical+" "+t.horizontal,"md-duration":t.duration}},[a("span",[t._v("Connection timeout. Showing limited messages.")]),t._v(" "),a("md-button",{staticClass:"md-accent",attrs:{"md-theme":"light-blue"},nativeOn:{click:function(e){t.$refs.snackbar.close()}}},[t._v("Retry")])],1)],1)]),t._v(" "),a("div",{slot:"code"},[a("code-block",{attrs:{lang:"xml"}},[t._v('\n            <form novalidate @submit.stop.prevent="open">\n              <div>\n                <div class="md-body-2">Vertical</div>\n                <md-radio v-model="vertical" id="top" name="snackbar-vertical" md-value="top">top</md-radio>\n                <md-radio v-model="vertical" id="bottom" name="snackbar-vertical" md-value="bottom">bottom</md-radio>\n              </div>\n\n              <div>\n                <div class="md-body-2">Horizontal</div>\n                <md-radio v-model="horizontal" id="left" name="snackbar-horizontal" md-value="left">left</md-radio>\n                <md-radio v-model="horizontal" id="center" name="snackbar-horizontal" md-value="center">center</md-radio>\n                <md-radio v-model="horizontal" id="right" name="snackbar-horizontal" md-value="right">right</md-radio>\n              </div>\n\n              <div>\n                <div class="md-body-2">Delay</div>\n\n                <md-input-container>\n                  <md-input type="number" v-model="duration"></md-input>\n                </md-input-container>\n              </div>\n\n              <md-button type="submit" class="md-primary md-raised">Open Snackbar</md-button>\n\n              <md-snackbar :md-position="vertical + \' \' + horizontal" ref="snackbar" :md-duration="duration">\n                <span>Connection timeout. Showing limited messages.</span>\n                <md-button class="md-accent" md-theme="light-blue" @click.native="$refs.snackbar.close()">Retry</md-button>\n              </md-snackbar>\n            </form>\n          ')]),t._v(" "),a("code-block",{attrs:{lang:"javacript"}},[t._v("\n            export default {\n              data: () => ({\n                vertical: 'bottom',\n                horizontal: 'center',\n                duration: 4000\n              }),\n              methods: {\n                open() {\n                  this.$refs.snackbar.open();\n                }\n              }\n            };\n          ")])],1)])],1)]),t._v(" "),a("md-button",{staticClass:"md-fab md-fab-bottom-right"},[a("md-icon",[t._v("add")])],1)],1)},staticRenderFns:[]}}});