var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

require('../../../src/stylus/components/_pickers.styl');
require('../../../src/stylus/components/_date-picker.styl');

import { createRange } from '../../util/helpers';

import Picker from '../../mixins/picker';
import DateYears from './mixins/date-years';
import DateTitle from './mixins/date-title';
import DateHeader from './mixins/date-header';
import DateTable from './mixins/date-table';
import MonthTable from './mixins/month-table';
import VBtn from '../VBtn';
import VCard from '../VCard';
import VIcon from '../VIcon';

import Touch from '../../directives/touch';

var createDefaultDateFormat = function createDefaultDateFormat(type) {
  return function (date) {
    var pad = function pad(n) {
      return n < 10 ? '0' + n : '' + n;
    };
    var isoString = date.getFullYear() + '-' + pad(date.getMonth() + 1) + '-' + pad(date.getDate());
    return isoString.substr(0, { date: 10, month: 7, year: 4 }[type]);
  };
};

export default {
  name: 'v-date-picker',

  components: {
    VBtn: VBtn,
    VCard: VCard,
    VIcon: VIcon
  },

  mixins: [Picker, DateYears, DateTitle, DateHeader, DateTable, MonthTable],

  directives: { Touch: Touch },

  data: function data() {
    return {
      tableDate: new Date(),
      originalDate: this.value,
      currentDay: null,
      currentMonth: null,
      currentYear: null,
      isReversing: false,
      narrowDays: [],
      activePicker: this.type.toUpperCase()
    };
  },


  props: {
    locale: {
      type: String,
      default: 'en-us'
    },
    type: {
      type: String,
      default: 'date',
      validator: function validator(type) {
        return ['date', 'month' /*, 'year'*/].includes(type);
      }
    },
    dateFormat: {
      type: Function,
      default: null
    },
    titleDateFormat: {
      type: [Object, Function],
      default: null
    },
    headerDateFormat: {
      type: [Object, Function],
      default: function _default() {
        return { month: 'long', year: 'numeric' };
      }
    },
    monthFormat: {
      type: [Object, Function],
      default: function _default() {
        return { month: 'short' };
      }
    },
    formattedValue: {
      required: false
    },
    allowedDates: {
      type: [Array, Object, Function],
      default: function _default() {
        return null;
      }
    },
    firstDayOfWeek: {
      type: [String, Number],
      default: 0
    },
    yearIcon: String
  },

  computed: {
    timeZone: function timeZone() {
      try {
        var timeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;
        new Date('2000-01-15').toLocaleDateString('en', {
          day: 'numeric',
          timeZone: timeZone
        });
        return timeZone;
      } catch (e) {
        return 'UTC';
      }
    },
    supportsLocaleFormat: function supportsLocaleFormat() {
      return 'toLocaleDateString' in Date.prototype && new Date('2000-01-15').toLocaleDateString('en', {
        day: 'numeric',
        timeZone: 'UTC'
      }) === '15';
    },
    firstAllowedDate: function firstAllowedDate() {
      var date = new Date();

      if (this.type === 'month') {
        date.setDate(1);
        date.setHours(1);

        if (this.allowedDates) {
          var valid = new Date(date);
          for (var month = 0; month < 12; month++) {
            valid.setMonth(month);
            if (this.isAllowed(valid)) {
              return valid;
            }
          }
        }
      } else if (this.type === 'date') {
        date.setHours(1);
        var _month = date.getMonth();

        if (this.allowedDates) {
          var _valid = new Date(date);
          for (var i = 0; i < 31; i++) {
            if (date.getMonth() === _month && this.isAllowed(_valid)) return _valid;
            _valid.setDate(i);
          }
        }
      }

      return date;
    },

    inputDate: {
      get: function get() {
        var date = this.makeDate(this.value);
        return date == null ? this.firstAllowedDate : date;
      },
      set: function set(value) {
        var date = this.makeDate(value);
        var pickerDateFormat = createDefaultDateFormat(this.type);
        this.$emit('input', date == null ? this.originalDate : pickerDateFormat(date));
        this.$emit('update:formattedValue', (this.dateFormat || pickerDateFormat)(date == null ? this.makeDate(this.originalDate) || this.firstAllowedDate : date));
      }
    },
    day: function day() {
      return this.inputDate.getDate();
    },
    month: function month() {
      return this.inputDate.getMonth();
    },
    year: function year() {
      return this.inputDate.getFullYear();
    },
    tableMonth: function tableMonth() {
      return this.tableDate.getMonth();
    },
    tableYear: function tableYear() {
      return this.tableDate.getFullYear();
    },
    computedTransition: function computedTransition() {
      return this.isReversing ? 'tab-reverse-transition' : 'tab-transition';
    },
    titleText: function titleText() {
      var date = this.normalizeDate(this.year, this.month, this.day);

      var defaultTitleDateFormat = this.type === 'year' ? {
        year: 'numeric'
      } : this.type === 'month' ? {
        month: 'long'
      } : {
        weekday: 'short',
        month: 'short',
        day: 'numeric'
      };

      var titleText = void 0;
      if (typeof this.titleDateFormat === 'function') {
        titleText = this.titleDateFormat(date);
      } else if (this.supportsLocaleFormat) {
        titleText = date.toLocaleDateString(this.locale, Object.assign(this.titleDateFormat || defaultTitleDateFormat, {
          timeZone: this.timeZone
        }));
      } else if ('toLocaleDateString' in Date.prototype) {
        titleText = createDefaultDateFormat(this.type)(date);
      }

      if (this.landscape) {
        if (titleText.indexOf(',') > -1) titleText = titleText.replace(',', ',<br>');else if (titleText.indexOf(' ') > -1) titleText = titleText.replace(' ', '<br>');
      }

      return titleText;
    }
  },

  watch: {
    activePicker: function activePicker(val, prev) {
      var _this = this;

      if (val !== 'YEAR') return;

      // That's a quirk, setting timeout stopped working after fixing #1649
      // It worked but for timeouts significantly longer than the transition duration
      var interval = setInterval(function () {
        if (_this.$refs.years) {
          _this.$refs.years.scrollTop = _this.$refs.years.scrollHeight / 2 - 125;
          clearInterval(interval);
        }
      }, 100);
    },
    tableDate: function tableDate(val, prev) {
      this.isReversing = val < prev;
    },
    value: function value(val) {
      if (val) this.tableDate = this.inputDate;
    },
    type: function type(val) {
      if (val === 'month' && this.activePicker === 'DATE') {
        this.activePicker = 'MONTH';
      } else if (val === 'year') {
        this.activePicker = 'YEAR';
      }
    },
    firstDayOfWeek: function firstDayOfWeek() {
      this.getWeekDays();
    }
  },

  methods: {
    save: function save() {
      if (this.originalDate) {
        this.originalDate = this.value;
      } else {
        this.originalDate = this.inputDate;
      }

      if (this.$parent && this.$parent.isActive) this.$parent.isActive = false;
    },
    cancel: function cancel() {
      this.inputDate = this.originalDate;
      if (this.$parent && this.$parent.isActive) this.$parent.isActive = false;
    },
    getWeekDays: function getWeekDays() {
      var _this2 = this;

      var first = parseInt(this.firstDayOfWeek, 10);
      if (this.supportsLocaleFormat) {
        var date = this.normalizeDate(2000, 1, 7);
        var day = date.getDate() - date.getDay() + first;
        var format = { weekday: 'narrow' };
        this.narrowDays = createRange(7).map(function (i) {
          return _this2.normalizeDate(2000, 1, day + i).toLocaleDateString(_this2.locale, format);
        });
      } else {
        this.narrowDays = createRange(7).map(function (i) {
          return ['S', 'M', 'T', 'W', 'T', 'F', 'S'][(i + first) % 7];
        });
      }
    },
    isAllowed: function isAllowed(date) {
      var _this3 = this;

      if (!this.allowedDates) return true;

      if (Array.isArray(this.allowedDates)) {
        var format = createDefaultDateFormat(this.activePicker === 'MONTH' ? 'month' : 'date');
        date = format(this.makeDate(date));
        return !!this.allowedDates.find(function (allowedDate) {
          allowedDate = _this3.makeDate(allowedDate);
          return allowedDate && format(allowedDate) === date;
        });
      } else if (this.allowedDates instanceof Function) {
        return this.allowedDates(date);
      } else if (this.allowedDates instanceof Object) {
        var _format = createDefaultDateFormat(this.activePicker === 'MONTH' ? 'month' : 'date');
        var min = _format(this.makeDate(this.allowedDates.min));
        var max = _format(this.makeDate(this.allowedDates.max));
        date = _format(date);
        return (!min || min <= date) && (!max || max >= date);
      }

      return true;
    },
    genTableTouch: function genTableTouch(touchCallback) {
      return {
        name: 'touch',
        value: {
          left: function left(e) {
            return e.offsetX < -15 && touchCallback(1);
          },
          right: function right(e) {
            return e.offsetX > 15 && touchCallback(-1);
          }
        }
      };
    },
    genTable: function genTable(tableChildren, touchCallback) {
      var wheel = this.activePicker === 'MONTH' ? this.monthWheelScroll : this.dateWheelScroll;
      var options = {
        staticClass: 'picker--date__table',
        'class': {
          'picker--month__table': this.activePicker === 'MONTH'
        },
        on: this.scrollable ? { wheel: wheel } : undefined,
        directives: [this.genTableTouch(touchCallback)]
      };

      var table = this.$createElement('table', {
        key: this.activePicker === 'MONTH' ? this.tableYear : this.tableMonth
      }, tableChildren);

      return this.$createElement('div', options, [this.$createElement('transition', {
        props: { name: this.computedTransition }
      }, [table])]);
    },
    genPickerBody: function genPickerBody(h) {
      var _this4 = this;

      var pickerBodyChildren = [];
      if (this.activePicker === 'DATE') {
        pickerBodyChildren.push(h('div', { staticClass: 'picker--date__header' }, [this.genSelector()]));
        pickerBodyChildren.push(this.genTable([this.dateGenTHead(), this.dateGenTBody()], function (value) {
          return _this4.tableDate = _this4.normalizeDate(_this4.tableYear, _this4.tableMonth + value);
        }));
      } else if (this.activePicker === 'MONTH') {
        pickerBodyChildren.push(h('div', { staticClass: 'picker--date__header' }, [this.genSelector()]));
        pickerBodyChildren.push(this.genTable([this.monthGenTBody()], function (value) {
          return _this4.tableDate = _this4.normalizeDate(_this4.tableYear + value);
        }));
      } else if (this.activePicker === 'YEAR') {
        pickerBodyChildren.push(this.genYears());
      }

      return pickerBodyChildren;
    },
    makeDate: function makeDate(val) {
      if (val == null) return val;
      if (val instanceof Date) return val;
      if (!isNaN(val)) return new Date(val);

      var _val$trim$split$0$spl = val.trim().split(' ')[0].split('-'),
          _val$trim$split$0$spl2 = _slicedToArray(_val$trim$split$0$spl, 3),
          year = _val$trim$split$0$spl2[0],
          month = _val$trim$split$0$spl2[1],
          date = _val$trim$split$0$spl2[2];

      return this.normalizeDate(year, month ? month - 1 : 0, date ? date * 1 : 1);
    },
    normalizeDate: function normalizeDate(year) {
      var month = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var date = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;

      return new Date(year, month, date, 1 /* Workaround for #1409 */);
    }
  },

  created: function created() {
    this.getWeekDays();
    this.tableDate = this.inputDate;
  },
  mounted: function mounted() {
    var date = new Date();
    this.currentDay = date.getDate();
    this.currentMonth = date.getMonth();
    this.currentYear = date.getFullYear();
  },
  render: function render(h) {
    var children = [];

    !this.noTitle && children.push(this.genTitle(this.titleText));

    children.push(h('transition', {
      props: {
        origin: 'center center',
        mode: 'out-in',
        name: 'scale-transition'
      }
    }, [h('div', {
      staticClass: 'picker__body',
      key: this.activePicker
    }, this.genPickerBody(h))]));

    this.$scopedSlots.default && children.push(this.genSlot());

    return h('v-card', {
      staticClass: 'picker picker--date',
      'class': _extends({
        'picker--landscape': this.landscape
      }, this.themeClasses)
    }, children);
  }
};