export default {
  methods: {
    dateWheelScroll: function dateWheelScroll(e) {
      e.preventDefault();

      var month = this.tableMonth;

      if (e.deltaY < 0) month++;else month--;

      this.tableDate = this.normalizeDate(this.tableYear, month);
    },
    dateGenTHead: function dateGenTHead() {
      var _this = this;

      var days = this.narrowDays.map(function (day) {
        return _this.$createElement('th', day);
      });
      return this.$createElement('thead', this.dateGenTR(days));
    },
    dateClick: function dateClick(day) {
      var _this2 = this;

      this.inputDate = this.normalizeDate(this.tableYear, this.tableMonth, day);
      this.$nextTick(function () {
        return _this2.autosave && _this2.save();
      });
    },
    dateGenButtonText: function dateGenButtonText(date, day) {
      return this.supportsLocaleFormat ? date.toLocaleDateString(this.locale, {
        day: 'numeric',
        timeZone: this.timeZone
      }) : day;
    },
    dateGenTD: function dateGenTD(day) {
      var _this3 = this;

      var date = this.normalizeDate(this.tableYear, this.tableMonth, day);
      var buttonText = this.dateGenButtonText(date, day);
      var button = this.$createElement('button', {
        staticClass: 'btn btn--date-picker btn--floating btn--small btn--flat',
        'class': {
          'btn--active': this.dateIsActive(day),
          'btn--outline': this.dateIsCurrent(day) && !this.dateIsActive(day),
          'btn--disabled': !this.isAllowed(date)
        },
        attrs: {
          type: 'button'
        },
        domProps: {
          innerHTML: '<span class="btn__content">' + buttonText + '</span>'
        },
        on: {
          click: function click() {
            return _this3.dateClick(day);
          }
        }
      });

      return this.$createElement('td', [button]);
    },
    dateGenTBody: function dateGenTBody() {
      var children = [];
      var daysInMonth = this.normalizeDate(this.tableYear, this.tableMonth + 1, 0).getDate();
      var rows = [];
      var day = (this.normalizeDate(this.tableYear, this.tableMonth).getDay() - parseInt(this.firstDayOfWeek) + 7) % 7;

      for (var i = 0; i < day; i++) {
        rows.push(this.$createElement('td'));
      }

      for (var _i = 1; _i <= daysInMonth; _i++) {
        rows.push(this.dateGenTD(_i));

        if (rows.length % 7 === 0) {
          children.push(this.dateGenTR(rows));
          rows = [];
        }
      }

      if (rows.length) {
        children.push(this.dateGenTR(rows));
      }

      children.length < 6 && children.push(this.dateGenTR([this.$createElement('td', { domProps: { innerHTML: '&nbsp;' } })]));

      return this.$createElement('tbody', children);
    },
    dateGenTR: function dateGenTR() {
      var children = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      return [this.$createElement('tr', data, children)];
    },
    dateIsActive: function dateIsActive(i) {
      return this.tableYear === this.year && this.tableMonth === this.month && this.day === i;
    },
    dateIsCurrent: function dateIsCurrent(i) {
      return this.currentYear === this.tableYear && this.currentMonth === this.tableMonth && this.currentDay === i;
    }
  }
};