export default {
  methods: {
    monthWheelScroll: function monthWheelScroll(e) {
      e.preventDefault();

      var year = this.tableYear;

      if (e.deltaY < 0) year++;else year--;

      this.tableDate = this.normalizeDate(year);
    },
    monthClick: function monthClick(month) {
      var _this = this;

      this.inputDate = this.normalizeDate(this.tableYear, month, this.day);
      if (this.type === 'date') {
        this.activePicker = 'DATE';
      } else {
        this.$nextTick(function () {
          return _this.autosave && _this.save();
        });
      }
    },
    monthGenTD: function monthGenTD(month) {
      var _this2 = this;

      var date = this.normalizeDate(this.tableYear, month);
      var monthName = void 0;

      if (typeof this.monthFormat === 'function') {
        monthName = this.monthFormat(date);
      } else if (this.supportsLocaleFormat) {
        monthName = date.toLocaleDateString(this.locale, Object.assign(this.monthFormat, {
          timeZone: this.timeZone
        }));
      } else {
        monthName = date.getMonth() + 1;
        if (monthName < 10) {
          monthName = '0' + monthName;
        }
      }

      return this.$createElement('td', [this.$createElement('button', {
        'class': {
          'btn btn--date-picker': true,
          'btn--raised': this.monthIsActive(month),
          'btn--flat': true,
          'btn--active': this.monthIsActive(month),
          'btn--outline': this.monthIsCurrent(month) && !this.monthIsActive(month),
          'btn--disabled': this.type === 'month' && !this.isAllowed(date)
        },
        attrs: {
          type: 'button'
        },
        domProps: {
          innerHTML: '<span class="btn__content">' + monthName + '</span>'
        },
        on: {
          click: function click() {
            return _this2.monthClick(month);
          }
        }
      })]);
    },
    monthGenTBody: function monthGenTBody() {
      var _this3 = this;

      var children = [];
      var cols = Array(3).fill(null);
      var rows = 12 / cols.length;

      var _loop = function _loop(row) {
        children.push(_this3.$createElement('tr', cols.map(function (_, col) {
          return _this3.monthGenTD(row * cols.length + col);
        })));
      };

      for (var row = 0; row < rows; row++) {
        _loop(row);
      }

      return this.$createElement('tbody', children);
    },
    monthIsActive: function monthIsActive(i) {
      return this.tableYear === this.year && this.month === i;
    },
    monthIsCurrent: function monthIsCurrent(i) {
      return this.currentYear === this.tableYear && this.currentMonth === i;
    }
  }
};