import load from '../../util/load';

var Vuetify = {
  install: function install(Vue) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var $vuetify = {
      load: load,
      application: {
        bar: 0,
        top: 0,
        bottom: 0,
        left: 0,
        right: 0
      },
      breakpoint: {},
      touchSupport: false
    };

    Vue.util.defineReactive({}, 'breakpoint', $vuetify);
    Vue.util.defineReactive({}, 'application', $vuetify);

    Vue.prototype.$vuetify = $vuetify;

    if (opts.transitions) {
      Object.keys(opts.transitions).forEach(function (key) {
        var t = opts.transitions[key];
        if (t.name !== undefined && t.name.startsWith('v-')) {
          Vue.component(t.name, t);
        }
      });
    }

    if (opts.directives) {
      Object.keys(opts.directives).forEach(function (key) {
        var d = opts.directives[key];
        Vue.directive(d.name, d);
      });
    }

    if (opts.components) {
      Object.keys(opts.components).forEach(function (key) {
        var c = opts.components[key];
        Vue.use(c);
      });
    }
  }
};

export default Vuetify;