function inserted(el, binding) {
  var cb = binding.value;
  var debounce = 200;

  if (typeof binding.value !== 'function') {
    cb = binding.value.value;
    debounce = binding.value.debounce;
  }

  var debounceTimeout = setTimeout(cb, debounce);
  var onResize = function onResize() {
    clearTimeout(debounceTimeout);
    debounceTimeout = setTimeout(cb, debounce);
  };

  window.addEventListener('resize', onResize, { passive: true });
  el._onResize = onResize;

  onResize();
}

function unbind(el, binding) {
  window.removeEventListener('resize', el._onResize);
}

export default {
  name: 'resize',
  inserted: inserted,
  unbind: unbind
};