import Bootable from './bootable';

export default {
  mixins: [Bootable],

  props: {
    contentClass: {
      default: ''
    }
  },

  mounted: function mounted() {
    this.$vuetify.load(this.initDetach);
  },
  beforeDestroy: function beforeDestroy() {
    if (!this.$refs.content) return;

    // IE11 Fix
    try {
      this.$refs.content.parentNode.removeChild(this.$refs.content);
    } catch (e) {}
  },


  methods: {
    initDetach: function initDetach() {
      if (this._isDestroyed) return;

      var app = document.querySelector('[data-app]');

      if (!app) {
        return console.warn('Application is missing <v-app> component.');
      }

      // If child has already been removed, bail
      if (!this.$refs.content) return;

      app.insertBefore(this.$refs.content, app.firstChild);
    }
  }
};