<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2;

use Twilio\Options;
use Twilio\Values;

abstract class VerificationAttemptOptions {
    /**
     * @param \DateTime $dateCreatedAfter Filter verification attempts after this
     *                                    date.
     * @param \DateTime $dateCreatedBefore Filter verification attempts before this
     *                                     date.
     * @param string $channelDataTo Filters by destination of the verification
     *                              attempt.
     * @param string $country Filter verification attempts by destination country.
     * @param string $channel Filter verification attempts by communication channel.
     * @param string $verifyServiceSid Filter verification attempts by verify
     *                                 service.
     * @param string $verificationSid Filter attempts by verification.
     * @param string $status Filter verification attempts by conversion status.
     * @return ReadVerificationAttemptOptions Options builder
     */
    public static function read(\DateTime $dateCreatedAfter = Values::NONE, \DateTime $dateCreatedBefore = Values::NONE, string $channelDataTo = Values::NONE, string $country = Values::NONE, string $channel = Values::NONE, string $verifyServiceSid = Values::NONE, string $verificationSid = Values::NONE, string $status = Values::NONE): ReadVerificationAttemptOptions {
        return new ReadVerificationAttemptOptions($dateCreatedAfter, $dateCreatedBefore, $channelDataTo, $country, $channel, $verifyServiceSid, $verificationSid, $status);
    }
}

class ReadVerificationAttemptOptions extends Options {
    /**
     * @param \DateTime $dateCreatedAfter Filter verification attempts after this
     *                                    date.
     * @param \DateTime $dateCreatedBefore Filter verification attempts before this
     *                                     date.
     * @param string $channelDataTo Filters by destination of the verification
     *                              attempt.
     * @param string $country Filter verification attempts by destination country.
     * @param string $channel Filter verification attempts by communication channel.
     * @param string $verifyServiceSid Filter verification attempts by verify
     *                                 service.
     * @param string $verificationSid Filter attempts by verification.
     * @param string $status Filter verification attempts by conversion status.
     */
    public function __construct(\DateTime $dateCreatedAfter = Values::NONE, \DateTime $dateCreatedBefore = Values::NONE, string $channelDataTo = Values::NONE, string $country = Values::NONE, string $channel = Values::NONE, string $verifyServiceSid = Values::NONE, string $verificationSid = Values::NONE, string $status = Values::NONE) {
        $this->options['dateCreatedAfter'] = $dateCreatedAfter;
        $this->options['dateCreatedBefore'] = $dateCreatedBefore;
        $this->options['channelDataTo'] = $channelDataTo;
        $this->options['country'] = $country;
        $this->options['channel'] = $channel;
        $this->options['verifyServiceSid'] = $verifyServiceSid;
        $this->options['verificationSid'] = $verificationSid;
        $this->options['status'] = $status;
    }

    /**
     * Datetime filter used to query Verification Attempts created after this datetime. Given as GMT in RFC 2822 format.
     *
     * @param \DateTime $dateCreatedAfter Filter verification attempts after this
     *                                    date.
     * @return $this Fluent Builder
     */
    public function setDateCreatedAfter(\DateTime $dateCreatedAfter): self {
        $this->options['dateCreatedAfter'] = $dateCreatedAfter;
        return $this;
    }

    /**
     * Datetime filter used to query Verification Attempts created before this datetime. Given as GMT in RFC 2822 format.
     *
     * @param \DateTime $dateCreatedBefore Filter verification attempts before this
     *                                     date.
     * @return $this Fluent Builder
     */
    public function setDateCreatedBefore(\DateTime $dateCreatedBefore): self {
        $this->options['dateCreatedBefore'] = $dateCreatedBefore;
        return $this;
    }

    /**
     * Destination of a verification. It is phone number in E.164 format.
     *
     * @param string $channelDataTo Filters by destination of the verification
     *                              attempt.
     * @return $this Fluent Builder
     */
    public function setChannelDataTo(string $channelDataTo): self {
        $this->options['channelDataTo'] = $channelDataTo;
        return $this;
    }

    /**
     * Filter used to query Verification Attempts sent to the specified destination country.
     *
     * @param string $country Filter verification attempts by destination country.
     * @return $this Fluent Builder
     */
    public function setCountry(string $country): self {
        $this->options['country'] = $country;
        return $this;
    }

    /**
     * Filter used to query Verification Attempts by communication channel. Valid values are `SMS` and `CALL`
     *
     * @param string $channel Filter verification attempts by communication channel.
     * @return $this Fluent Builder
     */
    public function setChannel(string $channel): self {
        $this->options['channel'] = $channel;
        return $this;
    }

    /**
     * Filter used to query Verification Attempts by verify service. Only attempts of the provided SID will be returned.
     *
     * @param string $verifyServiceSid Filter verification attempts by verify
     *                                 service.
     * @return $this Fluent Builder
     */
    public function setVerifyServiceSid(string $verifyServiceSid): self {
        $this->options['verifyServiceSid'] = $verifyServiceSid;
        return $this;
    }

    /**
     * Filter used to return all the Verification Attempts of a single verification. Only attempts of the provided verification SID will be returned.
     *
     * @param string $verificationSid Filter attempts by verification.
     * @return $this Fluent Builder
     */
    public function setVerificationSid(string $verificationSid): self {
        $this->options['verificationSid'] = $verificationSid;
        return $this;
    }

    /**
     * Filter used to query Verification Attempts by conversion status. Valid values are `UNCONVERTED`, for attempts that were not converted, and `CONVERTED`, for attempts that were confirmed.
     *
     * @param string $status Filter verification attempts by conversion status.
     * @return $this Fluent Builder
     */
    public function setStatus(string $status): self {
        $this->options['status'] = $status;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.ReadVerificationAttemptOptions ' . $options . ']';
    }
}